/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.action;
import com.veromodo.tioa.automaton.funcDecl;
import com.veromodo.tioa.automaton.schedule;
import com.veromodo.tioa.automaton.stateVariable;
import com.veromodo.tioa.automaton.task;
import com.veromodo.tioa.automaton.trajectory;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.automaton.yieldprogram;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortTuple;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.notions.vocabRef;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;

public class automaton
extends Unit
implements Cloneable {
    private String name;
    protected formal[] formals;
    private int nVarFormals;
    private int nTypeFormals;
    protected factoring formalFactors;
    private term where;
    protected vocabRef[] vocab;
    protected action[] actions;
    private factoring actionFactors;
    protected stateVariable[] stateVariables;
    protected variable[] primedStateVariables;
    private variable statesVar;
    private variable primedStatesVar;
    private sortTuple statesSortTuple;
    private term initially;
    yieldprogram initProg;
    private funcDecl[] funcDecls;
    private transition[] transitions;
    protected trajectory[] trajectories;
    protected task[] tasks;
    private schedule sched;
    private automaton desugaredAutomaton = null;

    public String name() {
        return this.name;
    }

    public int nFormals() {
        return this.formals.length;
    }

    public int nVarFormals() {
        return this.nVarFormals;
    }

    public int nTypeFormals() {
        return this.nTypeFormals;
    }

    public formal formal(int n) {
        return this.formals[n];
    }

    public term where() {
        return this.where;
    }

    public int nVocabRefs() {
        return this.vocab.length;
    }

    public vocabRef vocabRef(int n) {
        return this.vocab[n];
    }

    public int nActions() {
        return this.actions.length;
    }

    public action action(int n) {
        return this.actions[n];
    }

    public action[] actionsByName(String name) {
        HashSet<action> acts = new HashSet<action>();
        int i = 0;
        while (i < this.nActions()) {
            if (this.actions[i].name().equals(name)) {
                acts.add(this.actions[i]);
            }
            ++i;
        }
        return acts.toArray(new action[acts.size()]);
    }

    public action[] actionsByKind(action.kinds kind2) {
        HashSet<action> acts = new HashSet<action>();
        int i = 0;
        while (i < this.nActions()) {
            if (this.actions[i].kind() == kind2) {
                acts.add(this.actions[i]);
            }
            ++i;
        }
        return acts.toArray(new action[acts.size()]);
    }

    public stateVariable stateVariable(int n) {
        return this.stateVariables[n];
    }

    public variable primedStateVariable(int n) {
        return this.primedStateVariables[n];
    }

    public int nStateVariables() {
        return this.stateVariables.length;
    }

    public variable statesVar() {
        return this.statesVar;
    }

    public variable primedStatesVar() {
        return this.primedStatesVar;
    }

    public sortTuple statesSortTuple() {
        return this.statesSortTuple;
    }

    public term initially() {
        return this.initially;
    }

    yieldprogram initProg() {
        return this.initProg;
    }

    public int nFuncDecls() {
        return this.funcDecls.length;
    }

    public funcDecl funcDecl(int n) {
        return this.funcDecls[n];
    }

    public int nTransitions() {
        return this.transitions.length;
    }

    public transition transition(int n) {
        return this.transitions[n];
    }

    public transition[] transitionsByName(String name) {
        HashSet<transition> trans = new HashSet<transition>();
        int i = 0;
        while (i < this.nTransitions()) {
            if (this.transitions[i].theAction().name().equals(name)) {
                trans.add(this.transitions[i]);
            }
            ++i;
        }
        return trans.toArray(new transition[trans.size()]);
    }

    public int nTtrajectories() {
        return this.trajectories.length;
    }

    public trajectory trajectory(int n) {
        return this.trajectories[n];
    }

    public int nTasks() {
        return this.tasks.length;
    }

    public task task(int n) {
        return this.tasks[n];
    }

    public schedule schedule() {
        return this.sched;
    }

    public boolean desugared() {
        return this == this.desugaredAutomaton;
    }

    protected automaton() {
    }

    public automaton(String name, formal[] formals, term where, vocabRef[] vocab, action[] actions2, variable statesVar, variable primedStatesVar, stateVariable[] stateVariables, variable[] primedStateVariables, term initially, yieldprogram initProg, funcDecl[] funcDecls, transition[] transitions, trajectory[] trajectories, task[] tasks, schedule sched) {
        this(name, formals, new factoring(formals.length), where, vocab, actions2, new factoring(actions2.length), statesVar, primedStatesVar, stateVariables, primedStateVariables, initially, initProg, funcDecls, transitions, trajectories, tasks, sched);
    }

    public automaton(String name, formal[] formals, factoring formalFactors, term where, vocabRef[] vocab, action[] actions2, factoring actionFactors, variable statesVar, variable primedStatesVar, stateVariable[] stateVariables, variable[] primedStateVariables, term initially, yieldprogram initProg, funcDecl[] funcDecls, transition[] transitions, trajectory[] trajectories, task[] tasks, schedule sched) {
        if (formals.length != formalFactors.size() || actions2.length != actionFactors.size()) {
            throw new InternalError("automaton constructor");
        }
        this.name = name;
        this.formals = formals;
        this.nVarFormals = 0;
        this.nTypeFormals = 0;
        int i = 0;
        while (i < formals.length) {
            switch (formals[i].kind()) {
                case VAR: {
                    ++this.nVarFormals;
                    break;
                }
                case TYPE: {
                    ++this.nTypeFormals;
                    break;
                }
                default: {
                    throw new InternalError("automaton constructor formal");
                }
            }
            ++i;
        }
        this.formalFactors = formalFactors;
        this.where = where == null ? booleans.trueTerm : where;
        this.vocab = vocab;
        this.actions = actions2;
        this.actionFactors = actionFactors;
        this.statesVar = statesVar;
        this.primedStatesVar = primedStatesVar;
        this.stateVariables = stateVariables;
        this.primedStateVariables = primedStateVariables;
        if (stateVariables.length > 0) {
            String[] statesFields = new String[stateVariables.length];
            sort[] statesSorts = new sort[stateVariables.length];
            int i2 = 0;
            while (i2 < stateVariables.length) {
                statesFields[i2] = stateVariables[i2].variable().id();
                statesSorts[i2] = stateVariables[i2].variable().sort();
                ++i2;
            }
            this.statesSortTuple = new sortTuple(statesVar.sort(), statesFields, statesSorts);
        } else {
            this.statesSortTuple = null;
        }
        this.initially = initially == null ? booleans.trueTerm : initially;
        this.initProg = initProg;
        this.funcDecls = funcDecls;
        this.transitions = transitions;
        this.trajectories = trajectories;
        this.tasks = tasks;
        this.sched = sched;
    }

    public prettyprinter print(prettyprinter pp) {
        pp.align().fill().put("automaton").blank();
        if (this.nFormals() == 0) {
            pp.put(this.name);
        } else {
            pp.fill().print(this.name).blank(0);
            formal.print(pp, this.formals, this.formalFactors).end();
            if (!this.where.isTrue()) {
                pp.blank().put("where").blank().print(this.where);
            }
        }
        pp.end().eol();
        if (this.vocab.length > 0) {
            pp.fill().put("imports").blank().list(this.vocab, ",").end().eol();
        }
        pp = this.printThisKindOfAutomaton(pp);
        return pp.end();
    }

    protected prettyprinter printThisKindOfAutomaton(prettyprinter pp) {
        pp.fill().put("signature").eol().blist(this.actions, "").end().eol();
        pp.fill().put("states").eol().blist(this.stateVariables, ",");
        if (!this.initially.isTrue()) {
            pp.eol().fill().blank().put("initially").blank().print(this.initially()).end();
            if (this.initProg != null) {
                pp.eol().fill("det".length() + 1).put("det").blank();
                pp.put("do").blank().eol();
                pp.blist(this.initProg.statements, ";").end().eol().put("od");
            }
        }
        pp.end();
        if (this.funcDecls.length > 0) {
            pp.eol().fill().put("let").eol().blist(this.funcDecls, ";").end();
        }
        pp.eol().fill().put("transitions").eol().blist(this.transitions, "").end();
        if (this.trajectories.length > 0) {
            pp.eol().fill().put("trajectories").eol().blist(this.trajectories, "").end();
        }
        if (this.tasks.length > 1) {
            pp.eol().fill().put("tasks").put(String.valueOf(this.tasks.length)).eol().blist(this.tasks, ";").end();
        }
        if (this.sched != null) {
            pp.eol().fill().print(this.sched).end();
        }
        return pp;
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        int i;
        SList list = SExp.makeSList(SExp.makeSValue("automaton"));
        list.add(SExp.makeSValue(this.name));
        if (this.nFormals() > 0) {
            SList list2 = SExp.makeSList(SExp.makeSValue("formals"));
            i = 0;
            while (i < this.formals.length) {
                list2.add(this.formals[i].toSValue());
                ++i;
            }
            list.add(list2);
        }
        if (!this.where.isTrue()) {
            SList list3 = SExp.makeSList(SExp.makeSValue("where"), this.where.toSValue());
            list.add(list3);
        }
        list.add(this.thisKindOfAutomatonToSValue());
        if (this.vocab.length > 0) {
            SList list4 = new SList();
            list4.add(SExp.makeSValue("imports"));
            i = 0;
            while (i < this.vocab.length) {
                list4.add(this.vocab[i].toSValue());
                ++i;
            }
            list.add(list4);
        }
        return list;
    }

    protected SValue thisKindOfAutomatonToSValue() {
        int c;
        SList sigList = SExp.makeSList(SExp.makeSValue("actions"));
        int i = 0;
        while (i < this.actions.length) {
            sigList.add(this.actions[i].toSValue());
            ++i;
        }
        SList list = SExp.makeSList(sigList);
        SList statesList = SExp.makeSList(SExp.makeSValue("states"));
        if (!this.initially.isTrue()) {
            SList initList = SExp.makeSList(SExp.makeSValue("initially"));
            initList.add(this.initially.toSValue());
            statesList.add(initList);
            if (this.initProg != null) {
                statesList.add(this.initProg.toSValue());
            }
        }
        int j = 0;
        while (j < this.stateVariables.length) {
            statesList.add(this.stateVariables[j].toSValue());
            ++j;
        }
        list.add(statesList);
        if (this.funcDecls.length > 0) {
            SList funcList = SExp.makeSList(SExp.makeSValue("let"));
            c = 0;
            while (c < this.funcDecls.length) {
                funcList.add(this.funcDecls[c].toSValue());
                ++c;
            }
            list.add(funcList);
        }
        SList tranList = SExp.makeSList(SExp.makeSValue("transitions"));
        c = 0;
        while (c < this.transitions.length) {
            tranList.add(this.transitions[c].toSValue());
            ++c;
        }
        list.add(tranList);
        SList trajList = SExp.makeSList(SExp.makeSValue("trajectories"));
        int c2 = 0;
        while (c2 < this.trajectories.length) {
            trajList.add(this.trajectories[c2].toSValue());
            ++c2;
        }
        list.add(trajList);
        if (this.tasks.length > 0 && this.tasks[0] != null) {
            SList taskList = SExp.makeSList(SExp.makeSValue("tasks"));
            int k = 0;
            while (k < this.tasks.length) {
                taskList.add(this.tasks[k].toSValue());
                ++k;
            }
            list.add(taskList);
        }
        if (this.sched != null) {
            list.add(this.sched.toSValue());
        }
        return list;
    }
}

