/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.varMap;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.quantifier;
import com.veromodo.tioa.notions.simplify;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;
import java.util.Iterator;

public class actionSet
extends Unit
implements SPrintable {
    private String name;
    private term[] actuals;
    private variable[] canonicals;
    private term where;
    private actionSet desugaredActionSet;

    public String name() {
        return this.name;
    }

    public term actual(int n) {
        return this.actuals[n];
    }

    public int nActuals() {
        return this.actuals.length;
    }

    public term where() {
        return this.where;
    }

    public actionSet(String name, term[] actuals, term where) {
        this.name = name;
        this.actuals = actuals;
        this.where = where;
        this.desugaredActionSet = null;
    }

    public boolean equals(Object obj) {
        return obj instanceof actionSet ? this.equals((actionSet)obj) : false;
    }

    public boolean equals(actionSet as) {
        if (as == null || !this.name.equals(as.name) || !this.where.equals(as.where) || this.actuals.length != as.actuals.length) {
            return false;
        }
        int i = 0;
        while (i < this.actuals.length) {
            if (!this.actuals[i].equals(as.actuals[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public actionSet desugar(variable[] canonicals) {
        if (this.desugaredActionSet != null) {
            if (canonicals != this.desugaredActionSet.canonicals) {
                throw new InternalError("actionSet.desugar");
            }
            return this.desugaredActionSet;
        }
        if (this.actuals.length != canonicals.length) {
            throw new InternalError("actionSet.desugar: Bad canonical number");
        }
        int i = 0;
        while (i < this.actuals.length) {
            if (!this.actuals[i].sort().equals(canonicals[i].sort())) {
                throw new InternalError("actionSet.desugar: Bad canonical sort");
            }
            ++i;
        }
        HashSet<variable> freeVars = new HashSet<variable>();
        int i2 = 0;
        while (i2 < this.actuals.length) {
            HashSet<variable> actualVars = this.actuals[i2].freeVars();
            for (variable av : actualVars) {
                if (av.kind() != 7) continue;
                freeVars.add(av);
            }
            ++i2;
        }
        varMap desugMap = new varMap();
        HashSet<variable> canVars = new HashSet<variable>();
        int i3 = 0;
        while (i3 < canonicals.length) {
            canVars.add(canonicals[i3]);
            ++i3;
        }
        HashSet<variable> existVars = new HashSet<variable>();
        Iterator it = freeVars.iterator();
        while (it.hasNext()) {
            variable fv = ((variable)it.next()).intern();
            variable fv1 = canVars.contains(fv) ? fv.makeDifferentExternal() : fv;
            variable ev = new variable(fv1.id(), fv1.sort(), 15, fv1.scopingInfo()).intern();
            existVars.add(ev);
            desugMap.add(fv, ev);
        }
        term dWhere = desugMap.map(this.where);
        term[] dActuals = new term[canonicals.length];
        int i4 = 0;
        while (i4 < this.actuals.length) {
            dActuals[i4] = new term(canonicals[i4]);
            term[] args = new term[]{dActuals[i4], desugMap.map(this.actuals[i4])};
            term paramsEq = new term(operator.eqOp(dActuals[i4].sort()), args);
            dWhere = booleans.conjoin(paramsEq, dWhere);
            ++i4;
        }
        Iterator i22 = existVars.iterator();
        while (i22.hasNext()) {
            dWhere = new term(new quantifier(quantifier.EXISTS, (variable)i22.next()), dWhere);
        }
        dWhere = simplify.iterate(dWhere, new Context());
        this.desugaredActionSet = new actionSet(this.name, dActuals, dWhere);
        this.desugaredActionSet.canonicals = canonicals;
        this.desugaredActionSet.desugaredActionSet = this.desugaredActionSet;
        return this.desugaredActionSet;
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill().put(this.name);
        if (this.nActuals() > 0) {
            pp.blank(0).fill(1).put("(");
            pp.list(this.actuals, ",");
            pp.put(")").end();
        }
        if (!this.where.isTrue()) {
            pp.blank().fill().put("where").blank().print(this.where).end();
        }
        return pp.end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(SExp.makeSValue(this.name));
        if (this.nActuals() > 0) {
            SList list1 = SExp.makeSList(SExp.makeSValue("actuals"));
            int i = 0;
            while (i < this.actuals.length) {
                list1.add(this.actuals[i].toSValue());
                ++i;
            }
            list.add(list1);
        }
        if (!this.where.isTrue()) {
            SList list2 = SExp.makeSList(SExp.makeSValue("where"));
            list2.add(this.where.toSValue());
            list.add(list2);
        }
        return list;
    }

    public String toString() {
        String s = this.name;
        if (this.nActuals() > 0) {
            s = String.valueOf(s) + "(";
            s = String.valueOf(s) + this.actuals[0];
            int i = 1;
            while (i < this.actuals.length) {
                s = String.valueOf(s) + ", " + this.actuals[i];
                ++i;
            }
            s = String.valueOf(s) + ")";
        }
        if (!this.where.isTrue()) {
            s = String.valueOf(s) + " where " + this.where;
        }
        return s;
    }
}

