/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.automaton;

import com.veromodo.tioa.automaton.automaton;
import com.veromodo.tioa.automaton.transition;
import com.veromodo.tioa.automaton.varMap;
import com.veromodo.tioa.notions.Context;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.simplify;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.util.factoring;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.HashSet;

public class action
extends Unit
implements SPrintable {
    private String name;
    private int actionIndex;
    private kinds kind;
    protected formal[] formals;
    private factoring formalFactors;
    private term where;
    protected transition[] transitions;
    private action desugaredAction;

    public String name() {
        return this.name;
    }

    public int index() {
        return this.actionIndex;
    }

    public kinds kind() {
        return this.kind;
    }

    public String kindAsString() {
        return action.kind2String(this.kind);
    }

    public String kindAsILString() {
        return action.kind2ILString(this.kind);
    }

    public String kindAsSortName() {
        return action.kind2SortName(this.kind);
    }

    public int nFormals() {
        return this.formals.length;
    }

    public formal formal(int n) {
        return this.formals[n];
    }

    public factoring formalFactors() {
        return this.formalFactors;
    }

    public term where() {
        return this.where;
    }

    public int nTransitions() {
        return this.transitions.length;
    }

    public transition transition(int n) {
        return this.transitions[n];
    }

    public boolean desugared() {
        return this == this.desugaredAction;
    }

    public action(int index, String name, kinds kind2, formal[] formals, factoring formalFactors, term where) {
        this.actionIndex = index;
        this.name = name;
        this.kind = kind2;
        this.formals = formals;
        this.formalFactors = formalFactors;
        this.where = where == null ? booleans.trueTerm : where;
        this.transitions = new transition[0];
        this.desugaredAction = null;
    }

    public action desugar(automaton a, Context x) {
        if (this.desugaredAction != null) {
            return this.desugaredAction;
        }
        if (a == null) {
            throw new InternalError("action.desugar(automaton,Context)");
        }
        formal[] dFormals = new formal[this.nFormals()];
        int i = 0;
        while (i < dFormals.length) {
            variable v;
            switch (this.formal(i).kind()) {
                case VAR: {
                    v = this.formal(i).var();
                    int j = 0;
                    while (j < a.nStateVariables()) {
                        if (a.stateVariable(j).toString().equals(this.formal(i).toString())) {
                            v = v.makeDifferentExternal();
                        }
                        ++j;
                    }
                    break;
                }
                case CONST: {
                    v = new variable(this.formal(i).sort().toString().substring(0, 1), this.formal(i).sort(), 2);
                    v = v.makeDifferentExternal();
                    break;
                }
                default: {
                    throw new InternalError("action.desugar(automaton, Context)");
                }
            }
            dFormals[i] = new formal(v);
            ++i;
        }
        return this.desugar(a, dFormals, x);
    }

    public action desugar(automaton a, formal[] f, Context x) {
        if (f == null || f.length != this.nFormals()) {
            throw new InternalError("action.desugar(automaton, formal[], Context)");
        }
        if (this.desugaredAction != null && f == this.desugaredAction.formals) {
            return this.desugaredAction;
        }
        term dWhere = this.where;
        varMap desugMap = new varMap();
        int i = 0;
        while (i < f.length) {
            if (f[i].kind() != formal.kind.VAR) {
                throw new InternalError("action.desugar(automaton, formal[], Context)");
            }
            switch (this.formal(i).kind()) {
                case VAR: {
                    desugMap.add(this.formal(i).var(), f[i].var());
                    break;
                }
                case CONST: {
                    term[] args = new term[]{new term(f[i].var()), this.formal(i).constant()};
                    term t = new term(operator.eqOp(f[i].var().sort()), args);
                    dWhere = booleans.conjoin(t, dWhere);
                    break;
                }
                default: {
                    throw new InternalError("action.desugar(automaton, formal[], Context)");
                }
            }
            ++i;
        }
        dWhere = simplify.iterate(desugMap.map(dWhere), x);
        factoring factors = new factoring();
        this.desugaredAction.desugaredAction = this.desugaredAction = new action(this.actionIndex, this.name, this.kind, f, factors, dWhere);
        Context x1 = x.copy();
        x1.assertTrue(dWhere);
        this.desugaredAction.setTransitions(this.desugarTransitions(a, x1));
        return this.desugaredAction;
    }

    private transition[] desugarTransitions(automaton a, Context x) {
        HashSet<variable> avoidVars = new HashSet<variable>();
        term[] selectTerms = new term[a.nStateVariables()];
        term[] primedSelectTerms = new term[a.nStateVariables()];
        term[] args = new term[]{new term(a.statesVar())};
        term[] pArgs = new term[]{new term(a.primedStatesVar())};
        int i = 0;
        while (i < a.nFormals()) {
            if (a.formal(i).kind() == formal.kind.VAR) {
                avoidVars.add(a.formal(i).var());
            }
            ++i;
        }
        i = 0;
        while (i < a.nStateVariables()) {
            avoidVars.add(a.stateVariable(i).variable());
            avoidVars.add(a.primedStateVariable(i));
            selectTerms[i] = new term(a.stateVariable(i).selector(), args);
            primedSelectTerms[i] = new term(a.stateVariable(i).selector(), pArgs);
            ++i;
        }
        transition[] dTrans = new transition[this.nTransitions()];
        int i2 = 0;
        while (i2 < this.nTransitions()) {
            varMap vMap = new varMap();
            vMap.avoid(avoidVars);
            int j = 0;
            while (j < a.nStateVariables()) {
                vMap.add(a.stateVariable(j).variable(), selectTerms[j]);
                vMap.add(a.primedStateVariable(j), primedSelectTerms[j]);
                ++j;
            }
            dTrans[i2] = this.transition(i2).desugar(a, this.desugaredAction, vMap, x);
            ++i2;
        }
        return dTrans;
    }

    public void setTransitions(transition[] transitions) {
        this.transitions = transitions;
    }

    public static String kind2String(kinds k) {
        switch (k) {
            case INPUT: {
                return "input";
            }
            case OUTPUT: {
                return "output";
            }
            case INTERNAL: {
                return "internal";
            }
        }
        throw new InternalError("action.kind2string");
    }

    public static String kind2SortName(kinds kind2) {
        return action.kind2String(kind2).substring(0, 3);
    }

    public static String kind2ILString(kinds k) {
        switch (k) {
            case INPUT: {
                return "input";
            }
            case OUTPUT: {
                return "output";
            }
            case INTERNAL: {
                return "internal";
            }
        }
        throw new InternalError("action.kind2ILstring");
    }

    public prettyprinter print(prettyprinter pp) {
        pp.fill().put(action.kind2String(this.kind)).blank().print(this.name);
        if (this.formals.length > 0) {
            pp.blank(0);
            formal.print(pp, this.formals, this.formalFactors);
        }
        if (!this.where.isTrue()) {
            pp.blank().fill().put("where").blank().print(this.where).end();
        }
        return pp.end();
    }

    public iprinter print(iprinter ip) {
        return this.toSValue().print(ip);
    }

    public SValue toSValue() {
        SList list = SExp.makeSList(this.idToSValue());
        list.add(SExp.makeSValue(action.kind2ILString(this.kind)));
        list.add(SExp.makeSValue(this.name));
        if (this.nFormals() > 0) {
            SList list2 = SExp.makeSList(SExp.makeSValue("formals"));
            int i = 0;
            while (i < this.formals.length) {
                list2.add(this.formals[i].toSValue());
                ++i;
            }
            list.add(list2);
        }
        if (!this.where.isTrue()) {
            SList list3 = SExp.makeSList(SExp.makeSValue("where"), this.where.toSValue());
            list.add(list3);
        }
        return list;
    }

    public iprinter printId(iprinter ip) {
        return ip.put("a" + this.actionIndex);
    }

    public SValue idToSValue() {
        return SExp.makeSValue("a" + this.actionIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum kinds {
        INPUT,
        OUTPUT,
        INTERNAL;

    }
}

