/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa;

import com.veromodo.tioa.automaton.automaton;
import com.veromodo.tioa.automaton.funcDecl;
import com.veromodo.tioa.checker.Options;
import com.veromodo.tioa.checker.checkAssertion;
import com.veromodo.tioa.checker.checkAutomaton;
import com.veromodo.tioa.checker.checkBasicAutomaton;
import com.veromodo.tioa.checker.checkVocab;
import com.veromodo.tioa.checker.symTable;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.Abstractify;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.assertionNode;
import com.veromodo.tioa.parser.builtIns;
import com.veromodo.tioa.parser.parser;
import com.veromodo.tioa.parser.specs;
import com.veromodo.tioa.parser.tioaTokenizer;
import com.veromodo.tioa.parser.unitNode;
import com.veromodo.tioa.util.error;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.prettyprinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Main {
    private static String usage = "TIOA Checker (Version 0.29), November 2, 2005\n\nUsage:   java -jar tioa.jar [option] fileName\nOptions:      -il    translate to intermediate language\n              -p     prettyprint specification\nNote:    Requires jdk1.5";
    private static String searchPath = ".";

    public static InputStream getResourceAsStream(String name) {
        InputStream is = ClassLoader.getSystemResourceAsStream("../" + name);
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(name);
        }
        return is;
    }

    public static void main(String[] args) {
        boolean iprintSpecs = false;
        boolean printRefs = false;
        boolean printSpecs = false;
        int argNumber = 0;
        while (argNumber < args.length) {
            String arg = args[argNumber];
            if (arg.equals("-il")) {
                iprintSpecs = true;
            } else if (arg.equals("-p")) {
                printSpecs = true;
            } else if (arg.equals("-r")) {
                printRefs = true;
            } else if (arg.equals("-path")) {
                if (argNumber == args.length - 1) break;
                searchPath = String.valueOf(args[++argNumber].trim()) + System.getProperty("path.separator") + searchPath;
            } else {
                if (arg.charAt(0) != '-') break;
                error.msg("Illegal option: " + arg);
                System.out.println(usage);
                System.exit(1);
            }
            ++argNumber;
        }
        if (argNumber >= args.length) {
            System.err.println(usage);
            System.exit(1);
        }
        while (argNumber < args.length) {
            String fName = args[argNumber];
            if (!fName.endsWith(".tioa")) {
                error.msg("File name " + fName + " must end with .tioa");
                System.exit(1);
            }
            specs.needPrimaryFile(fName);
            ++argNumber;
        }
        int nFiles = specs.nToParse();
        String specName = specs.nextToParse();
        while (specName != "") {
            parser scan = Main.createParser(specName);
            if (scan == null) {
                new unitNode(specName, Node.status.MISSING);
            } else {
                int errors = error.count();
                try {
                    scan.parse();
                }
                catch (Exception e) {
                    error.msg("Unexpected error: " + e);
                }
                if (errors != error.count()) {
                    new unitNode(specName, Node.status.UNPARSABLE);
                }
            }
            specName = specs.nextToParse();
        }
        int nPasses = 4;
        int pass = 0;
        while (pass < nPasses) {
            int i = 0;
            while (i < specs.nUnits()) {
                unitNode n = specs.unit(i);
                switch (n.unitKind()) {
                    case vocabulary: {
                        if (pass != 0) break;
                        checkVocab.check(n.vocabulary());
                        break;
                    }
                    case funcdecls: {
                        if (pass != 1) break;
                        int j = 0;
                        while (j < n.funcDecls().length) {
                            checkBasicAutomaton.checkFuncDecl(n.funcDecls()[j]);
                            ++j;
                        }
                        break;
                    }
                    case automaton: {
                        if (pass != 2) break;
                        checkAutomaton.def(n.automaton());
                        break;
                    }
                    case assertion: {
                        if (pass != 3) break;
                        checkAssertion.now(n.assertion());
                        break;
                    }
                    default: {
                        throw new InternalError("Main: bad unit type");
                    }
                }
                ++i;
            }
            ++pass;
        }
        if (error.count() > 0) {
            error.msg("Abort: error in specifications");
            System.exit(1);
        } else if (!printSpecs && !iprintSpecs) {
            error.msg("Finished checking specifications");
        }
        prettyprinter pp = prettyprinter.stdout();
        if (printSpecs) {
            Main.prettyPrint(pp, printRefs, Options.expand());
        }
        if (iprintSpecs) {
            Main.iPrint();
        }
        if (Options.debug()) {
            symTable.get().print(prettyprinter.stdout()).flush();
        }
    }

    private static void prettyPrint(prettyprinter pp, boolean printRefs, boolean printTypes) {
        pp.align(0);
        int nPrinted = 0;
        int unitIndex = 0;
        while (unitIndex < specs.nUnits()) {
            unitNode u = specs.unit(unitIndex);
            if (u.loc().fileName() != null && u.loc().fileName().length() != 0 && (printTypes || !u.loc().fileName().equals("CONSTRUCTED")) && (printRefs || specs.primary(u.loc().fileName()))) {
                if (nPrinted++ > 0) {
                    pp.eol();
                }
                switch (u.unitKind()) {
                    case automaton: {
                        automaton aut = u.automaton().makeAbstract();
                        pp.align(0).print(aut).end();
                        break;
                    }
                    case assertion: {
                        assertionNode assertion = u.assertion();
                        switch (assertion.kind()) {
                            case 1: {
                                pp.print(assertion.invar().makeAbstract());
                                break;
                            }
                            case 2: {
                                pp.print(assertion.simul().makeAbstract());
                            }
                        }
                        break;
                    }
                    case vocabulary: {
                        pp.print(u.vocabulary().makeAbstract());
                        break;
                    }
                    case funcdecls: {
                        funcDecl.printDecls(pp, (funcDecl[])Abstractify.map((Abstractifiable[])u.funcDecls(), (Object[])new funcDecl[u.funcDecls().length]));
                        break;
                    }
                    default: {
                        throw new InternalError("tioa.Main.prettyPrint");
                    }
                }
                pp.eol();
            }
            ++unitIndex;
        }
        pp.end().eof();
    }

    private static void iPrint() {
        iprinter ip = new iprinter(new PrintWriter(System.out));
        ip.align().put("tioa");
        ip.align().print(symTable.get()).end();
        int unitIndex = 0;
        while (unitIndex < specs.nUnits()) {
            unitNode u = specs.unit(unitIndex);
            switch (u.unitKind()) {
                case automaton: {
                    automaton aut = u.automaton().makeAbstract();
                    ip.print(aut);
                    break;
                }
                case assertion: {
                    assertionNode assertion = u.assertion();
                    switch (assertion.kind()) {
                        case 1: {
                            ip.print(assertion.invar().makeAbstract());
                            break;
                        }
                        case 2: {
                            ip.print(assertion.simul().makeAbstract());
                        }
                    }
                    break;
                }
                case vocabulary: {
                    ip.print(u.vocabulary().makeAbstract());
                    break;
                }
                case funcdecls: {
                    funcDecl.print((funcDecl[])Abstractify.map((Abstractifiable[])u.funcDecls(), (Object[])new funcDecl[u.funcDecls().length]), ip);
                    break;
                }
                default: {
                    throw new InternalError("tioa.Main.iPrint");
                }
            }
            ++unitIndex;
        }
        ip.end().flush();
    }

    private static parser createParser(String specName) {
        String fileName = String.valueOf(specName) + ".tioa";
        String path = "";
        File source = new File(fileName);
        if (!source.isAbsolute()) {
            StringTokenizer dirs = new StringTokenizer(searchPath, System.getProperty("path.separator"));
            while (dirs.hasMoreTokens()) {
                path = dirs.nextToken();
                source = new File(path, fileName);
                if (source.exists()) break;
            }
        }
        if (!source.canRead()) {
            return builtIns.getParser(specName);
        }
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(new FileInputStream(source));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (!path.equals(".")) {
            fileName = source.getPath();
        }
        return new parser(new tioaTokenizer(in, fileName));
    }
}

