/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.shell;

import com.veromodo.tioa.il.ILParseException;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.util.IOAProperties;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.logger.Logger;
import com.veromodo.tioa.util.shell.MainArgParser;
import com.veromodo.tioa.util.shell.MainArgParserException;
import com.veromodo.tioa.util.shell.MainArgParserRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Priority;

public class Shell {
    static IOACategory cat = IOACategory.getInstance((String)Shell.class.getName());
    public static final String propertyBase = "tioa.util.shell.";
    protected static final String homedir = System.getProperty("user.home");
    protected static final String tioaFile = ".tioa";
    public static final MainArgParserRule BOOLEAN = MainArgParser.BOOLEAN;
    public static final MainArgParserRule INT = MainArgParser.INT;
    public static final MainArgParserRule STRING = MainArgParser.STRING;
    public static final MainArgParserRule STRINGS = MainArgParser.STRINGS;
    private MainArgParser mparser = new MainArgParser("-");
    static /* synthetic */ Class class$0;

    protected Shell() {
    }

    protected void doMain(String[] args) {
        try {
            IOAProperties options = new IOAProperties(System.getProperties());
            this.setDefaultOptions(options);
            options = this.mparser.parseArgs(options, args);
            this.doStandardOptions(options);
            System.setProperties(options);
        }
        catch (Exception e) {
            this.printError(e, "");
            System.exit(1);
        }
    }

    protected void printUsage() {
        System.err.print("usage: no usage ");
        System.err.println(this.getUsageShort());
        System.err.println(this.getUsageLong());
    }

    protected String getUsageShort() {
        return this.mparser.getUsageShort();
    }

    protected String getUsageLong() {
        return this.mparser.getUsageLong();
    }

    protected void printError(Exception exceptionToHandle, String inFile) {
        try {
            throw exceptionToHandle;
        }
        catch (NumberFormatException nfe) {
            System.err.println("bad number: " + nfe.getMessage());
            this.printUsage();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("file " + inFile + " not found");
            this.printUsage();
        }
        catch (LookupException le) {
            if (le.targetType().equalsIgnoreCase("automaton")) {
                System.err.println(le.getMessage());
            }
            this.printUsage();
        }
        catch (IOException ioe) {
            System.err.println("I/O exception: ");
            ioe.printStackTrace();
            this.printUsage();
        }
        catch (ILParseException e) {
            cat.error((Object)"IL Parsing Error: ", (Throwable)e);
            Throwable f = e.getPiggyback();
            if (f != null) {
                cat.error((Object)"piggyback: ", f);
            }
            cat.error((Object)"Most likely, the given .il file is invalid.");
        }
        catch (MainArgParserException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addParserFlag(String optionName, String optionString, MainArgParserRule optionType, String optionDescr) {
        this.mparser.addOption(optionName, optionString, optionType, optionDescr);
    }

    protected void addParserFlag(String optionName) {
        this.mparser.removeOption(optionName);
    }

    protected void setDefaultOptions(IOAProperties options) {
        this.addParserFlag("tioa.util.shell.debug", "-debug", MainArgParser.BOOLEAN, "Turn on debug information globally");
        this.addParserFlag("tioa.util.shell.dbg", "-dbg", MainArgParser.STRINGS, "Turn on debug information for a java class or package.");
        this.addParserFlag("tioa.util.shell.out", "-o", MainArgParser.STRING, "Set base name for output");
        this.addParserFlag("tioa.util.shell.outIl", "-oil", MainArgParser.STRING, "Set destination for il output");
        this.addParserFlag("tioa.util.shell.noIl", "-noIl", MainArgParser.BOOLEAN, "Do not send il output to a file (if reading an IOA file)");
    }

    protected void doStandardOptions(IOAProperties options) {
        if (options.getFlag("tioa.util.shell.debug")) {
            Logger.setupLogs((Priority)Logger.DEBUG);
        } else {
            Logger.setupLogs();
        }
        List<String> debugList = options.getList("tioa.util.shell.dbg");
        Iterator<String> debugI = debugList.iterator();
        while (debugI.hasNext()) {
            Logger.setPriority((String)debugI.next(), (Priority)Logger.DEBUG);
        }
    }

    protected void setOutputOptions(IOAProperties options, String fileName) {
        if (Shell.getExtension(fileName).equals(".il") || Shell.getExtension(fileName).equals(tioaFile)) {
            fileName = Shell.stripExtension(fileName);
        }
        if (options.getProperty("tioa.util.shell.out") == null) {
            options.setProperty("tioa.util.shell.out", fileName);
        }
        fileName = options.getProperty("tioa.util.shell.out");
        if (options.getProperty("tioa.util.shell.outIl") == null) {
            options.setProperty("tioa.util.shell.outIl", String.valueOf(fileName) + ".il");
        }
    }

    public static String stripExtension(String fileName) {
        String name = new File(fileName).getName();
        int dotPosition = name.lastIndexOf(".");
        if (dotPosition > 0) {
            return fileName.substring(0, fileName.length() - name.length() + dotPosition);
        }
        return fileName;
    }

    public static String getExtension(String fileName) {
        String name = new File(fileName).getName();
        int dotPosition = name.lastIndexOf(".");
        if (dotPosition > 0) {
            return name.substring(dotPosition, name.length());
        }
        return "";
    }
}

