/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.shell;

import com.veromodo.tioa.util.IOAProperties;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.shell.MainArgParserException;
import com.veromodo.tioa.util.shell.MainArgParserRule;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class MainArgParser {
    private static final IOACategory cat = IOACategory.getInstance((String)MainArgParser.class.getName());
    public static final MainArgParserRule BOOLEAN = new MainArgParserRule("BOOLEAN");
    public static final MainArgParserRule INT = new MainArgParserRule("INT");
    public static final MainArgParserRule STRING = new MainArgParserRule("STRING");
    public static final MainArgParserRule STRINGS = new MainArgParserRule("STRINGS");
    private TreeMap<String, MainArgParserRule> optionTypes = new TreeMap();
    private TreeMap<String, String> optionNames = new TreeMap();
    private TreeMap<String, String> optionDescs = new TreeMap();
    private String optionChars;
    static /* synthetic */ Class class$0;

    public MainArgParser(String optionChars) {
        this.optionChars = optionChars;
    }

    public MainArgParser() {
        this("");
    }

    public void addOption(String optionName, String optionString, MainArgParserRule type, String optionDesc) {
        this.optionTypes.put(optionString, type);
        this.optionNames.put(optionString, optionName);
        this.optionDescs.put(optionString, optionDesc);
    }

    public void removeOption(String optionName) {
        Iterator<String> i = this.optionNames.keySet().iterator();
        HashSet<String> keys = new HashSet<String>();
        while (i.hasNext()) {
            String key = i.next();
            String name = this.optionNames.get(key);
            if (!name.equals(optionName)) continue;
            keys.add(key);
        }
        for (String key : keys) {
            this.optionTypes.remove(key);
            this.optionNames.remove(key);
            this.optionDescs.remove(key);
        }
    }

    IOAProperties parseArgs(IOAProperties defaults, String[] args) throws MainArgParserException {
        IOAProperties retval = new IOAProperties(defaults);
        int numRealArgs = 0;
        String storedOp = null;
        int i = 0;
        while (i < args.length) {
            String currentArg = args[i];
            if (storedOp != null && !this.optionTypes.containsKey(currentArg)) {
                this.addValue(retval, this.optionTypes.get(storedOp), this.optionNames.get(storedOp), currentArg);
                storedOp = null;
            } else {
                if (storedOp != null && this.optionTypes.containsKey(currentArg)) {
                    throw new MainArgParserException("Option requires an argument " + storedOp, 2, storedOp);
                }
                if (this.optionTypes.containsKey(currentArg)) {
                    if (this.optionTypes.get(currentArg) == BOOLEAN) {
                        retval.setFlag(this.optionNames.get(currentArg), true);
                    } else {
                        storedOp = currentArg;
                    }
                } else {
                    if (this.optionChars.indexOf(currentArg.charAt(0)) >= 0) {
                        throw new MainArgParserException("Invalid option: " + currentArg, 3, currentArg);
                    }
                    retval.addToList("tioa.util.shell.args", currentArg);
                    ++numRealArgs;
                }
            }
            ++i;
        }
        if (storedOp != null) {
            throw new MainArgParserException("Option requires an argument " + storedOp, 2, storedOp);
        }
        retval.setInt("tioa.util.shell.numArgs", numRealArgs);
        return retval;
    }

    private void addValue(IOAProperties table, MainArgParserRule type, String key, String value) throws MainArgParserException {
        if (type == STRING) {
            table.setProperty(key, value);
        } else if (type == INT) {
            try {
                Integer i = Integer.valueOf(value);
                table.setInt(key, i);
            }
            catch (NumberFormatException e) {
                throw new MainArgParserException("Bad number format for option " + key, 1, key);
            }
        } else if (type == STRINGS) {
            table.addToList(key, value);
        }
    }

    String getUsageShort() {
        String retval = "";
        Iterator<String> i = this.optionTypes.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            retval = String.valueOf(retval) + this.getUsageForItem(key);
            if (!i.hasNext()) continue;
            retval = String.valueOf(retval) + " ";
        }
        return retval;
    }

    String getUsageLong() {
        String retval = "";
        Iterator<String> i = this.optionTypes.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            MainArgParserRule type = this.optionTypes.get(key);
            String usageItem = this.getUsageForItem(key);
            retval = String.valueOf(retval) + "  " + usageItem + this.blankString(Math.max(0, 20 - usageItem.length())) + this.optionDescs.get(key);
            if (!i.hasNext()) continue;
            retval = String.valueOf(retval) + "\n";
        }
        return retval;
    }

    String getUsageForItem(String key) {
        MainArgParserRule type = this.optionTypes.get(key);
        String retval = "";
        if (type == STRING) {
            retval = String.valueOf(retval) + "[" + key + " <" + "string" + "]" + "]";
        } else if (type == INT) {
            retval = String.valueOf(retval) + "[" + key + " <" + "number" + "]" + "]";
        } else if (type == BOOLEAN) {
            retval = String.valueOf(retval) + "[" + key + "]";
        } else if (type == STRINGS) {
            retval = String.valueOf(retval) + "[" + key + " <" + "string" + "]" + "]+";
        }
        return retval;
    }

    private String blankString(int n) {
        char[] retval = new char[n];
        int i = 0;
        while (i < n) {
            retval[i] = 32;
            ++i;
        }
        return new String(retval);
    }
}

