/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util;

import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.PrintStack;
import com.veromodo.tioa.util.Ptoken;
import com.veromodo.tioa.util.beginToken;
import com.veromodo.tioa.util.breakToken;
import com.veromodo.tioa.util.endToken;
import com.veromodo.tioa.util.stringToken;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class prettyprinter {
    private static int MaxBlanks = 127;
    private static int DefaultLineWidth = 75;
    private int margin;
    private int space;
    private Ptoken[] token;
    private int[] size;
    private int left;
    private int right;
    private int leftTotal;
    private int rightTotal;
    private PrintWriter out;
    private int nLines = 0;
    private int nPuts = 0;
    private static breakToken lineBreak = new breakToken(MaxBlanks, 0);
    private static endToken endTok = new endToken();
    private static int sizeInfinity = Integer.MAX_VALUE;
    private int[] scanStack;
    private boolean scanStackEmpty;
    private int top;
    private int bottom;
    private PrintStack printStack;
    private static final int ALIGNED = 1;
    private static final int FILLED = 2;
    private static final int FITS = 3;

    public prettyprinter(int lineWidth) {
        this.space = this.margin = lineWidth;
        int n = 3 * this.margin;
        this.bottom = 0;
        this.top = 0;
        this.scanStackEmpty = true;
        this.token = new Ptoken[n];
        this.size = new int[n];
        this.scanStack = new int[n];
        this.printStack = new PrintStack();
    }

    public prettyprinter(PrintWriter S) {
        this(DefaultLineWidth);
        this.out = S;
    }

    public static prettyprinter stdout() {
        return new prettyprinter(new PrintWriter(System.out));
    }

    public static prettyprinter stderr() {
        return new prettyprinter(new PrintWriter(System.err));
    }

    public prettyprinter eof() {
        if (!this.scanStackEmpty) {
            this.CheckStack();
            this.AdvanceLeft();
        }
        if (this.out != null) {
            this.out.flush();
        }
        this.nLines = 0;
        this.nPuts = 0;
        return this;
    }

    public prettyprinter flush() {
        if (this.out != null) {
            this.out.flush();
        }
        return this;
    }

    private prettyprinter begin(beginToken t) {
        if (this.scanStackEmpty) {
            this.rightTotal = 1;
            this.leftTotal = 1;
            this.right = 0;
            this.left = 0;
        } else {
            this.AdvanceRight();
        }
        this.token[this.right] = t;
        this.size[this.right] = -this.rightTotal;
        this.ScanPush(this.right);
        return this;
    }

    public prettyprinter align(int off) {
        return this.begin(new beginToken(off, true));
    }

    public prettyprinter align() {
        return this.align(2);
    }

    public prettyprinter fill(int off) {
        return this.begin(new beginToken(off, false));
    }

    public prettyprinter fill() {
        return this.fill(2);
    }

    public prettyprinter end() {
        if (this.scanStackEmpty) {
            this.Print(endTok, 0);
        } else {
            this.AdvanceRight();
            this.token[this.right] = endTok;
            this.size[this.right] = -1;
            this.ScanPush(this.right);
        }
        return this;
    }

    public prettyprinter blank(int len, int offset) {
        if (this.scanStackEmpty) {
            this.rightTotal = 1;
            this.leftTotal = 1;
            this.right = 0;
            this.left = 0;
        } else {
            this.AdvanceRight();
        }
        this.CheckStack();
        this.ScanPush(this.right);
        this.token[this.right] = new breakToken(len, offset);
        this.size[this.right] = -this.rightTotal;
        this.rightTotal += len;
        return this;
    }

    public prettyprinter blank(int len) {
        return this.blank(len, 0);
    }

    public prettyprinter blank() {
        return this.blank(1, 0);
    }

    public prettyprinter eol() {
        return this.blank(MaxBlanks, 0);
    }

    public prettyprinter put(String s) {
        ++this.nPuts;
        stringToken t = new stringToken(s);
        if (this.scanStackEmpty) {
            this.Print(t, t.length);
        } else {
            this.AdvanceRight();
            this.token[this.right] = t;
            this.size[this.right] = t.length;
            this.rightTotal += t.length;
            while (this.rightTotal - this.leftTotal > this.space && this.left != this.right) {
                if (!this.scanStackEmpty && this.left == this.scanStack[this.bottom]) {
                    this.size[this.ScanPopBottom()] = sizeInfinity;
                }
                this.AdvanceLeft();
            }
        }
        return this;
    }

    public prettyprinter print(String s) {
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            this.put(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            this.blank();
        }
        return this;
    }

    public prettyprinter print(Prettyprintable x) {
        if (x != null) {
            x.print(this);
        }
        return this;
    }

    public prettyprinter list(Prettyprintable[] v, String sep) {
        this.align(0);
        if (v.length > 0) {
            this.print(v[0]);
        }
        int i = 1;
        while (i < v.length) {
            this.put(sep).blank().print(v[i]);
            ++i;
        }
        return this.end();
    }

    public prettyprinter blist(Prettyprintable[] v, String sep) {
        this.align(0);
        if (v.length > 0) {
            this.print(v[0]);
        }
        int i = 1;
        while (i < v.length) {
            this.put(sep).eol().print(v[i]);
            ++i;
        }
        return this.end();
    }

    public int nLines() {
        return this.nLines;
    }

    public int nPuts() {
        return this.nPuts;
    }

    private void ScanPush(int x) {
        if (this.scanStackEmpty) {
            this.scanStackEmpty = false;
        } else {
            this.top = (this.top + 1) % this.scanStack.length;
            if (this.top == this.bottom) {
                throw new InternalError("prettyprinter.ScanPush");
            }
        }
        this.scanStack[this.top] = x;
    }

    private int ScanPop() {
        if (this.scanStackEmpty) {
            throw new InternalError("prettyprinter.ScanPop");
        }
        int x = this.scanStack[this.top];
        if (this.top == this.bottom) {
            this.scanStackEmpty = true;
        } else {
            this.top = (this.top + this.scanStack.length - 1) % this.scanStack.length;
        }
        return x;
    }

    private int ScanTop() {
        if (this.scanStackEmpty) {
            throw new InternalError("prettyprinter.ScanTop");
        }
        return this.scanStack[this.top];
    }

    private int ScanPopBottom() {
        if (this.scanStackEmpty) {
            throw new InternalError("prettyprinter.ScanPopBottom");
        }
        int x = this.scanStack[this.bottom];
        if (this.top == this.bottom) {
            this.scanStackEmpty = true;
        } else {
            this.bottom = (this.bottom + 1) % this.scanStack.length;
        }
        return x;
    }

    private void AdvanceRight() {
        this.right = (this.right + 1) % this.scanStack.length;
        if (this.right == this.left) {
            throw new InternalError("prettyprinter.AdvanceRight");
        }
    }

    private void AdvanceLeft() {
        int len = this.size[this.left];
        while (len >= 0) {
            Ptoken x = this.token[this.left];
            this.Print(x, len);
            switch (x.kind) {
                case 2: {
                    this.leftTotal += ((breakToken)x).blankSpace;
                    break;
                }
                case 1: {
                    this.leftTotal += len;
                }
            }
            if (this.left == this.right) {
                return;
            }
            this.left = (this.left + 1) % this.scanStack.length;
            len = this.size[this.left];
        }
    }

    private void CheckStack() {
        int k = 0;
        block4: while (!this.scanStackEmpty) {
            switch (this.token[this.ScanTop()].kind) {
                case 3: {
                    if (k-- == 0) {
                        return;
                    }
                    int n = this.ScanPop();
                    this.size[n] = this.size[n] + this.rightTotal;
                    break;
                }
                case 4: {
                    this.size[this.ScanPop()] = 1;
                    ++k;
                    break;
                }
                default: {
                    int n = this.ScanPop();
                    this.size[n] = this.size[n] + this.rightTotal;
                    if (k != 0) continue block4;
                    return;
                }
            }
        }
    }

    private void Space(int amount) {
        if (this.out != null) {
            int i = 0;
            while (i < amount) {
                this.out.print(" ");
                ++i;
            }
        }
    }

    private void Print(Ptoken x, int len) {
        switch (x.kind) {
            case 3: {
                beginToken y = (beginToken)x;
                if (len > this.space) {
                    this.printStack.push(this.space - y.offset, y.aligned ? 1 : 2);
                    break;
                }
                this.printStack.push(0, 3);
                break;
            }
            case 4: {
                this.printStack.pop();
                break;
            }
            case 2: {
                breakToken z = (breakToken)x;
                switch (this.printStack.topBreak()) {
                    case 3: {
                        this.space -= z.blankSpace;
                        this.Space(z.blankSpace);
                        break;
                    }
                    case 2: {
                        if (len <= this.space) {
                            this.space -= z.blankSpace;
                            this.Space(z.blankSpace);
                            break;
                        }
                    }
                    case 1: {
                        if (this.out != null) {
                            this.out.println();
                        }
                        ++this.nLines;
                        this.space = this.printStack.topOffset() - z.offset;
                        this.Space(this.margin - this.space);
                    }
                }
                break;
            }
            case 1: {
                this.space -= len;
                if (this.space < 0) {
                    this.space = 0;
                }
                if (this.out == null) break;
                this.out.print(((stringToken)x).string);
            }
        }
    }

    public static void main(String[] args) {
        prettyprinter pp = prettyprinter.stdout();
        pp.fill();
        int i = 0;
        while (i < 50) {
            pp.put("hi").blank();
            ++i;
        }
        pp.end().eof();
    }
}

