/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util;

import com.veromodo.tioa.util.Locatable;

public class location
implements Locatable {
    private String fileName;
    private int startLine;
    private int startCol;
    private int lastLine;
    private int lastCol;

    public location(String file, int line1, int col1, int line2, int col2) {
        if (file == null) {
            file = "";
        }
        this.fileName = file.intern();
        this.startLine = line1;
        this.startCol = col1;
        this.lastLine = line2;
        this.lastCol = col2;
    }

    public location() {
        this("", -1, -1, -1, -1);
    }

    public location(location loc) {
        this.copy(loc);
    }

    private location copy(location loc) {
        this.fileName = loc.fileName;
        this.startLine = loc.startLine;
        this.lastLine = loc.lastLine;
        this.startCol = loc.startCol;
        this.lastCol = loc.lastCol;
        return this;
    }

    public String fileName() {
        return this.fileName;
    }

    public int startLine() {
        return this.startLine;
    }

    public int lastLine() {
        return this.lastLine;
    }

    public int startCol() {
        return this.startCol;
    }

    public int lastCol() {
        return this.lastCol;
    }

    public location loc() {
        return this;
    }

    public location extend(location loc) {
        if (loc.isNull()) {
            return this;
        }
        if (this.isNull()) {
            return this.copy(loc);
        }
        if (this.fileName != loc.fileName) {
            throw new InternalError("location.extend");
        }
        if (loc.startLine < this.startLine) {
            this.startLine = loc.startLine;
            this.startCol = loc.startCol;
        } else if (loc.startLine == this.startLine && loc.startCol < this.startCol) {
            this.startCol = loc.startCol;
        }
        if (loc.lastLine > this.lastLine) {
            this.lastLine = loc.lastLine;
            this.lastCol = loc.lastCol;
        } else if (loc.lastLine == this.lastLine && loc.lastCol > this.lastCol) {
            this.lastCol = loc.lastCol;
        }
        return this;
    }

    private boolean isNull() {
        return this.fileName.equals("") && this.startLine == -1 && this.startCol == -1 && this.lastLine == -1 && this.lastCol == -1;
    }

    public String toString() {
        return String.valueOf(this.startLine) + ":" + this.startCol + ", " + this.lastLine + ":" + this.lastCol;
    }
}

