/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util;

import com.veromodo.tioa.util.CollectionsUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOAProperties
extends Properties {
    private static final long serialVersionUID = 3258134647946162489L;

    public IOAProperties() {
    }

    public IOAProperties(Properties arg) {
        this.putAll((Map<?, ?>)arg);
    }

    public boolean getFlag(String keyName) {
        return this.getProperty(keyName, "false").equals("true");
    }

    public void setFlag(String keyName, boolean value) {
        this.setProperty(keyName, value ? "true" : "false");
    }

    public void setInt(String keyName, int value) {
        this.setProperty(keyName, new Integer(value).toString());
    }

    public int getInt(String keyName) {
        try {
            return Integer.valueOf(this.getProperty(keyName, "0"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getString(String keyName) {
        return this.getProperty(keyName, "0");
    }

    public void setList(String keyName, List value) {
        Iterator i = value.iterator();
        StringBuffer buf = new StringBuffer();
        while (i.hasNext()) {
            Object item = i.next();
            if (!(item instanceof String)) continue;
            buf.append(item.toString());
            if (!i.hasNext()) continue;
            buf.append(" ");
        }
        this.setProperty(keyName, buf.toString());
    }

    public List<String> getList(String keyName) {
        return CollectionsUtils.stringToList(this.getProperty(keyName, ""), " ");
    }

    public void addToList(String keyName, String value) {
        List<String> l = this.getList(keyName);
        l.add(value);
        this.setList(keyName, l);
    }
}

