/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util;

import com.veromodo.tioa.util.logger.IOACategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLocator {
    protected static char pathSeparator = System.getProperty("path.separator").charAt(0);
    protected static char fileSeparator = System.getProperty("file.separator").charAt(0);
    private static IOACategory debug = IOACategory.getInstance((String)ClassLocator.class.getName());
    static ClassLocator classLocator = null;
    static /* synthetic */ Class class$0;

    public Set<String> getImplementorsOf(Class interfaceClass, Collection<String> locationOfPackages, Collection<String> packagesToInclude, Collection<String> classesToInclude, Collection<String> classesToExclude) throws IOException, ClassNotFoundException {
        Set<String> classes = this.getClassesFromPackagesToInclude(locationOfPackages, packagesToInclude);
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("Classes loaded from getClassesFromPackagesToInclude: " + classes));
        }
        Set<String> classesAfterExclusion = this.excludeClasses(classes, classesToExclude);
        Set<String> classesAfterAddition = this.addClasses(classesAfterExclusion, classesToInclude);
        return this.getInterfaceImplementors(classesAfterAddition, interfaceClass);
    }

    public Set<String> getClassesFromPackagesToInclude(Collection locationOfPackages, Collection packagesToInclude) throws IOException {
        HashSet<String> returnSet = new HashSet<String>();
        for (String packageName : packagesToInclude) {
            if (packageName.endsWith(".jar")) {
                File jarFile = this.jarAndPackageLocator(packageName, locationOfPackages);
                returnSet.addAll(this.jarClasses(jarFile));
                continue;
            }
            String separatedName = packageName.replace('.', fileSeparator);
            File fileName = this.jarAndPackageLocator(separatedName, locationOfPackages);
            returnSet.addAll(this.packageClasses(fileName, packageName));
        }
        return returnSet;
    }

    protected File jarAndPackageLocator(String fileName, Collection locations) {
        File returnFile = null;
        if (debug.isDebugEnabled()) {
            debug.debug((Object)"jarAndPackageLocator");
        }
        Iterator iLocations = locations.iterator();
        while (iLocations.hasNext()) {
            String absoluteLocation = ((String)iLocations.next()).trim();
            if (!absoluteLocation.endsWith(new String(new char[]{fileSeparator}))) {
                absoluteLocation = String.valueOf(absoluteLocation) + fileSeparator;
            }
            File extendedFile = new File(String.valueOf(absoluteLocation) + fileName);
            if (debug.isDebugEnabled()) {
                debug.debug((Object)("  fileName: " + fileName));
                debug.debug((Object)("  location: " + absoluteLocation));
            }
            if (!extendedFile.exists()) continue;
            returnFile = extendedFile;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("  returning: " + returnFile));
        }
        return returnFile;
    }

    protected Set<String> jarClasses(File jarFile) throws IOException {
        HashSet<String> returnSet = new HashSet<String>();
        try {
            JarEntry jarNextEntry;
            FileInputStream fileStream = new FileInputStream(jarFile);
            JarInputStream jarPackageStream = new JarInputStream(fileStream);
            while ((jarNextEntry = jarPackageStream.getNextJarEntry()) != null) {
                String jarName = jarNextEntry.toString();
                if (!jarName.endsWith(".class")) continue;
                String classRemoved = this.removeClass(jarName);
                String jarClass = classRemoved.replace(fileSeparator, '.');
                returnSet.add(jarClass);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return returnSet;
    }

    protected Set<String> packageClasses(File packageDirectory, String packageName) {
        if (packageDirectory == null) {
            return new HashSet<String>();
        }
        String[] listOfPackageFiles = packageDirectory.list();
        int lengthPackageFiles = listOfPackageFiles.length;
        HashSet<String> returnSet = new HashSet<String>();
        int i = 0;
        while (i < lengthPackageFiles) {
            if (listOfPackageFiles[i].endsWith(".class")) {
                returnSet.add(String.valueOf(packageName) + "." + this.removeClass(listOfPackageFiles[i]));
            }
            ++i;
        }
        return returnSet;
    }

    protected Set<String> excludeClasses(Set<String> classes, Collection<String> classesToExclude) {
        classes.removeAll(classesToExclude);
        return classes;
    }

    public Set<String> addClasses(Set<String> classes, Collection<String> classesToInclude) {
        classes.addAll(classesToInclude);
        return classes;
    }

    public String removeClass(String className) {
        int lastIndexOfClass = className.lastIndexOf(115);
        return className.substring(0, lastIndexOfClass - 5);
    }

    public Set<String> getInterfaceImplementors(Collection classes, Class interfaceClass) throws ClassNotFoundException {
        HashSet<String> setOfImplementors = new HashSet<String>();
        for (String className : classes) {
            if (debug.isDebugEnabled()) {
                debug.debug((Object)("getting implementors of " + className));
            }
            Class<?> currentClass = Class.forName(className);
            Class<?>[] interfacesImplemented = currentClass.getInterfaces();
            int numberOfInterfacesImplemented = interfacesImplemented.length;
            int i = 0;
            while (i < numberOfInterfacesImplemented) {
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("checking if " + interfacesImplemented[i].getName() + " implements " + interfaceClass.getName()));
                }
                if (interfaceClass.isAssignableFrom(interfacesImplemented[i])) {
                    setOfImplementors.add(className);
                    if (debug.isDebugEnabled()) {
                        debug.debug((Object)(String.valueOf(interfacesImplemented[i].getName()) + " implements " + interfaceClass.getName()));
                    }
                }
                ++i;
            }
        }
        return setOfImplementors;
    }
}

