/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.shell;

import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.NOPstep;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.shell.BasicListener;
import com.veromodo.tioa.simulator.ui.BadDeclaration;
import com.veromodo.tioa.simulator.ui.BadScheduleEvent;
import com.veromodo.tioa.simulator.ui.BeginStepEvent;
import com.veromodo.tioa.simulator.ui.EndStepEvent;
import com.veromodo.tioa.simulator.ui.ExecEndedEvent;
import com.veromodo.tioa.simulator.ui.InitializedEvent;
import com.veromodo.tioa.simulator.ui.InvariantFailedEvent;
import com.veromodo.tioa.simulator.ui.SimEvent;
import com.veromodo.tioa.simulator.ui.WhereFailedEvent;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;

class StepListener
extends BasicListener {
    private static final IOACategory cat = IOACategory.getInstance((String)StepListener.class.getName());
    protected int pc = 0;
    protected VerbosityEnum verbosity;
    protected boolean compositeSimulation = false;
    public static final VerbosityEnum V3_STATE = new VerbosityEnum("fullState", 3);
    public static final VerbosityEnum V2_MODIFIED = new VerbosityEnum("modified", 2);
    public static final VerbosityEnum V1_TRANSITIONS = new VerbosityEnum("transitions", 1);
    public static final VerbosityEnum V0_TRACES = new VerbosityEnum("traces", 0);
    static /* synthetic */ Class class$0;

    public StepListener(Simulator sim) {
        super(sim);
        this.verbosity = V2_MODIFIED;
    }

    public StepListener(Simulator sim, VerbosityEnum verbosity) {
        super(sim);
        this.verbosity = verbosity;
    }

    protected String pc_space(int pc) {
        if (pc == -1) {
            return "     ";
        }
        String space = "   ";
        if (pc > 9 && pc < 100) {
            space = "  ";
        } else if (pc > 99 && pc < 1000) {
            space = " ";
        }
        return String.valueOf(pc) + ":" + space;
    }

    public boolean handleSimEvent(SimEvent ev) {
        cat.debug((Object)ev);
        if (ev instanceof InitializedEvent) {
            if (this.verbosity.compareTo(V2_MODIFIED) >= 0) {
                System.out.println("Initialization");
                this.printVars();
            } else {
                System.out.println("Automaton initialized");
            }
            this.pc = 0;
        } else if (ev instanceof BeginStepEvent) {
            Step s = ((BeginStepEvent)ev).getStep();
            if ((!(s instanceof ExecTrajectory) || ((ExecTrajectory)s).getOrder() != 2 && ((ExecTrajectory)s).getOrder() != 3) && !(s instanceof NOPstep)) {
                ++this.pc;
                if (this.verbosity.compareTo(V2_MODIFIED) >= 0) {
                    System.out.print(this.pc_space(this.pc));
                }
            }
        } else if (!(ev instanceof NOPstep)) {
            if (ev instanceof ActualTransition) {
                ActualTransition trans = (ActualTransition)ev;
                if (this.compositeSimulation) {
                    trans.printAutomatonName = true;
                }
                if (this.verbosity.compareTo(V2_MODIFIED) >= 0) {
                    if (trans.getConnectedOutput().equals("")) {
                        System.out.println(ev);
                    } else {
                        System.out.println(ev + " --- Connected to :" + trans.getConnectedOutput());
                    }
                    this.printVars();
                } else if (this.verbosity.compareTo(V1_TRANSITIONS) >= 0) {
                    if (trans.getConnectedOutput().equals("")) {
                        System.out.println(String.valueOf(this.pc_space(this.pc)) + trans.getDescription());
                    } else {
                        System.out.println(String.valueOf(this.pc_space(this.pc)) + trans.getDescription() + ", connected to:" + trans.getConnectedOutput());
                    }
                } else if (trans.getTransition().getAction().getType() != 2) {
                    if (trans.getConnectedOutput().equals("")) {
                        System.out.println(String.valueOf(this.pc_space(this.pc)) + trans.getDescription());
                    } else {
                        System.out.println(String.valueOf(this.pc_space(this.pc)) + trans.getDescription() + ", connected to:" + trans.getConnectedOutput());
                    }
                }
            } else if (!(ev instanceof EndStepEvent)) {
                if (ev instanceof ExecEndedEvent) {
                    System.out.println("No more steps");
                    return false;
                }
                if (ev instanceof InvariantFailedEvent) {
                    InvariantFailedEvent ife = (InvariantFailedEvent)ev;
                    if (this.compositeSimulation) {
                        System.out.println(">>>> Invariant " + ife.inv.getName() + " of component " + ife.inv.getAutomaton().getName() + " failed");
                    } else {
                        System.out.println(">>>> Invariant " + ife.inv.getName() + " failed");
                    }
                } else if (ev instanceof WhereFailedEvent) {
                    WhereFailedEvent wfe = (WhereFailedEvent)ev;
                    if (this.compositeSimulation) {
                        System.out.println(">>>> Where term of automaton " + wfe.getAutomaton().getName() + " failed for the given values of the formal parameters.");
                    } else {
                        System.out.println(">>>> Where term of automaton failed for the given values of the formal parameters.");
                    }
                } else if (ev instanceof BadScheduleEvent) {
                    BadScheduleEvent bse = (BadScheduleEvent)ev;
                    System.out.println(">>>> Schedule problem: " + bse.eventDescription());
                } else if (ev instanceof BadDeclaration) {
                    BadDeclaration bd = (BadDeclaration)ev;
                    System.out.println(">>>> With Block problem: " + bd.eventDescription());
                } else if (ev instanceof ExecTrajectory) {
                    ExecTrajectory traj = (ExecTrajectory)ev;
                    if (this.compositeSimulation) {
                        traj.printAutomatonName = true;
                    }
                    if (this.verbosity.compareTo(V2_MODIFIED) >= 0) {
                        if (!this.compositeSimulation) {
                            System.out.println(traj.toString());
                        } else if (traj.getOrder() == 2 || traj.getOrder() == 3) {
                            System.out.println("     " + traj.toString());
                        } else {
                            System.out.println(traj.toString());
                        }
                        this.printVars();
                    } else if (!this.compositeSimulation) {
                        System.out.print(String.valueOf(this.pc_space(this.pc)) + "trajectory ");
                        System.out.println(traj.getDescription());
                    } else if (traj.getOrder() == 0) {
                        System.out.println(String.valueOf(this.pc_space(this.pc)) + "trajectory " + traj.getDescription());
                    } else if (traj.getOrder() == 1) {
                        System.out.print(String.valueOf(this.pc_space(this.pc)) + "trajectory ");
                        System.out.print(String.valueOf(traj.getAutomaton().getName()) + ".");
                        System.out.print(traj.getTrajectory().getTrajectoryName());
                    } else if (traj.getOrder() == 2) {
                        System.out.print(", ");
                        System.out.print(String.valueOf(traj.getAutomaton().getName()) + ".");
                        System.out.print(traj.getTrajectory().getTrajectoryName());
                    } else if (traj.getOrder() == 3) {
                        System.out.print(", ");
                        System.out.print(String.valueOf(traj.getAutomaton().getName()) + ".");
                        System.out.print(traj.getTrajectory().getTrajectoryName());
                        System.out.println(" for " + traj.getDuration() + (traj.getDuration() == 1.0 ? " unit" : " units"));
                    } else if (traj.getOrder() == 4) {
                        System.out.print(String.valueOf(this.pc_space(this.pc)) + "trajectory ");
                        System.out.println(traj.getDescription());
                    }
                } else {
                    System.out.print(">>>> Handling unknown event ");
                    System.out.println(String.valueOf(ev.toString()) + ": ");
                    String msg = ev.eventDescription();
                    if (msg != null && msg.length() != 0) {
                        System.out.println(msg);
                    }
                }
            }
        }
        return super.handleSimEvent(ev);
    }

    protected void printVars() {
        Enumeration enum1 = this.getSimulator().enumModifiedVariables();
        if (this.verbosity == V2_MODIFIED) {
            enum1 = this.getSimulator().enumModifiedVariables();
            if (!enum1.hasMoreElements()) {
                System.out.println("    <No modified state variables>");
            }
        } else {
            enum1 = this.getSimulator().enumVariables();
            if (enum1.hasMoreElements()) {
                System.out.println("    State variables:");
            }
        }
        while (enum1.hasMoreElements()) {
            SimVariable var = enum1.nextElement();
            if (this.compositeSimulation) {
                System.out.println("       " + var.getAutName() + "." + var.getName() + " -> " + var.value);
                continue;
            }
            System.out.println("       " + var.getName() + " -> " + var.value);
        }
    }

    public void setComposite() {
        this.compositeSimulation = true;
    }

    protected static class VerbosityEnum
    implements Comparable {
        private String descr;
        private int priority;

        public VerbosityEnum(String argDescr, int argPriority) {
            this.descr = argDescr;
            this.priority = argPriority;
        }

        public int compareTo(VerbosityEnum other) {
            if (this == other) {
                return 0;
            }
            if (this.priority == other.priority) {
                return 0;
            }
            return this.priority < other.priority ? -1 : 1;
        }

        public int compareTo(Object o) {
            if (o instanceof VerbosityEnum) {
                return this.compareTo((VerbosityEnum)o);
            }
            throw new UnsupportedOperationException("Bad comparison of " + this);
        }

        public String toString() {
            return this.descr;
        }
    }
}

