/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.shell;

import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.Spec;
import com.veromodo.tioa.registry.ImplFactory;
import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.NatSort;
import com.veromodo.tioa.runtime.adt.NonDet;
import com.veromodo.tioa.simulator.ImplRegistry;
import com.veromodo.tioa.simulator.daikon.DaikonListener;
import com.veromodo.tioa.simulator.exceptions.CannotSimulateException;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.impl.BasicImplRegistry;
import com.veromodo.tioa.simulator.impl.SimImplFactory;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.ActualCompositeAutomaton;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimILFactory;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.ndr.SimNDRFire;
import com.veromodo.tioa.simulator.shell.ADTEvaluable;
import com.veromodo.tioa.simulator.shell.ILfromIOA;
import com.veromodo.tioa.simulator.shell.SimRunner;
import com.veromodo.tioa.simulator.shell.StepListener;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.IOAProperties;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SParseException;
import com.veromodo.tioa.util.sexp.SParser;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import com.veromodo.tioa.util.sexp.SValueException;
import com.veromodo.tioa.util.shell.MainArgParser;
import com.veromodo.tioa.util.shell.Shell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SimShell
extends Shell {
    protected HashMap<String, Evaluable> actualsMap = new HashMap();
    public static Vector<InputStream> configFiles = new Vector();
    static IOACategory cat = IOACategory.getInstance((String)SimShell.class.getName());
    static /* synthetic */ Class class$0;

    protected SimShell() {
    }

    public static void main(String[] args) {
        SimShell shell = new SimShell();
        shell.doMain2(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doMain2(String[] args) {
        this.doMain(args);
        int maxIter = 0;
        String stepsNum = "";
        String inFile = "";
        String autId = "";
        try {
            Simulator sim;
            ActualAutInterface actAut;
            SimAutomaton aut;
            IOAProperties options = new IOAProperties(System.getProperties());
            cat.debug((Object)options);
            if (options.getInt("tioa.util.shell.numArgs") < 2 || options.getInt("tioa.util.shell.numArgs") > 3) {
                this.printUsage();
                return;
            }
            List<String> configList = options.getList("tioa.util.shell.configFile");
            Iterator<String> configI = configList.iterator();
            while (true) {
                block16: {
                    if (configI.hasNext()) break block16;
                }
                String configFile = configI.next();
                try {
                    File file = new File(configFile);
                    FileInputStream fis = new FileInputStream(file);
                    configFiles.add(fis);
                }
                catch (IOException e) {
                    this.printError(e, configFile);
                    System.exit(1);
                }
            }
            options.setFlag("tioa.util.shell.guessingAutName", options.getInt("tioa.util.shell.numArgs") == 2);
            List<String> realArgs = options.getList("tioa.util.shell.args");
            stepsNum = realArgs.get(0);
            maxIter = Integer.parseInt(stepsNum);
            ILFactory.setInstance((ILFactory)new SimILFactory());
            ImplFactory.setInstance(new SimImplFactory());
            ImplRegistry.setInstance(new BasicImplRegistry());
            if (options.getFlag("tioa.util.shell.guessingAutName")) {
                inFile = realArgs.get(1);
                autId = "";
            } else {
                inFile = realArgs.get(2);
                autId = realArgs.get(1);
            }
            this.setOutputOptions(options, inFile);
            cat.debug((Object)options);
            options.setProperty("tioa.util.shell.fileName", inFile);
            InputStream in = null;
            in = SimShell.getExtension(inFile).equals(".tioa") ? ILfromIOA.ilFromIOA(inFile, options) : new FileInputStream(new File(inFile));
            ILParser parser = new ILParser((Reader)new InputStreamReader(in));
            Spec spec = parser.getSpec();
            if (options.getFlag("tioa.util.shell.debugIL")) {
                cat.debug((Object)"Printing out IL for debugging");
                PrintWriter pw = new PrintWriter(System.out);
                iprinter ip = new iprinter(pw);
                spec.toSValue().print(ip);
                pw.flush();
                System.out.println("\n\n");
                System.exit(0);
            }
            if (options.getFlag("tioa.util.shell.guessingAutName")) {
                if (spec.nAutomata() != 1) {
                    System.err.println("More than one automaton detected.  Please specify one to simulate.");
                    return;
                }
                Enumeration enum1 = spec.enumAutomata();
                aut = (SimAutomaton)enum1.nextElement();
                autId = aut.getName();
            } else {
                aut = (SimAutomaton)spec.getAutomaton(autId);
            }
            Vector<Evaluable> actuals = new Vector<Evaluable>();
            int i = 0;
            while (true) {
                if (i >= aut.getFormals().size()) {
                    actAut = aut.newActualAutomaton(actuals);
                    sim = new Simulator(actAut);
                }
                SimVarRefTerm f = (SimVarRefTerm)aut.getFormals().elementAt(i);
                Evaluable e = this.actualsMap.get(f.getRefVariable().getName());
                if (e == null) {
                    throw new Error("Formal " + f.getRefVariable().getName() + " not initialized");
                }
                actuals.add(e);
                ++i;
            }
            StepListener sl = new StepListener(sim, options.getFlag("tioa.util.shell.outputTraces") ? StepListener.V0_TRACES : (options.getFlag("tioa.util.shell.outputTransitions") ? StepListener.V1_TRANSITIONS : (options.getFlag("tioa.util.shell.outputState") ? StepListener.V3_STATE : StepListener.V2_MODIFIED)));
            if (actAut.isComposite()) {
                sl.setComposite();
            }
            sim.addListener(sl);
            System.setProperties(options);
            SimRunner runner = new SimRunner(sim, maxIter);
            sim.addListener(runner);
            runner.initialize();
            runner.run();
            return;
        }
        catch (Exception e) {
            this.printError(e, inFile);
            System.exit(1);
        }
    }

    protected void printUsage() {
        System.err.println("usage: java SimShell [flags] <# steps> [<automaton name>] <IL filename> ");
        System.err.println("flags:");
        System.err.println(this.getUsageLong());
    }

    protected void printError(Exception exceptionToHandle, String inFile) {
        try {
            throw exceptionToHandle;
        }
        catch (CannotSimulateException cse) {
            System.err.println("Unable to simulate: " + cse.getMessage());
            System.exit(1);
        }
        catch (SimException se) {
            Throwable f = se.getPiggyback();
            if (f instanceof InvocationTargetException) {
                String msg;
                InvocationTargetException ite = (InvocationTargetException)f;
                Throwable e = ite.getTargetException();
                if (e instanceof NullPointerException) {
                    msg = "Null Pointer Exception thrown by an ADT";
                    msg = String.valueOf(msg) + " -- this probably means the Simulator tried to use a ";
                    msg = String.valueOf(msg) + "variable without first assigning a value to it.";
                }
                msg = e.getMessage();
                System.err.println("Error: " + msg);
                e.printStackTrace(System.err);
                System.err.println("Halting execution.");
                System.err.println();
                System.err.println();
                if (cat.isDebugEnabled()) {
                    System.err.println("Detailed reason: ");
                    e.printStackTrace();
                }
                cat.debug((Object)"SimException:", (Throwable)((Object)se));
                System.exit(1);
            } else if (f instanceof IllegalArgumentException || f instanceof NoSuchMethodException) {
                System.err.println("Error: " + se.getMessage());
                System.err.println("Halting execution.");
                System.err.println();
                System.err.println();
                if (cat.isDebugEnabled()) {
                    System.err.println("Detailed reason: ");
                    se.printStackTrace();
                }
                cat.debug((Object)"SimException:", (Throwable)((Object)se));
                System.exit(1);
            } else {
                System.err.println("Error:" + (Object)((Object)se));
                System.err.println("Halting execution.");
                System.err.println();
                System.err.println();
                if (cat.isDebugEnabled()) {
                    System.err.println("Detailed reason: ");
                    se.printStackTrace();
                }
                if (f != null) {
                    cat.error((Object)"piggyback: ", f);
                }
                System.exit(1);
            }
        }
        catch (Exception e) {
            super.printError(e, inFile);
            System.exit(1);
        }
    }

    protected void setDefaultOptions(IOAProperties options) {
        super.setDefaultOptions(options);
        this.addParserFlag("tioa.util.shell.outputTraces", "-outputTraces", MainArgParser.BOOLEAN, "Show only external transitions during execution");
        this.addParserFlag("tioa.util.shell.outputTransitions", "-outputTrans", MainArgParser.BOOLEAN, "Show only transitions during execution");
        this.addParserFlag("tioa.util.shell.outputState", "-outputState", MainArgParser.BOOLEAN, "Show all state variables during execution");
        this.addParserFlag("tioa.util.shell.rseed", "-rseed", MainArgParser.INT, "Set randomizer seed for regression resting");
        this.addParserFlag("tioa.util.shell.maxEnum", "-maxEnum", MainArgParser.INT, "Highest value to include when enumerating infinite sets");
        this.addParserFlag("tioa.util.shell.ndrSteps", "-ndrSteps", MainArgParser.INT, "Max number of steps to run NDR program without returning a fire statement");
        this.addParserFlag("tioa.util.shell.randComp", "-randComp", MainArgParser.BOOLEAN, "Resolve high level nondeterminism randomly (composite simulations)");
        this.addParserFlag("tioa.util.shell.weightComp", "-weightComp", MainArgParser.STRING, "File with weights for weighted high level NDR");
        this.addParserFlag("tioa.util.shell.formals", "-formals", MainArgParser.STRING, "File with formal parameter initial values");
        this.addParserFlag("tioa.util.shell.configFile", "-config", MainArgParser.STRINGS, "Use the given configuration file(s) for runtime class location");
    }

    protected void doStandardOptions(IOAProperties options) {
        super.doStandardOptions(options);
        try {
            BufferedReader br;
            InputStreamReader inr;
            FileInputStream in;
            if (options.getProperty("tioa.util.shell.rseed") != null) {
                NonDet.setSeed(options.getInt("tioa.util.shell.rseed"));
                SimNDRFire.setSeed(options.getInt("tioa.util.shell.rseed"));
                DaikonListener.setSeed(options.getInt("tioa.util.shell.rseed"));
            }
            options.getFlag("tioa.util.shell.big");
            if (options.getProperty("tioa.util.shell.maxEnum") != null) {
                NatSort.MAX_LOOK = options.getInt("tioa.util.shell.maxEnum");
                Assert.assertTrue(NatSort.MAX_LOOK >= 0, "Maximum look value must be zero or greater");
            }
            if (options.getProperty("tioa.util.shell.ndrSteps") != null) {
                Simulator.MAX_NDR_STEPS = options.getInt("tioa.util.shell.ndrSteps");
                Assert.assertTrue(Simulator.MAX_NDR_STEPS >= 1, "Must run NDR for at least one step");
            }
            if (options.getProperty("tioa.util.shell.weightComp") != null) {
                try {
                    in = new FileInputStream(new File(options.getString("tioa.util.shell.weightComp")));
                    inr = new InputStreamReader(in);
                    br = new BufferedReader(inr);
                    try {
                        ActualCompositeAutomaton.setWeights(br);
                    }
                    catch (SimException e) {
                        throw new Error("Weight File Error: " + e.getMessage() + "\nHalting.");
                    }
                }
                catch (FileNotFoundException fnfe) {
                    throw new Error("Weight file not found.  \nHalting execution");
                }
            }
            if (options.getProperty("tioa.util.shell.formals") != null) {
                try {
                    in = new FileInputStream(new File(options.getString("tioa.util.shell.formals")));
                    inr = new InputStreamReader(in);
                    br = new BufferedReader(inr);
                    SParser parser = new SParser();
                    SValue sValue = parser.parse((Reader)br);
                    if (!(sValue instanceof SList)) {
                        throw new Error("Formals file invalid. Should be an SList");
                    }
                    SList formals = (SList)sValue;
                    int i = 0;
                    while (i < formals.size()) {
                        SValue formal = formals.getSValue(i);
                        if (!(formal instanceof SList) || ((SList)formal).size() != 3) {
                            throw new Error("Formals file invalid.\nEvery formal should be an should be an SList of the form\n(name className value)");
                        }
                        SList lformal = (SList)formal;
                        SString formalName = lformal.getSString(0);
                        SString className = lformal.getSString(1);
                        SValue value = lformal.getSValue(2);
                        ADT adtValue = ADT.construct((SValue)new SList(new SValue[]{className, value}));
                        ADTEvaluable actual = new ADTEvaluable(adtValue);
                        this.actualsMap.put(formalName.toString(), actual);
                        ++i;
                    }
                }
                catch (FileNotFoundException fnfe) {
                    throw new Error("Formals file not found.  \nHalting execution");
                }
                catch (SParseException e) {
                    throw new Error("Formals file invalid.  \nHalting execution");
                }
                catch (SValueException e) {
                    throw new Error("Formals file invalid.  \nHalting execution");
                }
            }
            if (options.getProperty("tioa.util.shell.randComp") != null) {
                ActualCompositeAutomaton.componentSelectionPolicy = 1;
            }
        }
        catch (Error e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    protected void setOutputOptions(IOAProperties options, String fileName) {
        super.setOutputOptions(options, fileName);
        if (options.getProperty("tioa.util.shell.outDtrace") == null) {
            options.setProperty("tioa.util.shell.outDtrace", String.valueOf(options.getProperty("tioa.util.shell.out")) + ".dtrace");
        }
        if (options.getProperty("tioa.util.shell.outDecls") == null) {
            options.setProperty("tioa.util.shell.outDecls", String.valueOf(options.getProperty("tioa.util.shell.out")) + ".decls");
        }
        if (options.getProperty("tioa.util.shell.outSpinfo") == null) {
            options.setProperty("tioa.util.shell.outSpinfo", String.valueOf(options.getProperty("tioa.util.shell.out")) + ".spinfo");
        }
    }
}

