/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.shell;

import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.NOPstep;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.ui.EndStepEvent;
import com.veromodo.tioa.simulator.ui.InvariantFailedEvent;
import com.veromodo.tioa.simulator.ui.SimEvent;
import com.veromodo.tioa.simulator.ui.SimListener;
import com.veromodo.tioa.util.logger.IOACategory;

class SimRunner
implements SimListener {
    protected Simulator sim;
    protected boolean canContinue = true;
    protected boolean errors = false;
    protected int maxIter;
    private static final IOACategory cat = IOACategory.getInstance((String)SimRunner.class.getName());
    static /* synthetic */ Class class$0;

    public SimRunner(Simulator sim, int maxIter) {
        this.sim = sim;
        this.maxIter = maxIter;
    }

    public void initialize() throws SimException {
        this.canContinue = this.sim.initialize();
    }

    public void run() throws SimException {
        int iter = 0;
        while (this.canContinue && iter < this.maxIter) {
            Step step = this.sim.step();
            if (step instanceof ExecTrajectory && (((ExecTrajectory)step).getOrder() == 1 || ((ExecTrajectory)step).getOrder() == 2) || step instanceof NOPstep) {
                --iter;
            } else if (step != null) {
                this.sim.registerEvent(new EndStepEvent(step, step.getAutomaton()));
            }
            this.canContinue = this.sim.canStep();
            ++iter;
        }
        if (!this.errors) {
            System.out.println("No errors");
        } else {
            System.out.println(">>>> Some errors occured during simulation");
        }
    }

    public boolean handleSimEvent(SimEvent ev) throws SimException {
        if (ev instanceof InvariantFailedEvent) {
            this.errors = true;
        }
        if (ev.isError()) {
            System.err.println(">>>> This event is an error; halting");
            this.canContinue = false;
            System.exit(1);
        }
        return this.canContinue;
    }
}

