/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.shell;

import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.PairedSimulator;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.PairedImplAutomaton;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.shell.StepListener;
import com.veromodo.tioa.simulator.ui.ExecEndedEvent;
import com.veromodo.tioa.simulator.ui.InitializedEvent;
import com.veromodo.tioa.simulator.ui.InvariantFailedEvent;
import com.veromodo.tioa.simulator.ui.SimEvent;
import com.veromodo.tioa.simulator.ui.SimRelFailedEvent;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;

class PairedStepListener
extends StepListener {
    private static final IOACategory cat = IOACategory.getInstance((String)PairedStepListener.class.getName());
    private PairedImplAutomaton implAut;
    private ActualAutInterface specAut;
    static /* synthetic */ Class class$0;

    public PairedStepListener(PairedSimulator sim, PairedImplAutomaton implAut, ActualAutInterface specAut) {
        super(sim);
        this.implAut = implAut;
        this.specAut = specAut;
    }

    public PairedStepListener(PairedSimulator sim, PairedImplAutomaton implAut, ActualAutInterface specAut, StepListener.VerbosityEnum verbosity) {
        super(sim, verbosity);
        this.implAut = implAut;
        this.specAut = specAut;
    }

    public boolean handleSimEvent(SimEvent ev) {
        cat.debug((Object)("Handle sim event:" + ev));
        if (ev instanceof InitializedEvent) {
            if (this.verbosity.compareTo(V2_MODIFIED) >= 0) {
                System.out.println("Initialization");
                this.printVars(this.implAut, false);
                this.printVars(this.specAut, true);
            } else {
                System.out.println("Automaton initialized");
            }
            this.pc = 0;
        } else if (ev instanceof ActualTransition) {
            ((ActualTransition)ev).printAutomatonName = true;
            if (this.verbosity.compareTo(V2_MODIFIED) >= 0) {
                this.printTransitionInfo((ActualTransition)ev);
            } else {
                ActualTransition trans = (ActualTransition)ev;
                if (this.verbosity.compareTo(V1_TRANSITIONS) >= 0) {
                    System.out.print(this.pc_space(trans.getAutomaton() != this.specAut ? this.pc : -1));
                    System.out.println(trans.getDescription());
                } else if (trans.getTransition().getAction().getType() != 2) {
                    System.out.print(this.pc_space(this.pc));
                    System.out.println(trans.getDescription());
                }
            }
        } else if (ev instanceof ExecTrajectory) {
            if (this.verbosity.compareTo(V2_MODIFIED) >= 0) {
                this.printTrajectoryInfo((ExecTrajectory)ev);
            } else {
                ExecTrajectory traj = (ExecTrajectory)ev;
                traj.printAutomatonName = true;
                System.out.print(this.pc_space(traj.getAutomaton() != this.specAut ? this.pc : -1));
                System.out.println(traj.toString());
            }
        } else {
            if (ev instanceof ExecEndedEvent) {
                System.out.println("No more steps");
                return false;
            }
            if (ev instanceof InvariantFailedEvent) {
                InvariantFailedEvent ife = (InvariantFailedEvent)ev;
                System.out.println(">>>> Invariant " + ife.inv.getName() + " failed");
            } else if (ev instanceof SimRelFailedEvent) {
                SimRelFailedEvent srfe = (SimRelFailedEvent)ev;
                System.out.println(">>>> " + srfe.eventDescription());
            } else {
                return super.handleSimEvent(ev);
            }
        }
        return true;
    }

    protected void printTransitionInfo(ActualTransition t) {
        t.printAutomatonName = true;
        if (t.getAutomaton() == this.specAut) {
            System.out.println("     " + t.eventDescription());
            this.printVars(this.specAut, true);
        } else {
            System.out.println(t.eventDescription());
            this.printVars(this.implAut, false);
        }
    }

    protected void printTrajectoryInfo(ExecTrajectory t) {
        t.printAutomatonName = true;
        if (t.getAutomaton() == this.specAut) {
            System.out.println("     trajectory " + t.getDescription());
            this.printVars(this.specAut, true);
        } else {
            System.out.println("trajectory " + t.getDescription());
            this.printVars(this.implAut, false);
        }
    }

    protected void printVars(ActualAutInterface aut, boolean isSpec) {
        Enumeration enum1 = this.verbosity == V2_MODIFIED ? aut.enumModifiedVariables() : aut.enumVariables();
        while (enum1.hasMoreElements()) {
            SimVariable var = (SimVariable)enum1.nextElement();
            System.out.println("       " + var.getAutName() + "." + var.getName() + " -> " + var.value);
        }
    }
}

