/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.shell;

import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.PairedSimulator;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.PairedImplAutomaton;
import com.veromodo.tioa.simulator.shell.PairedShell;
import com.veromodo.tioa.simulator.ui.EndStepEvent;
import com.veromodo.tioa.simulator.ui.SimEvent;
import com.veromodo.tioa.simulator.ui.SimListener;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.List;

class PairedSimRunner
implements SimListener {
    private static final IOACategory debug = IOACategory.getInstance((String)PairedSimRunner.class.getName());
    protected PairedSimulator sim;
    protected PairedImplAutomaton autImpl;
    protected ActualAutInterface autSpec;
    protected int maxIter;
    protected boolean canContinue = true;
    protected boolean errors = false;
    static /* synthetic */ Class class$0;

    public PairedSimRunner(PairedImplAutomaton autImpl, ActualAutInterface autSpec, PairedSimulator sim, int maxIter) {
        this.autImpl = autImpl;
        this.autSpec = autSpec;
        this.sim = sim;
        this.maxIter = maxIter;
    }

    public void initialize() throws SimException {
        this.canContinue = this.sim.initialize();
    }

    public void run() throws SimException {
        int iter = 0;
        while (this.canContinue && iter < this.maxIter) {
            Step implStep = this.sim.preStep();
            if (implStep == null) {
                this.sim.doStep(implStep);
            } else {
                List specProgram;
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("implStep: " + implStep));
                }
                if (implStep instanceof ActualTransition) {
                    ActualTransition implTrans = (ActualTransition)implStep;
                    specProgram = this.autImpl.preDriveSpecTrans(this.sim, implTrans);
                    if (debug.isDebugEnabled()) {
                        debug.debug((Object)("SpecProgram: " + specProgram));
                    }
                    this.sim.doStep(implTrans);
                    this.autImpl.doDriveSpecTrans(this.sim, implTrans, specProgram);
                    this.sim.registerEvent(new EndStepEvent(implTrans, implTrans.getAutomaton()));
                } else if (implStep instanceof ExecTrajectory) {
                    ExecTrajectory implTraj = (ExecTrajectory)implStep;
                    specProgram = this.autImpl.preDriveSpecTraj(this.sim, implTraj);
                    if (debug.isDebugEnabled()) {
                        debug.debug((Object)("SpecProgram: " + specProgram));
                    }
                    this.sim.doStep(implTraj);
                    this.autImpl.doDriveSpecTraj(this.sim, implTraj, specProgram);
                    this.sim.registerEvent(new EndStepEvent(implTraj, implTraj.getAutomaton()));
                }
            }
            this.canContinue = this.sim.canStep();
            ++iter;
        }
        if (!this.errors) {
            System.out.println(">>>> No errors");
        } else {
            System.out.println(">>>> Some errors occured during simulation");
        }
    }

    public boolean handleSimEvent(SimEvent ev) throws SimException {
        if (PairedShell.debug.isDebugEnabled()) {
            PairedShell.debug.debug((Object)("HandleSimEvent: " + ev));
        }
        if (ev.isError()) {
            System.err.println(">>>> This event is an error; halting");
            this.errors = true;
            this.canContinue = false;
            System.exit(1);
        }
        return !ev.isError();
    }
}

