/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.shell;

import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.SimulationRelation;
import com.veromodo.tioa.il.nodes.Spec;
import com.veromodo.tioa.registry.ImplFactory;
import com.veromodo.tioa.simulator.ImplRegistry;
import com.veromodo.tioa.simulator.daikon.PairedDaikonListener;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.PairedSimulator;
import com.veromodo.tioa.simulator.impl.BasicImplRegistry;
import com.veromodo.tioa.simulator.impl.SimImplFactory;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.PairedImplAutomaton;
import com.veromodo.tioa.simulator.nodes.SimILFactory;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.ndr.PairedSpecChoice;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.simulator.nodes.ndr.SimSimulationRelation;
import com.veromodo.tioa.simulator.shell.ILfromIOA;
import com.veromodo.tioa.simulator.shell.PairedSimRunner;
import com.veromodo.tioa.simulator.shell.PairedStepListener;
import com.veromodo.tioa.simulator.shell.SimShell;
import com.veromodo.tioa.simulator.shell.StepListener;
import com.veromodo.tioa.util.IOAProperties;
import com.veromodo.tioa.util.logger.IOACategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class PairedShell
extends SimShell {
    static final IOACategory debug = IOACategory.getInstance((String)PairedShell.class.getName());
    static /* synthetic */ Class class$0;

    protected PairedShell() {
    }

    public static void main(String[] args) {
        PairedShell shell = new PairedShell();
        shell.doMain2(args);
    }

    protected void doMain2(String[] args) {
        this.doMain(args);
        String inFileName = "";
        try {
            IOAProperties options = new IOAProperties(System.getProperties());
            if (options.getInt("tioa.util.shell.numArgs") < 4) {
                this.printUsage();
                return;
            }
            List<String> realArgs = options.getList("tioa.util.shell.args");
            int maxIter = Integer.valueOf(realArgs.get(0));
            String implAutId = realArgs.get(1);
            String specAutId = realArgs.get(2);
            inFileName = realArgs.get(3);
            System.setProperty("tioa.util.shell.fileName", inFileName);
            this.setOutputOptions(options, inFileName);
            InputStream in = PairedShell.getExtension(inFileName).equals(".tioa") ? ILfromIOA.ilFromIOA(inFileName, options) : new FileInputStream(new File(inFileName));
            ILFactory.setInstance((ILFactory)new SimILFactory());
            ImplFactory.setInstance(new SimImplFactory());
            ImplRegistry.setInstance(new BasicImplRegistry());
            ILParser parser = new ILParser((Reader)new InputStreamReader(in));
            Spec spec = parser.getSpec();
            SimPrimitiveAutomaton implAut = (SimPrimitiveAutomaton)spec.getAutomaton(implAutId);
            SimPrimitiveAutomaton specAut = (SimPrimitiveAutomaton)spec.getAutomaton(specAutId);
            PairedSpecChoice.install(specAut);
            SimulationRelation srel = null;
            Enumeration enum1 = implAut.enumImplSimulations();
            while (enum1.hasMoreElements()) {
                SimulationRelation _srel = (SimulationRelation)enum1.nextElement();
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("trying simulation: impl = " + _srel.getImplAutomaton().getName() + ", spec = " + _srel.getSpecAutomaton().getName()));
                }
                if (_srel.getSpecAutomaton() != specAut) continue;
                if (srel != null) {
                    System.err.println("warning: more than one matching simulation relation found: using the first one");
                    continue;
                }
                srel = _srel;
            }
            if (srel == null) {
                System.err.println("no matching simulation relation found");
                return;
            }
            Vector<Evaluable> specActuals = new Vector<Evaluable>();
            int i = 0;
            while (i < specAut.getFormals().size()) {
                SimVarRefTerm f = (SimVarRefTerm)specAut.getFormals().elementAt(i);
                Evaluable e = (Evaluable)this.actualsMap.get(f.getRefVariable().getName());
                if (e == null) {
                    throw new Error("Formal " + f.getRefVariable().getName() + " not initialized");
                }
                specActuals.add(e);
                ++i;
            }
            Vector<Evaluable> implActuals = new Vector<Evaluable>();
            int i2 = 0;
            while (i2 < implAut.getFormals().size()) {
                SimVarRefTerm f = (SimVarRefTerm)implAut.getFormals().elementAt(i2);
                Evaluable e = (Evaluable)this.actualsMap.get(f.getRefVariable().getName());
                if (e == null) {
                    throw new Error("Formal " + f.getRefVariable().getName() + " not initialized");
                }
                implActuals.add(e);
                ++i2;
            }
            ActualAutInterface actualSpecAut = specAut.newActualAutomaton(specActuals);
            ActualAutInterface actualImplAut = implAut.newActualAutomaton(implActuals);
            PairedImplAutomaton pairedImplAut = new PairedImplAutomaton((ActualAutomaton)actualImplAut, (ActualAutomaton)actualSpecAut, (SimSimulationRelation)srel);
            PairedSimulator sim = new PairedSimulator(pairedImplAut, actualSpecAut);
            sim.addListener(new PairedStepListener(sim, pairedImplAut, actualSpecAut, options.getFlag("tioa.util.shell.outputTraces") ? StepListener.V0_TRACES : (options.getFlag("tioa.util.shell.outputTransitions") ? StepListener.V1_TRANSITIONS : (options.getFlag("tioa.util.shell.outputState") ? StepListener.V3_STATE : StepListener.V2_MODIFIED))));
            PairedSimRunner runner = new PairedSimRunner(pairedImplAut, actualSpecAut, sim, maxIter);
            sim.addListener(runner);
            System.setProperties(options);
            if (options.getFlag("tioa.util.shell.daikon")) {
                PairedDaikonListener dl = new PairedDaikonListener(sim, spec.getSymbolTable());
                if (options.getFlag("tioa.util.shell.daikonIgnoreFirst")) {
                    dl.getProperties().setFlag(String.valueOf("tioa.simulator.daikon.") + "ignoreFirst", true);
                }
                sim.addListener(dl);
            }
            runner.initialize();
            runner.run();
        }
        catch (Exception e) {
            this.printError(e, inFileName);
            System.exit(1);
        }
    }

    protected void printUsage() {
        System.err.println("usage: java PairedShell [flags] <numSteps> <implAut> <specAut> <IL filename>");
        System.err.println("flags:");
        System.err.println(this.getUsageLong());
    }
}

