/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.NameCollisionException;
import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.BasicActionTable;
import com.veromodo.tioa.il.nodes.BasicStateTable;
import com.veromodo.tioa.il.nodes.BasicTrajectoryTable;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.State;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Statement;
import com.veromodo.tioa.il.nodes.Task;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.TrajectoryTable;
import com.veromodo.tioa.il.nodes.Value;
import com.veromodo.tioa.il.nodes.ndr.NDRPrimitiveAutomaton;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Compilable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.DetActualAutomaton;
import com.veromodo.tioa.simulator.nodes.NDRActualAutomaton;
import com.veromodo.tioa.simulator.nodes.SimAction;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimFuncDecl;
import com.veromodo.tioa.simulator.nodes.SimInvariant;
import com.veromodo.tioa.simulator.nodes.SimProgram;
import com.veromodo.tioa.simulator.nodes.SimState;
import com.veromodo.tioa.simulator.nodes.SimTrajectory;
import com.veromodo.tioa.simulator.nodes.SimTransition;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimPrimitiveAutomaton
extends NDRPrimitiveAutomaton
implements SimAutomaton {
    private static final IOACategory cat = IOACategory.getInstance((String)SimPrimitiveAutomaton.class.getName());
    private Executable ndrProgram_c = null;
    private ExecControl ndrControl = null;
    private Hashtable variableStore = new Hashtable();
    private Hashtable transitionStore = new Hashtable();
    private Hashtable<String, SimTrajectory> trajectoryStore = new Hashtable();
    private Vector withForms = null;
    private Vector withActs = null;
    private String basedOnAutomaton = null;
    public boolean compiled = false;
    protected Sort sort;
    static /* synthetic */ Class class$0;

    public Vector getWithForms() {
        return this.withForms;
    }

    public Vector getWithActs() {
        return this.withActs;
    }

    public SimPrimitiveAutomaton(String name, Vector<Term> formals, Term where, ActionTable actions, StateTable states, Vector<FuncDecl> funcs, Term soThat, Vector<Task> tasks, TrajectoryTable trajs) {
        super(name, formals, where, actions, states, funcs, soThat, tasks, trajs);
    }

    public SimPrimitiveAutomaton() {
    }

    public Executable getSchedulePC() {
        return this.ndrProgram_c;
    }

    public Enumeration enumScheduleStates() {
        return this.ndrStates.enumerate();
    }

    public void parseExtension(SList sexp, ILParser parser) throws ILException, SExpException, IOException {
        cat.debug((Object)("ParseExtension: " + sexp));
        super.parseExtension(sexp, parser);
        if (this.ndrProgram != null) {
            cat.debug((Object)"parseExtension() [compiling ndrProgram]");
            try {
                this.ndrProgram_c = ((Compilable)this.ndrProgram).compile(null);
            }
            catch (SimException e) {
                throw new ILException("SimException caught: ", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public ActualAutInterface newActualAutomaton(Vector<Evaluable> actuals) throws SimException {
        this.copyAndupdateInvariants();
        if (this.ndrProgram_c == null) {
            return new DetActualAutomaton(this, (Vector)actuals);
        }
        return new NDRActualAutomaton(this, actuals);
    }

    public SimPrimitiveAutomaton(PrimitiveAutomaton obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
    }

    @Override
    public ActualAutInterface newActualAutomaton(Vector actuals, Vector withForms, Vector withActs) throws SimException {
        this.withForms = withForms;
        this.withActs = withActs;
        return this.newActualAutomaton(actuals);
    }

    @Override
    public Entity select(ExecControl c, String label) throws SimException {
        try {
            return ((SimVariable)this.states.getByName(label).getVariable()).evaluate(c, false);
        }
        catch (LookupException e) {
            throw new SimException("cannot find state variable: " + label, e);
        }
    }

    @Override
    public void assignSelect(ExecControl c, String label, Entity value) throws SimException {
        try {
            ((SimVariable)this.states.getByName(label).getVariable()).assign(c, value);
        }
        catch (LookupException e) {
            throw new SimException("cannot find state variable: " + label, e);
        }
    }

    public boolean equals(Entity entWcopy) {
        throw new Error();
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setAutomatonSort(Sort sort) {
        this.sort = sort;
    }

    public PrimitiveAutomaton copy(String newName) {
        cat.debug((Object)("Begin Copying : " + newName));
        SimPrimitiveAutomaton newComponent = this.copyComponent(newName);
        newComponent.updateActions();
        newComponent.updateTransitions();
        newComponent.updateTrajectories();
        this.copySchedule(newComponent);
        cat.debug((Object)("Done Copying : " + newName));
        return newComponent;
    }

    private void copySchedule(SimPrimitiveAutomaton newComp) {
        BasicStateTable stTabNdr = new BasicStateTable();
        Executable resC = null;
        if (this.getNDRStates() != null) {
            Enumeration enumStNdr = this.getNDRStates().enumerate();
            while (enumStNdr.hasMoreElements()) {
                SimState simSNdr = (SimState)((Object)enumStNdr.nextElement());
                cat.debug((Object)("simSNDR : " + (Object)((Object)simSNdr)));
                SimState copiedSNdr = simSNdr.copy(newComp.getName());
                try {
                    stTabNdr.put((State)copiedSNdr);
                }
                catch (NameCollisionException e) {
                    cat.debug((Object)"Name COLLISION whily copying schedule");
                }
            }
        } else {
            stTabNdr = this.getNDRStates();
        }
        SimProgram simProg = (SimProgram)this.getNDRProgram();
        if (simProg != null) {
            simProg = simProg.copy();
        }
        newComp.setNdrStates((StateTable)stTabNdr);
        newComp.setNdrProgram((Program)simProg);
        if (simProg != null) {
            try {
                resC = ((SimProgram)newComp.getNDRProgram()).compile(null, newComp);
                newComp.setNdrProgram_c(resC);
            }
            catch (SimException e) {
                cat.debug((Object)"NDR Compilation Problem during copy");
            }
        }
    }

    private SimPrimitiveAutomaton copyComponent(String newName) {
        this.variableStore = new Hashtable();
        BasicActionTable acTab = new BasicActionTable();
        Enumeration enumActs = this.actions.enumActions();
        while (enumActs.hasMoreElements()) {
            Action act = (Action)enumActs.nextElement();
            SimAction newAct = ((SimAction)act).copy(this.variableStore);
            try {
                acTab.put((Action)newAct);
            }
            catch (NameCollisionException nameCollisionException) {
                // empty catch block
            }
        }
        BasicTrajectoryTable newtrajTab = new BasicTrajectoryTable();
        Enumeration enumTrajs = this.trajectories.enumTrajectories();
        while (enumTrajs.hasMoreElements()) {
            Trajectory traj = (Trajectory)enumTrajs.nextElement();
            SimTrajectory newTraj = ((SimTrajectory)traj).copy();
            try {
                newtrajTab.putTrajectory((Trajectory)newTraj);
            }
            catch (NameCollisionException nameCollisionException) {
                // empty catch block
            }
        }
        Vector<Term> newFormals = null;
        if (this.getFormals() != null) {
            newFormals = new Vector<Term>();
            Enumeration enumForms = this.getFormals().elements();
            while (enumForms.hasMoreElements()) {
                SimVarRefTerm formal = (SimVarRefTerm)enumForms.nextElement();
                SimVarRefTerm copiedFormal = (SimVarRefTerm)formal.copy();
                newFormals.add((Term)copiedFormal);
                SimVariable simVar = (SimVariable)copiedFormal.getRefVariable();
                this.putVarInStore(simVar.getId(), copiedFormal);
            }
        }
        Vector<FuncDecl> newFuncs = null;
        if (this.getFuncDecls() != null) {
            newFuncs = new Vector<FuncDecl>();
            Enumeration enumFuncs = this.getFuncDecls().elements();
            while (enumFuncs.hasMoreElements()) {
                SimFuncDecl func = (SimFuncDecl)((Object)enumFuncs.nextElement());
                SimFuncDecl copiedFunc = func.copy();
                newFuncs.add((FuncDecl)copiedFunc);
            }
        }
        Term newwhere = null;
        if (this.where != null) {
            newwhere = (Term)((Copyable)this.where).copy();
            ((Copyable)newwhere).update(this);
        }
        BasicStateTable stTab = new BasicStateTable();
        Enumeration enum1 = this.states.enumerate();
        while (enum1.hasMoreElements()) {
            SimState simS = (SimState)((Object)enum1.nextElement());
            cat.debug((Object)("simS : " + (Object)((Object)simS)));
            SimState copiedS = simS.copy(newName);
            cat.debug((Object)("copied : " + (Object)((Object)copiedS)));
            Value initVal = copiedS.getInitialValue();
            if (initVal != null) {
                ((Copyable)initVal).update(this);
            }
            try {
                stTab.put((State)copiedS);
            }
            catch (NameCollisionException e) {
                System.out.println("ERROR");
            }
        }
        SimPrimitiveAutomaton toreturn = new SimPrimitiveAutomaton(this.name, newFormals, newwhere, (ActionTable)acTab, (StateTable)stTab, newFuncs, this.soThat, this.tasks, (TrajectoryTable)newtrajTab);
        toreturn.setVariableStore(this.variableStore);
        toreturn.setInvariants(this.getInvariants());
        return toreturn;
    }

    private void updateTransitions() {
        Enumeration enumTrans = this.getActionTable().enumTransitions();
        while (enumTrans.hasMoreElements()) {
            SimTransition trans = (SimTransition)((Object)enumTrans.nextElement());
            this.updateTransition(trans);
        }
    }

    private void updateActions() {
        Enumeration enumActs = this.getActionTable().enumActions();
        while (enumActs.hasMoreElements()) {
            SimAction act = (SimAction)((Object)enumActs.nextElement());
            act.update(this);
        }
    }

    private void updateTrajectories() {
        Enumeration trajs = this.getTrajectoryTable().enumTrajectories();
        while (trajs.hasMoreElements()) {
            SimTrajectory traj = (SimTrajectory)((Object)trajs.nextElement());
            this.updateTrajectory(traj);
        }
    }

    public SimVarRefTerm getVarFromStore(String id) {
        return (SimVarRefTerm)this.variableStore.get(id);
    }

    public void putVarInStore(String id, SimVarRefTerm sv) {
        this.variableStore.put(id, sv);
    }

    public SimTransition getTransFromStore(String id) {
        return (SimTransition)((Object)this.transitionStore.get(id));
    }

    public void putTransInStore(String id, SimTransition st) {
        this.transitionStore.put(id, st);
    }

    protected void updateTransition(SimTransition in) {
        SimTransition t = in;
        cat.debug((Object)("Updating Transition : " + (Object)((Object)t)));
        Program prog = t.getEffect();
        cat.debug((Object)("Effect : " + prog));
        if (prog != null) {
            Vector statem = prog.getStatements();
            Enumeration enumst = statem.elements();
            while (enumst.hasMoreElements()) {
                Statement st = (Statement)enumst.nextElement();
                ((Copyable)st).update(this);
            }
        }
        if (t.getPrecondition() != null) {
            ((Copyable)t.getPrecondition()).update(this);
        }
        if (t.getWherePred() != null) {
            ((Copyable)t.getWherePred()).update(this);
        }
        if (t.getSoThatPred() != null) {
            ((Copyable)t.getSoThatPred()).update(this);
        }
        if (t.getAction().getWherePred() != null) {
            ((Copyable)t.getAction().getWherePred()).update(this);
        }
        cat.debug((Object)("Adding transition " + (Object)((Object)t) + " to store"));
        this.putTransInStore(t.getTransitionId(), t);
    }

    public SimTrajectory getTrajFromStore(String id) {
        return this.trajectoryStore.get(id);
    }

    public void putTrajInStore(String id, SimTrajectory st) {
        this.trajectoryStore.put(id, st);
    }

    protected void updateTrajectory(SimTrajectory in) {
        SimTrajectory t = in;
        cat.debug((Object)("Updating Trajectory : " + (Object)((Object)t)));
        if (t.getInvariant() != null) {
            ((Copyable)t.getInvariant()).update(this);
        }
        if (t.getStopCondition() != null) {
            ((Copyable)t.getStopCondition()).update(this);
        }
        if (t.getFuncDeclarations() != null) {
            Enumeration funcs = t.getFuncDeclarations().elements();
            while (funcs.hasMoreElements()) {
                FuncDecl func = (FuncDecl)funcs.nextElement();
                ((Copyable)func).update(this);
            }
        }
        Enumeration terms = t.getEvolvePredicates().elements();
        while (terms.hasMoreElements()) {
            Term term = (Term)terms.nextElement();
            ((Copyable)term).update(this);
        }
        cat.debug((Object)("Adding trajectory " + (Object)((Object)t) + " to store"));
        this.putTrajInStore(t.getTrajectoryId(), t);
    }

    private void copyAndupdateInvariants() {
        Vector<SimInvariant> newInvariants = new Vector<SimInvariant>();
        Enumeration enumInvar = this.enumInvariants();
        while (enumInvar.hasMoreElements()) {
            SimInvariant inv = ((SimInvariant)((Object)enumInvar.nextElement())).copy();
            inv.setAutomaton(this);
            ((Copyable)inv.getPredicate()).update(this);
            newInvariants.add(inv);
        }
        this.setInvariants(newInvariants);
    }

    @Override
    public void setName(String newName) {
        this.basedOnAutomaton = this.name;
        this.name = newName;
    }

    public void setVariableStore(Hashtable hash) {
        this.variableStore = hash;
    }

    public String getBasedOnAutomaton() {
        return this.basedOnAutomaton;
    }

    private void setNdrStates(StateTable st) {
        this.ndrStates = st;
    }

    private void setNdrProgram(Program prog) {
        this.ndrProgram = prog;
    }

    private void setNdrProgram_c(Executable prog) {
        this.ndrProgram_c = prog;
    }
}

