/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.ndr.NDRFollowTrajectory;
import com.veromodo.tioa.il.nodes.ndr.NDRPrimitiveAutomaton;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Compilable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.exec.FollowProduct;
import com.veromodo.tioa.simulator.exec.ThrowerExecutable;
import com.veromodo.tioa.simulator.nodes.SimILInstanceFactory;
import com.veromodo.tioa.simulator.nodes.SimTrajectory;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;

public class SimNDRFollowTrajectory
extends NDRFollowTrajectory
implements Compilable,
Copyable {
    public SimNDRFollowTrajectory(SimPrimitiveAutomaton aut, Trajectory traj, Term duration) {
        super((NDRPrimitiveAutomaton)aut, traj, duration);
    }

    public Executable compile(Executable after) throws SimException {
        final String compName = this.isComposite() ? this.getAut().getName() : null;
        final String schedName = this.handleName;
        return new ThrowerExecutable(after){

            public ExecProduct computeProduct(ExecControl c) throws SimException {
                if (SimNDRFollowTrajectory.this.isComposite()) {
                    return new FollowProduct(c, (SimTrajectory)SimNDRFollowTrajectory.this.traj, SimNDRFollowTrajectory.this.duration, compName, schedName);
                }
                return new FollowProduct(c, (SimTrajectory)SimNDRFollowTrajectory.this.traj, SimNDRFollowTrajectory.this.duration);
            }
        };
    }

    public void update(SimPrimitiveAutomaton autPassed) {
        this.aut = autPassed;
        this.traj = autPassed.getTrajFromStore(this.traj.getTrajectoryId());
        ((Copyable)this.duration).update(autPassed);
    }

    public SimNDRFollowTrajectory copy() {
        SimTrajectory newTraj = (SimTrajectory)this.traj;
        Term newDuration = (Term)((Copyable)this.duration).copy();
        return new SimNDRFollowTrajectory((SimPrimitiveAutomaton)this.aut, (Trajectory)newTraj, newDuration);
    }

    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return ((SimILInstanceFactory)f).instanceNDRFollowTrajectory(this);
    }

    public SimNDRFollowTrajectory(SimNDRFollowTrajectory obj, ILInstanceFactory f) throws ILException {
        super(obj.aut);
    }

    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.traj = (SimTrajectory)f.makeInstance((ILElement)this.traj);
        this.duration = (Term)f.makeInstance((ILElement)this.duration);
        return this;
    }
}

