/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.il.nodes.ndr.NDRFire;
import com.veromodo.tioa.il.nodes.ndr.NDRPrimitiveAutomaton;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Compilable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.exec.FireProduct;
import com.veromodo.tioa.simulator.exec.ThrowerExecutable;
import com.veromodo.tioa.simulator.nodes.SimILInstanceFactory;
import com.veromodo.tioa.simulator.nodes.SimTransition;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimNDRFire
extends NDRFire
implements Compilable,
Copyable {
    private static final IOACategory cat = IOACategory.getInstance((String)SimNDRFire.class.getName());
    static Random rnd = new Random();
    static /* synthetic */ Class class$0;

    public SimNDRFire(SimPrimitiveAutomaton aut, SimTransition trans, Vector<Term> actuals) {
        super((NDRPrimitiveAutomaton)aut, (Transition)trans, actuals);
    }

    public SimNDRFire(SimPrimitiveAutomaton aut) {
        super((NDRPrimitiveAutomaton)aut);
    }

    @Override
    public Executable compile(Executable after) {
        if (this.trans != null) {
            String tname = null;
            final boolean isC = this.isComposite();
            cat.debug((Object)("composite fire: " + isC));
            if (isC) {
                tname = this.getAut().getName();
            }
            final String myname = tname;
            final String schedName = this.handleName;
            cat.debug((Object)("my name is " + myname + " schedName is " + schedName + " Transition " + this.trans + " TransitionId " + this.trans.getTransitionId()));
            return new ThrowerExecutable(after){

                public ExecProduct computeProduct(ExecControl c) throws SimException {
                    if (isC) {
                        return new FireProduct(c, (SimTransition)SimNDRFire.this.trans, c.evalVector(SimNDRFire.this.actuals, false), myname, schedName);
                    }
                    return new FireProduct(c, (SimTransition)SimNDRFire.this.trans, c.evalVector(SimNDRFire.this.actuals, false));
                }
            };
        }
        return new ThrowerExecutable(after){

            public ExecProduct computeProduct(ExecControl c) throws SimException {
                SimTransition t;
                Vector<SimTransition> candidates = new Vector<SimTransition>();
                Vector<Vector> candActuals = new Vector<Vector>();
                Enumeration enum1 = SimNDRFire.this.aut.getActionTable().enumTransitions();
                block0: while (enum1.hasMoreElements()) {
                    t = (SimTransition)((Object)enum1.nextElement());
                    if (t.getAction().getType() == 0 || t.getWherePred() != null) continue;
                    Enumeration e = t.getActionActuals().elements();
                    while (e.hasMoreElements()) {
                        Term actual = (Term)e.nextElement();
                        if (actual instanceof VarRefTerm) continue block0;
                    }
                    Vector realActuals = c.evalVector(t.getActionActuals(), false);
                    if (t.getPrecondition() != null) {
                        c.assignVector(t.getAction().getFormals(), realActuals);
                        boolean precondHolds = c.evalBoolean((Evaluable)t.getPrecondition());
                        c.unassignVector(t.getAction().getFormals());
                        if (!precondHolds) continue;
                    }
                    candidates.addElement(t);
                    candActuals.addElement(realActuals);
                }
                if (candidates.size() == 0) {
                    return null;
                }
                int n = rnd.nextInt(candidates.size());
                t = (SimTransition)((Object)candidates.elementAt(n));
                Vector actuals = (Vector)candActuals.elementAt(n);
                return new FireProduct(c, t, actuals);
            }
        };
    }

    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return ((SimILInstanceFactory)f).instanceNDRFire(this);
    }

    public SimNDRFire(SimNDRFire obj, ILInstanceFactory f) throws ILException {
        super(obj.aut);
    }

    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.trans = (SimTransition)f.makeInstance((ILElement)this.trans);
        this.actuals = f.instanceVector(this.actuals);
        return this;
    }

    public static void setSeed(long seed) {
        rnd = new Random(seed);
    }

    @Override
    public void update(SimPrimitiveAutomaton autPassed) {
        this.aut = autPassed;
        this.trans = autPassed.getTransFromStore(this.trans.getTransitionId());
        Enumeration enumActs = this.actuals.elements();
        while (enumActs.hasMoreElements()) {
            Copyable term = (Copyable)enumActs.nextElement();
            term.update(autPassed);
        }
    }

    @Override
    public Copyable copy() {
        Vector<Term> newActs = null;
        SimTransition newTrans = (SimTransition)this.trans;
        if (this.actuals != null) {
            newActs = new Vector<Term>();
            Enumeration enumActs = this.actuals.elements();
            while (enumActs.hasMoreElements()) {
                Copyable term = (Copyable)enumActs.nextElement();
                newActs.add((Term)term.copy());
            }
        }
        return new SimNDRFire((SimPrimitiveAutomaton)this.aut, newTrans, newActs);
    }
}

