/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.nodes.AutComponent;
import com.veromodo.tioa.il.nodes.CompositeAutomaton;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.ndr.NDRCompositeAutomaton;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Compilable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.ActualCompositeAutomaton;
import com.veromodo.tioa.simulator.nodes.SimApplicationTerm;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimCompositeAutomaton
extends NDRCompositeAutomaton
implements SimAutomaton {
    private static final IOACategory cat = IOACategory.getInstance((String)SimCompositeAutomaton.class.getName());
    protected static final Vector emptyVector = new Vector();
    private Executable ndrProgram_c = null;
    private ExecControl ndrControl = null;
    protected Sort sort;
    static /* synthetic */ Class class$0;

    public SimCompositeAutomaton(String name, Vector<Term> formals, Term where) {
        super(name, formals, where);
    }

    protected SimCompositeAutomaton(CompositeAutomaton obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
    }

    @Override
    public Entity select(ExecControl c, String label) throws SimException {
        Enumeration components = this.enumComposites();
        while (components.hasMoreElements()) {
            AutComponent ac = (AutComponent)components.nextElement();
            SimAutomaton caut = (SimAutomaton)ac.getAutomaton();
            if (!label.equals(caut.getName())) continue;
            return caut;
        }
        throw new SimException("cannot find state variable: " + label);
    }

    @Override
    public void assignSelect(ExecControl c, String label, Entity value) throws SimException {
        try {
            ((SimVariable)this.states.getByName(label).getVariable()).assign(c, value);
        }
        catch (LookupException e) {
            throw new SimException("cannot find state variable: " + label, e);
        }
    }

    public boolean equals(Entity ent) {
        throw new Error();
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setAutomatonSort(Sort sort) {
        this.sort = sort;
    }

    public void assignActuals(ExecControl c) throws SimException {
        Enumeration components = this.enumComposites();
        while (components.hasMoreElements()) {
            AutComponent ac = (AutComponent)components.nextElement();
            SimAutomaton caut = (SimAutomaton)ac.getAutomaton();
            cat.debug((Object)("Printing actuals for :" + caut.getName()));
            cat.debug((Object)ac.getActuals());
            Enumeration enumFormals = caut.getFormals().elements();
            Enumeration enumActuals = ac.getActuals().elements();
            Vector actVec = ac.getActuals();
            Enumeration tEnum = actVec.elements();
            SimVarRefTerm s1 = (SimVarRefTerm)tEnum.nextElement();
            SimApplicationTerm s2 = (SimApplicationTerm)tEnum.nextElement();
            s2.evaluate(c, false);
            int counter = 1;
            while (enumFormals.hasMoreElements()) {
                ++counter;
            }
        }
    }

    public ActualAutInterface newActualAutomaton(Vector actuals) throws SimException {
        Vector<ActualAutInterface> actualAutomata = new Vector<ActualAutInterface>();
        Enumeration components = this.enumComposites();
        while (components.hasMoreElements()) {
            AutComponent ac = (AutComponent)components.nextElement();
            SimAutomaton caut = (SimAutomaton)ac.getAutomaton();
            cat.debug((Object)("setting name to " + ac.compName()));
            caut.setName(ac.compName());
            actualAutomata.add(caut.newActualAutomaton(ac.getActuals(), ac.getWithForms(), ac.getWithActs()));
        }
        return new ActualCompositeAutomaton(this, actuals, actualAutomata);
    }

    @Override
    public ActualAutInterface newActualAutomaton(Vector actuals, Vector withForms, Vector withActs) throws SimException {
        return this.newActualAutomaton(actuals);
    }

    public void parseExtension(SList sexp, ILParser parser) throws ILException, SExpException, IOException {
        cat.debug((Object)("ParseExtension: " + sexp));
        super.parseExtension(sexp, parser);
        if (this.ndrProgram != null) {
            cat.debug((Object)"parseExtension() [compiling ndrProgram]");
            try {
                this.ndrProgram_c = ((Compilable)this.ndrProgram).compile(null);
            }
            catch (SimException e) {
                throw new ILException("SimException caught: ", (Throwable)((Object)e));
            }
        }
    }

    public Executable getSchedulePC() {
        return this.ndrProgram_c;
    }

    public Enumeration enumScheduleStates() {
        return this.ndrStates.enumerate();
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }
}

