/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.nodes.BasicVarRefTerm;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Assignable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.nodes.SimState;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Vector;

public class SimVarRefTerm
extends BasicVarRefTerm
implements Evaluable,
Assignable,
Copyable {
    private static final IOACategory cat = IOACategory.getInstance((String)SimVarRefTerm.class.getName());
    public boolean errorToEval = false;
    static /* synthetic */ Class class$0;

    public SimVarRefTerm(Variable var) {
        super(var);
    }

    public void assign(ExecControl c, Entity value) throws SimException {
        cat.debug((Object)("SimVarRefTerm.assign(...) [" + value + "]"));
        ((SimVariable)this.var).assign(c, value);
    }

    public Entity evaluate(ExecControl c, boolean asLValue) throws SimException {
        cat.debug((Object)("SimVarRefTerm.evaluate; errorToEval=" + this.errorToEval));
        if (this.errorToEval) {
            throw new SimException("encountered non-constant term in unsupported context");
        }
        return ((Evaluable)this.var).evaluate(c, asLValue);
    }

    protected SimVarRefTerm(VarRefTerm obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
    }

    protected SimVarRefTerm(VarRefTerm obj, ILInstanceFactory f, boolean errorToEval) throws ILException {
        super(obj, f);
        this.errorToEval = errorToEval;
        cat.debug((Object)("SimVarRefTerm instanced: " + errorToEval));
    }

    public String toString() {
        return "SimVarRefTerm: " + this.var.toString() + ", sort " + this.getSort();
    }

    public Copyable copy() {
        cat.debug((Object)"Copying SimVarRefTerm");
        SimVarRefTerm toreturn = new SimVarRefTerm((Variable)((SimVariable)this.var).copy());
        if (this.isConstant()) {
            toreturn.setConstant();
        }
        return toreturn;
    }

    public void update(SimPrimitiveAutomaton aut) {
        SimVariable refVar = (SimVariable)this.getRefVariable();
        String refVarId = refVar.getId();
        SimVarRefTerm f2 = aut.getVarFromStore(refVarId);
        if (f2 != null) {
            this.replaceVar((Variable)refVar, f2.getRefVariable());
            return;
        }
        Vector formals = aut.getFormals();
        int i = 0;
        while (i < formals.size()) {
            SimVarRefTerm formal = (SimVarRefTerm)formals.get(i);
            if (formal.getRefVariable().getId().equals(refVarId)) {
                this.replaceVar((Variable)refVar, formal.getRefVariable());
                return;
            }
            ++i;
        }
        try {
            SimState state = (SimState)aut.getStates().get(refVarId);
            Variable myVar = state.getVariable();
            this.replaceVar((Variable)refVar, myVar);
            cat.debug((Object)("Replaced state variable: " + refVarId));
        }
        catch (LookupException e) {
            cat.debug((Object)("Update Failed.   Looking in NDR states for  " + e.target()));
            try {
                if (aut.getNDRStates() != null) {
                    SimState stateNDR = (SimState)aut.getNDRStates().get(refVarId);
                    Variable myVarNDR = stateNDR.getVariable();
                    cat.debug((Object)("NDR Update Successfull for " + refVarId));
                    this.replaceVar((Variable)refVar, myVarNDR);
                } else {
                    cat.debug((Object)"No NDR States Exist - Failed Update");
                }
            }
            catch (LookupException eNDR) {
                cat.debug((Object)("NDR Update Failed Due to Lookup Error on " + eNDR.target()));
            }
        }
    }
}

