/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.BasicTrajectory;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Value;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.ImplRegistry;
import com.veromodo.tioa.simulator.OpImpl;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ErrorMessage;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.nodes.SimApplicationTerm;
import com.veromodo.tioa.simulator.nodes.SimAssignment;
import com.veromodo.tioa.simulator.nodes.SimConditional;
import com.veromodo.tioa.simulator.nodes.SimFuncDecl;
import com.veromodo.tioa.simulator.nodes.SimOperator;
import com.veromodo.tioa.simulator.nodes.SimProgram;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimTrajectory
extends BasicTrajectory {
    protected ImplRegistry reg;
    private static final IOACategory cat = IOACategory.getInstance((String)SimTrajectory.class.getName());
    static /* synthetic */ Class class$0;

    public SimTrajectory(String id, String name, Term invariant, Term stopCondition, Vector<FuncDecl> funcDecls, Vector<Term> evolvePreds) {
        super(id, name, invariant, stopCondition, funcDecls, evolvePreds);
    }

    public SimTrajectory copy() {
        Term newStopCond;
        cat.debug((Object)"Copying Trajectory");
        Term newInvariant = this.invariant;
        if (newInvariant != null) {
            newInvariant = (Term)((Copyable)this.invariant).copy();
        }
        if ((newStopCond = this.stopCondition) != null) {
            newStopCond = (Term)((Copyable)this.stopCondition).copy();
        }
        Vector<FuncDecl> newFuncDecls = null;
        if (this.getFuncDeclarations() != null) {
            newFuncDecls = new Vector<FuncDecl>();
            Enumeration enum1 = this.funcDeclarations.elements();
            while (enum1.hasMoreElements()) {
                FuncDecl func = (FuncDecl)enum1.nextElement();
                SimFuncDecl newFunc = ((SimFuncDecl)func).copy();
                newFuncDecls.add((FuncDecl)newFunc);
            }
        }
        Vector<Term> newEvolvePreds = new Vector<Term>();
        Enumeration enum1 = this.evolvePreds.elements();
        while (enum1.hasMoreElements()) {
            Term evolvePred = (Term)enum1.nextElement();
            Term newEvolvePred = (Term)((Copyable)evolvePred).copy();
            newEvolvePreds.add(newEvolvePred);
        }
        return new SimTrajectory(this.id, this.name, newInvariant, newStopCond, newFuncDecls, newEvolvePreds);
    }

    public Executable getCompiledEvolve(Term duration) throws SimException {
        if (this.evolvePreds == null) {
            return null;
        }
        if (this.evolvePreds.size() == 0) {
            throw new SimException("Missing Evolve Predicate.");
        }
        Vector<Term> evolve_variables = new Vector<Term>();
        SimAssignment[] assignments = new SimAssignment[this.evolvePreds.size()];
        int k = 0;
        while (k < this.evolvePreds.size()) {
            Term t = (Term)this.evolvePreds.get(k);
            ApplicationTerm at = (ApplicationTerm)t;
            cat.debug((Object)("at=" + at));
            Term varTerm = this.getVarTerm(at);
            evolve_variables.add(varTerm);
            cat.debug((Object)("varTerm=" + varTerm));
            Term rate = (Term)at.getOperands().get(1);
            cat.debug((Object)("rate=" + rate));
            SimApplicationTerm newValue = this.getNewValue(rate, duration, varTerm);
            assignments[k] = new SimAssignment(varTerm, (Value)newValue);
            ++k;
        }
        Vector<Copyable> programVector = new Vector<Copyable>();
        if (this.invariant != null) {
            programVector.add(this.getInitialConditional());
        }
        int i = 0;
        while (i < assignments.length) {
            programVector.add(assignments[i]);
            ++i;
        }
        programVector.add(this.getFinalConditional(duration, evolve_variables));
        SimProgram program = new SimProgram(programVector);
        Executable e = program.compile(null);
        return e;
    }

    private Term getVarTerm(ApplicationTerm at) throws SimException {
        boolean simpleVar;
        if (!at.getOperator().getName1().equals("=")) {
            throw new SimException("Malformed Evolve Predicate. '=' operator expected");
        }
        ApplicationTerm lhs = (ApplicationTerm)at.getOperands().get(0);
        if (!lhs.getOperator().getName().equals("d")) {
            throw new SimException("Malformed Evolve Predicate. 'd()' operator expected on the left-hand side");
        }
        VarRefTerm v = null;
        ApplicationTerm v_app = null;
        if (lhs.getOperands().get(0) instanceof ApplicationTerm) {
            simpleVar = false;
            v_app = (ApplicationTerm)lhs.getOperands().get(0);
        } else if (lhs.getOperands().get(0) instanceof VarRefTerm) {
            v = (VarRefTerm)lhs.getOperands().get(0);
            simpleVar = true;
        } else {
            throw new SimException(lhs.getOperands().get(0) + " is unsupported for the evolve pred. \n" + "Currently supported: simple variable reference term and application term");
        }
        if (simpleVar) {
            return v;
        }
        return v_app;
    }

    private SimApplicationTerm getNewValue(Term rate, Term duration, Term var) throws SimException {
        try {
            Vector<Sort> domain1 = new Vector<Sort>();
            domain1.add(rate.getSort());
            domain1.add(duration.getSort());
            Sort range1 = var.getSort();
            SimOperator mul = new SimOperator("op*", 1, "*", "", domain1, range1, false, null);
            this.reg = ImplRegistry.getInstance();
            OpImpl opImpl1 = this.reg.getImpl((Operator)mul);
            mul.setImpl(opImpl1);
            cat.debug((Object)("* operator: " + (Object)((Object)mul)));
            Vector<Term> opands1 = new Vector<Term>();
            cat.debug((Object)("* operator: " + (Object)((Object)mul)));
            opands1.add(rate);
            opands1.add(duration);
            SimApplicationTerm appTerm1 = new SimApplicationTerm((Operator)mul, opands1);
            Vector<Sort> domain2 = new Vector<Sort>();
            Sort v_sort = var.getSort();
            domain2.add(v_sort);
            domain2.add(appTerm1.getSort());
            SimOperator plus = new SimOperator("op+", 1, "+", "", domain2, v_sort, false, null);
            OpImpl opImpl2 = this.reg.getImpl((Operator)plus);
            plus.setImpl(opImpl2);
            Vector<Term> opands2 = new Vector<Term>();
            cat.debug((Object)("+ operator, opands:" + var + appTerm1));
            opands2.add(var);
            opands2.add((Term)appTerm1);
            SimApplicationTerm newValue = new SimApplicationTerm((Operator)plus, opands2);
            return newValue;
        }
        catch (ILException e) {
            throw new SimException(e.getMessage());
        }
    }

    private SimConditional getInitialConditional() throws SimException {
        if (this.invariant == null) {
            return null;
        }
        try {
            Vector<SimApplicationTerm> preds = new Vector<SimApplicationTerm>();
            preds.add(this.computeInvariantFailsTerm(this.invariant));
            Vector<SimProgram> thenPrograms = new Vector<SimProgram>();
            Vector<ErrorMessage> thenStatements = new Vector<ErrorMessage>();
            ErrorMessage error2 = new ErrorMessage("\nAttempted to execute trajectory \"" + this.getTrajectoryName() + "\"" + " but the invariant does not hold at the beginning of the trajectory.");
            thenStatements.add(error2);
            thenPrograms.add(new SimProgram(thenStatements));
            SimConditional conditional = new SimConditional(preds, thenPrograms, null);
            return conditional;
        }
        catch (ILException e) {
            throw new SimException(e.getMessage());
        }
    }

    private SimConditional getFinalConditional(Term duration, Vector<Term> evolve_variables) throws SimException {
        try {
            Vector<SimApplicationTerm> preds = new Vector<SimApplicationTerm>();
            SimApplicationTerm predicate = null;
            SimApplicationTerm stopFails = this.computeStopCondFailsTerm(this.stopCondition, evolve_variables);
            if (this.invariant == null) {
                predicate = stopFails;
            } else {
                SimApplicationTerm invariantFails = this.computeInvariantFailsTerm(this.invariant);
                Vector<Sort> domainOR = new Vector<Sort>();
                domainOR.add(invariantFails.getSort());
                domainOR.add(stopFails.getSort());
                SimOperator operatorOR = new SimOperator("op\\/", 1, "\\/", "", domainOR, stopFails.getSort(), false, null);
                OpImpl opImplOR = this.reg.getImpl((Operator)operatorOR);
                operatorOR.setImpl(opImplOR);
                Vector<Term> opandsOR = new Vector<Term>();
                opandsOR.add((Term)invariantFails);
                opandsOR.add((Term)stopFails);
                predicate = new SimApplicationTerm((Operator)operatorOR, opandsOR);
            }
            preds.add(predicate);
            Vector<SimProgram> thenPrograms = new Vector<SimProgram>();
            Vector<ErrorMessage> thenStatements = new Vector<ErrorMessage>();
            ErrorMessage error2 = new ErrorMessage("\nAttempted to execute trajectory \"" + this.getTrajectoryName() + "\"" + " for " + duration + " units, \nbut at that point the invariant or the stop Conditions would not hold");
            thenStatements.add(error2);
            thenPrograms.add(new SimProgram(thenStatements));
            SimConditional conditional = new SimConditional(preds, thenPrograms, null);
            return conditional;
        }
        catch (ILException e) {
            throw new SimException(e.getMessage());
        }
    }

    private SimApplicationTerm computeInvariantFailsTerm(Term inv) throws ILException {
        Vector<Sort> dom = new Vector<Sort>();
        dom.add(inv.getSort());
        SimOperator op = new SimOperator("op~", 2, "~", "", dom, inv.getSort(), false, null);
        OpImpl opImpl = this.reg.getImpl((Operator)op);
        op.setImpl(opImpl);
        Vector<Term> opands = new Vector<Term>();
        opands.add(inv);
        return new SimApplicationTerm((Operator)op, opands);
    }

    private SimApplicationTerm computeStopCondFailsTerm(Term stopCond2, Vector<Term> evolve_variables) throws SimException, ILException {
        if (!(stopCond2 instanceof ApplicationTerm)) {
            throw new SimException("Stop Condition " + stopCond2 + " is not an Application Term");
        }
        SimApplicationTerm stopAppTerm = (SimApplicationTerm)stopCond2;
        Operator current = stopAppTerm.getOperator();
        if (current.getName().equals("true")) {
            SimOperator op = new SimOperator("op_false", 0, "false", "", new Vector(), stopAppTerm.getSort(), false, null);
            OpImpl opImpl = this.reg.getImpl((Operator)op);
            op.setImpl(opImpl);
            return new SimApplicationTerm((Operator)op, new Vector<Term>());
        }
        return this.convert(stopAppTerm, evolve_variables);
    }

    private SimApplicationTerm convert(SimApplicationTerm t, Vector<Term> evolve_variables) throws ILException {
        Operator op = t.getOperator();
        if (op.getName1().equals("=") && this.contains(evolve_variables, (Term)t.getOperands().get(0)) && this.contains(evolve_variables, (Term)t.getOperands().get(1))) {
            throw new SimException("Cannot simulate trajectory with stopping condition \nof the form v1 = v2 with both v1 and v2 are modified by an evolve predicate");
        }
        if (op.getName1().equals("=") && this.contains(evolve_variables, (Term)t.getOperands().get(0))) {
            SimOperator newOp = new SimOperator("op>", 1, ">", "", op.getDomain(), op.getRange(), false, null);
            newOp.setImpl(this.reg.getImpl((Operator)newOp));
            return new SimApplicationTerm((Operator)newOp, t.getOperands());
        }
        if (op.getName1().equals("=") && this.contains(evolve_variables, (Term)t.getOperands().get(1))) {
            SimOperator newOp = new SimOperator("op<", 1, "<", "", op.getDomain(), op.getRange(), false, null);
            newOp.setImpl(this.reg.getImpl((Operator)newOp));
            return new SimApplicationTerm((Operator)newOp, t.getOperands());
        }
        Vector<Term> newOpands = new Vector<Term>();
        int i = 0;
        while (i < t.getOperands().size()) {
            Object t_i = t.getOperands().get(i) instanceof SimApplicationTerm ? this.convert((SimApplicationTerm)t.getOperands().get(i), evolve_variables) : (Term)t.getOperands().get(i);
            newOpands.add((Term)t_i);
            ++i;
        }
        return new SimApplicationTerm(op, newOpands);
    }

    private boolean contains(Vector<Term> v, Term t) throws SimException {
        int i = 0;
        while (i < v.size()) {
            Term v_t = v.get(i);
            if (v_t instanceof VarRefTerm) {
                if (t instanceof VarRefTerm && this.similar((VarRefTerm)v_t, (VarRefTerm)t)) {
                    return true;
                }
            } else if (v_t instanceof ApplicationTerm) {
                if (t instanceof ApplicationTerm && this.similar((ApplicationTerm)v_t, (ApplicationTerm)t)) {
                    return true;
                }
            } else {
                throw new SimException("unsupported type of term in evolve predicate");
            }
            ++i;
        }
        return false;
    }

    private boolean similar(VarRefTerm t1, VarRefTerm t2) {
        return t1.getRefVariable().getId().equals(t2.getRefVariable().getId());
    }

    private boolean similar(ApplicationTerm t1, ApplicationTerm t2) throws SimException {
        boolean similar = false;
        if (t1.getOperator().getId().equals(t2.getOperator().getId()) && t1.getOperands().size() == t2.getOperands().size()) {
            int i = 0;
            while (i < t1.getOperands().size()) {
                if (t1.getOperands().get(i) instanceof ApplicationTerm) {
                    if (t2.getOperands().get(i) instanceof ApplicationTerm) {
                        similar = this.similar((ApplicationTerm)t1.getOperands().get(i), (ApplicationTerm)t2.getOperands().get(i));
                    }
                } else if (t1.getOperands().get(i) instanceof VarRefTerm) {
                    if (t2.getOperands().get(i) instanceof VarRefTerm) {
                        similar = this.similar((VarRefTerm)t1.getOperands().get(i), (VarRefTerm)t2.getOperands().get(i));
                    }
                } else {
                    throw new SimException("Unsupported type: " + ((Term)t1.getOperands().get(i)).getClass());
                }
                ++i;
            }
        }
        return similar;
    }
}

