/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.BasicProgram;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.Statement;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Compilable;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;
import java.util.Vector;

public class SimProgram
extends BasicProgram
implements Compilable {
    private static final IOACategory cat = IOACategory.getInstance((String)SimProgram.class.getName());
    Executable compiled = null;
    Executable after = null;
    static /* synthetic */ Class class$0;

    public SimProgram(Vector statements) {
        super(statements);
    }

    public final Executable compile(Executable after) throws SimException {
        this.ensureCompiled(after);
        return this.compiled;
    }

    protected void ensureCompiled(Executable after) throws SimException {
        if (this.compiled != null) {
            return;
        }
        int n = this.statements.size();
        Executable[] c_statements = new Executable[n + 1];
        c_statements[n] = after;
        int i = n - 1;
        while (i >= 0) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("Trying to compile " + ((Statement)this.statements.get(i)).getClass().getName()));
                cat.debug(this.statements.get(i));
            }
            c_statements[i] = ((Compilable)this.statements.elementAt(i)).compile(c_statements[i + 1]);
            --i;
        }
        this.compiled = c_statements[0];
    }

    protected SimProgram(Program obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
    }

    public SimProgram copy() {
        cat.debug((Object)"Copying Program");
        Vector<Copyable> copiedSt = new Vector<Copyable>();
        Enumeration enumst = this.getStatements().elements();
        while (enumst.hasMoreElements()) {
            Statement st = (Statement)enumst.nextElement();
            copiedSt.add(((Copyable)st).copy());
        }
        return new SimProgram(copiedSt);
    }

    public final Executable compile(Executable after, SimPrimitiveAutomaton aut) throws SimException {
        this.ensureCompiled(after, aut);
        return this.compiled;
    }

    protected void ensureCompiled(Executable after, SimPrimitiveAutomaton aut) throws SimException {
        int n = this.statements.size();
        Executable[] c_statements = new Executable[n + 1];
        c_statements[n] = after;
        int i = n - 1;
        while (i >= 0) {
            if (cat.isDebugEnabled()) {
                cat.debug(this.statements.get(i));
            }
            ((Copyable)this.statements.get(i)).update(aut);
            c_statements[i] = ((Compilable)this.statements.elementAt(i)).compile(c_statements[i + 1]);
            --i;
        }
        this.compiled = c_statements[0];
    }
}

