/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.BasicOperator;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.ImplRegistry;
import com.veromodo.tioa.simulator.OpImpl;
import com.veromodo.tioa.simulator.SelectableEntity;
import com.veromodo.tioa.simulator.exceptions.BadAssignException;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Assignable;
import com.veromodo.tioa.simulator.exec.AssignableOpImpl;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimOperator
extends BasicOperator {
    protected static final int OPIMPL_NORMAL = 0;
    protected static final int OPIMPL_SPECIAL_SELECT = 1;
    protected static final int OPIMPL_SPECIAL_CONSTANT = 2;
    private static final IOACategory cat = IOACategory.getInstance((String)SimOperator.class.getName());
    private static final IOACategory catApply = IOACategory.getInstance((String)(String.valueOf(SimOperator.class.getName()) + ".apply"));
    protected OpImpl impl;
    protected int implType = 0;
    protected Entity constant = null;
    static /* synthetic */ Class class$0;

    public SimOperator(String id, int type, String name, String name2, Vector domain, Sort range, boolean isTypeConst, Vector<Integer> scope) throws ILException {
        super(id, type, name, name2, domain, range, isTypeConst, scope);
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("Constructing " + id + " of type " + type));
        }
    }

    public void initialize() throws ILException {
        this.getImplFromReg();
    }

    public OpImpl getImpl() {
        return this.impl;
    }

    protected void getImplFromReg() throws ILException {
        if (cat.isDebugEnabled()) {
            cat.debug((Object)(String.valueOf(this.id) + " (" + this.getName() + ") is requesting an implementation"));
        }
        if (this.impl != null) {
            return;
        }
        this.impl = ImplRegistry.getInstance().getImpl((Operator)this);
        if (this.impl != null) {
            this.implType = 0;
        }
        if (this.type == 5) {
            this.implType = 1;
        } else if (this.getDomain().isEmpty() && this.getRange().isAutomatonSort()) {
            this.implType = 2;
            this.constant = (Entity)this.spec.getAutomaton(this.name);
        } else {
            this.implType = 0;
        }
    }

    public void setImpl(OpImpl impl) {
        this.impl = impl;
        this.implType = 0;
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("set impl for " + this.id + " to " + impl));
        }
    }

    public Entity apply(ExecControl c, Vector opands) throws SimException {
        if (catApply.isDebugEnabled()) {
            catApply.debug((Object)(String.valueOf(this.id) + " about to apply " + (Object)((Object)this)));
        }
        switch (this.implType) {
            case 0: {
                this.checkValidImpl();
                if (cat.isDebugEnabled()) {
                    cat.debug((Object)("Impl: " + this.impl.toString()));
                }
                Entity e = this.impl.apply(opands);
                if (catApply.isDebugEnabled()) {
                    catApply.debug((Object)("Result: " + e));
                }
                return e;
            }
            case 2: {
                return this.constant;
            }
            case 1: {
                if (opands.firstElement() instanceof SelectableEntity) {
                    SelectableEntity ent = (SelectableEntity)opands.firstElement();
                    if (ent == null) {
                        throw new SimException("cannot select `" + this.name1 + "' from null item");
                    }
                    return ent.select(c, this.name1);
                }
                this.checkValidImpl();
                return this.impl.apply(opands);
            }
        }
        throw new Error();
    }

    public void assign(ExecControl c, Assignable lhs, Vector opands, Entity value) throws SimException {
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("about to assign with ExecControl " + c + ", value " + value));
        }
        switch (this.implType) {
            case 0: {
                this.checkValidImpl();
                if (cat.isDebugEnabled()) {
                    cat.debug((Object)("using impl " + this.impl.toString()));
                    cat.debug((Object)("my key is: " + this.getKey()));
                    cat.debug((Object)("and I am: " + (Object)((Object)this) + " " + this.getId()));
                }
                ((AssignableOpImpl)this.impl).assign(c, lhs, opands, value);
                return;
            }
            case 2: {
                throw new BadAssignException(this, opands, value);
            }
            case 1: {
                if (this.impl != null) {
                    ((AssignableOpImpl)this.impl).assign(c, lhs, opands, value);
                } else {
                    ((SelectableEntity)opands.firstElement()).assignSelect(c, this.name1, value);
                }
                return;
            }
        }
        throw new Error();
    }

    private final void checkValidImpl() throws SimException {
        if (this.impl == null) {
            throw new SimException("Attempted to execute operator with no implementation: " + this.getKey());
        }
    }

    protected SimOperator(Operator obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
        this.getImplFromReg();
    }
}

