/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.nodes.BasicLoop;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.runtime.adt.SetSort;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Compilable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.exec.WrapperExecutable;
import com.veromodo.tioa.simulator.nodes.SimProgram;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;

public class SimLoop
extends BasicLoop
implements Executable,
Compilable,
Copyable {
    private static final IOACategory debug = IOACategory.getInstance((String)SimLoop.class.getName());
    static /* synthetic */ Class class$0;

    public SimLoop(Variable var, Term cond, Program prog) {
        super(var, cond, prog);
    }

    public Executable compile(Executable after) {
        return new WrapperExecutable(this, after);
    }

    public void execute(ExecControl c) throws SimException, ExecProduct {
        debug.debug((Object)("For: Executing condition " + this.cond.getClass().getName()));
        if (!this.cond.getSort().getName().equalsIgnoreCase("Set")) {
            throw new SimException("Cannot simulate predicate-specified loops");
        }
        Evaluable evalTerm = (Evaluable)this.cond;
        SimVariable simVar = (SimVariable)this.var;
        SimProgram simProg = (SimProgram)this.prog;
        Entity conditionResult = evalTerm.evaluate(c, false);
        debug.debug((Object)("  Result: " + conditionResult));
        debug.debug((Object)("  Var name: " + simVar.getName()));
        Assert.assertTrue(conditionResult instanceof SetSort);
        SetSort theSet = (SetSort)conditionResult;
        for (Entity ent : theSet.getSet()) {
            debug.debug((Object)("  Assigning " + ent));
            simVar.assign(c, ent);
            if (debug.isDebugEnabled()) {
                debug.debug((Object)"  Executing");
                debug.debug((Object)simProg.getStatements());
            }
            c.pc = simProg.compile(null);
            c.execute();
        }
    }

    public Copyable copy() {
        SimVariable newVar = ((SimVariable)this.getVariable()).copy();
        SimProgram newProg = ((SimProgram)this.getBody()).copy();
        Term newCondition = (Term)((Copyable)this.getCondition()).copy();
        return new SimLoop((Variable)newVar, newCondition, (Program)newProg);
    }

    public void update(SimPrimitiveAutomaton aut) {
        SimVarRefTerm newVarRefTerm = new SimVarRefTerm(this.getVariable());
        aut.putVarInStore(this.getVariable().getId(), newVarRefTerm);
        Copyable cond = (Copyable)this.getCondition();
        cond.update(aut);
        Enumeration enumStatBody = this.getBody().getStatements().elements();
        while (enumStatBody.hasMoreElements()) {
            Copyable stBody = (Copyable)enumStatBody.nextElement();
            stBody.update(aut);
        }
    }
}

