/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.BasicApplicationTerm;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.simulator.Copyable;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Assignable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.impl.ShortcutOpImpl;
import com.veromodo.tioa.simulator.nodes.SimOperator;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimApplicationTerm
extends BasicApplicationTerm
implements Evaluable,
Assignable,
Copyable {
    private static final IOACategory debug = IOACategory.getInstance((String)SimApplicationTerm.class.getName());
    private static final IOACategory debugApply = IOACategory.getInstance((String)(String.valueOf(SimApplicationTerm.class.getName()) + ".apply"));
    static /* synthetic */ Class class$0;

    public SimApplicationTerm(Operator optor, Vector<Term> opands) {
        super(optor, opands);
    }

    @Override
    public Entity evaluate(ExecControl c, boolean asLValue) throws SimException {
        if (debugApply.isDebugEnabled()) {
            debugApply.debug((Object)(this + " applies " + this.optor.toSValue().toString()));
            debugApply.debug((Object)(" on " + this.opands + " numbering " + this.opands.size()));
        }
        if (((SimOperator)this.optor).getImpl() instanceof ShortcutOpImpl) {
            String style = ((ShortcutOpImpl)((SimOperator)this.optor).getImpl()).getStyle();
            if (style.equals("if")) {
                debug.debug((Object)"applying shortcut if");
                Evaluable evaluable = (Evaluable)this.opands.get(0);
                Entity result = evaluable.evaluate(c, asLValue);
                if (result.equals(BoolSort.lit(true))) {
                    debug.debug((Object)"evaluating then clause");
                    evaluable = (Evaluable)this.opands.get(1);
                } else {
                    debug.debug((Object)"evaluating else clause");
                    evaluable = (Evaluable)this.opands.get(2);
                }
                return evaluable.evaluate(c, asLValue);
            }
            if (style.equals("and")) {
                debug.debug((Object)"applying shortcut and");
                Evaluable evaluable = (Evaluable)this.opands.get(0);
                Entity result = evaluable.evaluate(c, asLValue);
                if (result.equals(BoolSort.lit(false))) {
                    return result;
                }
                evaluable = (Evaluable)this.opands.get(1);
                return evaluable.evaluate(c, asLValue);
            }
            if (style.equals("or")) {
                debug.debug((Object)"applying shortcut or");
                Evaluable evaluable = (Evaluable)this.opands.get(0);
                Entity result = evaluable.evaluate(c, asLValue);
                if (result.equals(BoolSort.lit(true))) {
                    return result;
                }
                evaluable = (Evaluable)this.opands.get(1);
                return evaluable.evaluate(c, asLValue);
            }
            if (style.equals("implies")) {
                debug.debug((Object)"applying shortcut implication");
                Evaluable evaluable = (Evaluable)this.opands.get(0);
                Entity result = evaluable.evaluate(c, asLValue);
                if (result.equals(BoolSort.lit(false))) {
                    return BoolSort.lit(true);
                }
                evaluable = (Evaluable)this.opands.get(1);
                return evaluable.evaluate(c, asLValue);
            }
            debug.warn((Object)("Unrecognized shortcut type " + style));
        }
        Entity retval = ((SimOperator)this.optor).apply(c, c.evalVector(this.opands, asLValue));
        if (debugApply.isDebugEnabled()) {
            debugApply.debug((Object)("Returned value " + retval));
        }
        return retval;
    }

    @Override
    public void assign(ExecControl c, Entity value) throws SimException {
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("Assigning " + this.optor.getId() + this.opands));
        }
        ((SimOperator)this.optor).assign(c, (Assignable)this.opands.firstElement(), c.evalVector(this.opands, true), value);
    }

    protected SimApplicationTerm(ApplicationTerm obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
    }

    @Override
    public Copyable copy() {
        debug.debug((Object)("Copying Application Term : " + this + " constant? " + this.isConstant()));
        Vector<Term> o = new Vector<Term>();
        Enumeration e = this.opands.elements();
        while (e.hasMoreElements()) {
            Copyable t = (Copyable)e.nextElement();
            o.addElement((Term)t.copy());
        }
        SimApplicationTerm toreturn = new SimApplicationTerm(this.optor, o);
        if (this.isConstant()) {
            toreturn.setConstant();
        }
        return toreturn;
    }

    @Override
    public void update(SimPrimitiveAutomaton aut) {
        Enumeration enumOpands = this.opands.elements();
        while (enumOpands.hasMoreElements()) {
            Copyable nextTerm = (Copyable)enumOpands.nextElement();
            nextTerm.update(aut);
        }
    }
}

