/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.nodes.ProofTrajEntry;
import com.veromodo.tioa.il.nodes.ProofTransEntry;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.exec.PairedActualTransition;
import com.veromodo.tioa.simulator.exec.PairedExecTrajectory;
import com.veromodo.tioa.simulator.exec.PairedFireProduct;
import com.veromodo.tioa.simulator.exec.PairedFollowProduct;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.SimProgram;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.simulator.nodes.ndr.SimSimulationRelation;
import com.veromodo.tioa.simulator.ui.SimRelFailedEvent;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairedImplAutomaton
extends ActualAutomaton {
    private static final IOACategory debug = IOACategory.getInstance((String)PairedImplAutomaton.class.getName());
    public ActualAutInterface implAut;
    protected ActualAutInterface specAut;
    protected SimSimulationRelation srel;
    static /* synthetic */ Class class$0;

    public PairedImplAutomaton(ActualAutomaton implAut, ActualAutomaton specAut, SimSimulationRelation srel) throws SimException {
        super(implAut.aut, implAut.actuals);
        this.implAut = implAut;
        this.specAut = specAut;
        this.srel = srel;
    }

    public PairedImplAutomaton(SimPrimitiveAutomaton implAut, Vector implActuals, SimPrimitiveAutomaton specAut, Vector specActuals, SimSimulationRelation srel) throws SimException {
        this((ActualAutomaton)implAut.newActualAutomaton(implActuals), (ActualAutomaton)specAut.newActualAutomaton(specActuals), srel);
    }

    @Override
    public void initialize(ExecControl c, boolean initState) throws SimException {
        this.specAut.initialize(c, true);
        this.implAut.initialize(c, initState);
        this.srel.initialize(c);
        this.srel.check(c);
    }

    @Override
    public Step nextStep(ExecControl c) throws SimException {
        return this.implAut.nextStep(c);
    }

    public List<PairedActualTransition> preDriveSpecTrans(ExecControl c, ActualTransition implTrans) throws SimException {
        boolean lowLevelWasExternal;
        debug.debug((Object)"preDriveSpecTrans:");
        ProofTransEntry entry = this.srel.getMatchingProofTransEntry(implTrans);
        if (entry == null) {
            throw new SimException("No matching spec transition for " + this.aut.getName() + "." + implTrans.getTransition().getAction().getName());
        }
        LinkedList<PairedActualTransition> result = new LinkedList<PairedActualTransition>();
        boolean bl = lowLevelWasExternal = implTrans.getActionType() != 2;
        if (entry.getProg() != null) {
            Executable savedPc = c.pc;
            c.pc = ((SimProgram)entry.getProg()).compile(null);
            c.assignVector(entry.getFormals(), implTrans.getActuals());
            while (c.pc != null) {
                try {
                    c.execute();
                }
                catch (PairedFireProduct f) {
                    result.add(f.getPairedActualTrans());
                }
                catch (ExecProduct e) {
                    e.printStackTrace();
                    throw new SimException("unexpected product type in paired simulation:\n", e);
                }
            }
            c.pc = savedPc;
        } else if (lowLevelWasExternal && implTrans.getActionType() != 2) {
            String msg = "no transition of " + this.specAut.getName() + " found for " + implTrans + ".";
            c.registerEvent(new SimRelFailedEvent(this.srel, msg));
        }
        return result;
    }

    public void doDriveSpecTrans(ExecControl c, ActualTransition implTrans, List<PairedActualTransition> program) throws SimException {
        Executable savedPc = c.pc;
        boolean lowLevelWasExternal = implTrans.getActionType() != 2;
        boolean seenExternal = false;
        String msg = null;
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("doDriveSpec for: " + implTrans));
        }
        for (PairedActualTransition specTrans : program) {
            if (debug.isDebugEnabled()) {
                debug.debug((Object)("  induced spec transition: " + specTrans));
            }
            if (specTrans.getActionType() != 2) {
                if (seenExternal) {
                    msg = "more than one external transition of spec automaton executed for only one transition of impl automaton.";
                    debug.debug((Object)"More than one external seen");
                    c.registerEvent(new SimRelFailedEvent(this.srel, msg, implTrans, specTrans));
                }
                seenExternal = true;
                if (lowLevelWasExternal) {
                    if (!specTrans.sameTransition(implTrans)) {
                        msg = "spec " + specTrans + " does not match impl " + implTrans;
                        c.registerEvent(new SimRelFailedEvent(this.srel, msg, implTrans, specTrans));
                    }
                } else {
                    msg = "spec " + specTrans + " is external; impl " + implTrans + " was not.";
                    c.registerEvent(new SimRelFailedEvent(this.srel, msg, implTrans, specTrans));
                }
            }
            try {
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("  about to execute transition: " + specTrans));
                }
                specTrans.assignChoiceSubsts(c);
                c.pc = specTrans;
                c.execute();
            }
            catch (ExecProduct e) {
                e.printStackTrace();
                throw new SimException("unexpected product type in paired simulation:\n", e);
            }
        }
        if (lowLevelWasExternal && !seenExternal) {
            msg = "no external transition of spec automaton executed for " + implTrans + ".";
            c.registerEvent(new SimRelFailedEvent(this.srel, msg));
        }
        c.pc = savedPc;
        this.srel.check(c);
    }

    public List preDriveSpecTraj(ExecControl c, ExecTrajectory implTraj) throws SimException {
        debug.debug((Object)"preDriveSpecTraj:");
        ProofTrajEntry entry = this.srel.getMatchingProofTrajEntry(implTraj);
        if (entry == null) {
            throw new SimException("No matching spec trajectory for " + this.aut.getName() + "." + implTraj.getTrajectory().getTrajectoryName());
        }
        LinkedList<Step> result = new LinkedList<Step>();
        if (entry.getProg() != null) {
            Executable savedPc = c.pc;
            c.pc = ((SimProgram)entry.getProg()).compile(null);
            while (c.pc != null) {
                try {
                    c.execute();
                }
                catch (PairedFireProduct f) {
                    result.add(f.actualTrans);
                }
                catch (PairedFollowProduct f) {
                    result.add(f.exectraj);
                }
                catch (ExecProduct e) {
                    throw new SimException("unexpected product type in paired simulation:" + e.getClass());
                }
            }
            c.pc = savedPc;
        }
        return result;
    }

    public void doDriveSpecTraj(ExecControl c, ExecTrajectory implTraj, List program) throws SimException {
        Executable savedPc = c.pc;
        String msg = null;
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("doDriveSpecTraj for: " + implTraj));
        }
        for (Object nextStep : program) {
            if (nextStep instanceof PairedActualTransition) {
                PairedActualTransition specTrans = (PairedActualTransition)nextStep;
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("  induced spec transition: " + specTrans));
                }
                if (specTrans.getActionType() != 2) {
                    msg = "External transition of spec automaton executed for trajectory of impl automaton.";
                    debug.debug((Object)"External transition in trajectory");
                    c.registerEvent(new SimRelFailedEvent(this.srel, msg, implTraj, specTrans));
                }
                try {
                    if (debug.isDebugEnabled()) {
                        debug.debug((Object)("  about to execute transition: " + specTrans));
                    }
                    c.pc = specTrans;
                    c.execute();
                    continue;
                }
                catch (ExecProduct e) {
                    e.printStackTrace();
                    throw new SimException("unexpected product type in paired simulation:\n", e);
                }
            }
            if (nextStep instanceof PairedExecTrajectory) {
                PairedExecTrajectory specTraj = (PairedExecTrajectory)nextStep;
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("  induced spec trajectory: " + specTraj));
                }
                try {
                    if (debug.isDebugEnabled()) {
                        debug.debug((Object)("  about to execute trajectory: " + specTraj));
                    }
                    Entity duration_val = implTraj.getDurationEntity();
                    specTraj.assignDurationVar(c, duration_val);
                    c.pc = specTraj;
                    c.execute();
                    continue;
                }
                catch (ExecProduct e) {
                    e.printStackTrace();
                    throw new SimException("unexpected product type in paired simulation:\n", e);
                }
            }
            throw new SimException("unexpected step type in paired simulation:" + nextStep.getClass().toString());
        }
        c.pc = savedPc;
        this.srel.check(c);
    }
}

