/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.runtime.adt.AugmentedRealSort;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.FireProduct;
import com.veromodo.tioa.simulator.exec.FollowProduct;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.exec.StepsExceededProduct;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDRActualAutomaton
extends ActualAutomaton {
    private static final IOACategory cat = IOACategory.getInstance((String)NDRActualAutomaton.class.getName());
    protected ExecControl scheduleControl = null;
    protected boolean infinite_trajectory = false;
    static /* synthetic */ Class class$0;

    public NDRActualAutomaton(SimPrimitiveAutomaton aut, Vector<Evaluable> actuals) throws SimException {
        super(aut, actuals);
    }

    @Override
    public void initialize(ExecControl c, boolean initState) throws SimException {
        super.initialize(c, initState);
        if (initState) {
            cat.debug((Object)"setting initial values for schedule states");
            ActualAutomaton.initializeStates(c, this.aut.enumScheduleStates());
        }
    }

    @Override
    public final Step nextStep(ExecControl c) throws SimException {
        if (this.scheduleControl == null) {
            cat.debug((Object)"Creating new scheduleControl");
            this.scheduleControl = c.newControl(this.aut.getSchedulePC(), this);
        }
        try {
            int maxsteps = Simulator.MAX_NDR_STEPS;
            this.scheduleControl.execute(maxsteps);
        }
        catch (FollowProduct fp) {
            cat.debug((Object)"Follow Product");
            if (this.infinite_trajectory) {
                return this.abort();
            }
            ExecTrajectory execTraj = fp.exectraj;
            if (execTraj.getDuration() == AugmentedRealSort.POS_INFTY) {
                this.infinite_trajectory = true;
            }
            execTraj.setDuration(execTraj.getDuration());
            return execTraj;
        }
        catch (FireProduct f) {
            cat.debug((Object)"Fire Product");
            if (this.infinite_trajectory) {
                return this.abort();
            }
            ActualTransition actualTrans = f.actualTrans;
            return actualTrans;
        }
        catch (StepsExceededProduct sep) {
            cat.debug((Object)"StepsExceededProduct Product");
            return null;
        }
        catch (ExecProduct e) {
            throw new InternalError("unexpected product type in NDR evaluation");
        }
        cat.debug((Object)"Returning null for actual transition");
        this.scheduleControl = null;
        this.canSimulate = false;
        return null;
    }

    protected Step abort() {
        System.err.println("Warning: Steps scheduled after an infinite duration trajectory in automaton " + this.getName() + " were not executed");
        this.scheduleControl = null;
        this.canSimulate = false;
        return null;
    }
}

