/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.State;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.runtime.adt.AugmentedRealSort;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.FireProduct;
import com.veromodo.tioa.simulator.exec.FollowProduct;
import com.veromodo.tioa.simulator.exec.NOPstep;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimLiteralTerm;
import com.veromodo.tioa.simulator.nodes.SimSort;
import com.veromodo.tioa.simulator.nodes.SimTrajectory;
import com.veromodo.tioa.simulator.nodes.SimTransition;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.nodes.ndr.SimCompositeAutomaton;
import com.veromodo.tioa.simulator.ui.WhereFailedEvent;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActualCompositeAutomaton
extends BasicILElement
implements ActualAutInterface {
    public static final int RANDOM_SELECT = 1;
    public static final int UNIFORM_SELECT = 2;
    public static final int WEIGHT_SELECT = 3;
    private static int[] weights;
    private static int totalWeights;
    private static Hashtable weightsHash;
    private static final IOACategory cat;
    protected static final Vector emptyVector;
    protected ExecControl scheduleControl = null;
    protected SimCompositeAutomaton aut;
    protected Vector<Evaluable> actuals;
    protected Vector<PrimitiveAutomaton> primitiveAutomata;
    protected boolean canSimulate = true;
    public static int componentSelectionPolicy;
    protected int nextComponent = 0;
    private int numberSimulatable = 0;
    private Hashtable<String, ActualAutomaton> compNameToAut = new Hashtable();
    private boolean compMapInitialized = false;
    private HashSet<ActualAutomaton> trajectory_waiting = new HashSet();
    private HashMap<ActualAutomaton, Double> duration = new HashMap();
    private HashMap<ActualAutomaton, ExecTrajectory> traj_to_follow = new HashMap();
    protected Vector<ActualAutomaton> infinite_trajectory = new Vector();
    private boolean should_follow_trajectories = false;
    private double dur;
    private Vector<ExecTrajectory> trajs_to_follow = new Vector();
    static /* synthetic */ Class class$0;

    static {
        cat = IOACategory.getInstance((String)ActualCompositeAutomaton.class.getName());
        emptyVector = new Vector();
        componentSelectionPolicy = 2;
    }

    public ActualCompositeAutomaton(SimCompositeAutomaton aut, Vector actuals) throws SimException {
        this(aut, actuals, emptyVector);
    }

    @Override
    public boolean isSimulatable() {
        return this.canSimulate;
    }

    @Override
    public void setNotSimulatable() {
        this.canSimulate = false;
    }

    public ActualCompositeAutomaton(SimCompositeAutomaton aut, Vector<Evaluable> actuals, Vector components) throws SimException {
        this.aut = aut;
        this.actuals = actuals;
        this.primitiveAutomata = components;
        this.numberSimulatable = this.primitiveAutomata.size();
    }

    @Override
    public final void initialize(ExecControl c) throws SimException {
        this.initialize(c, true);
    }

    @Override
    public void initialize(ExecControl c, boolean initState) throws SimException {
        Vector formals = this.aut.getFormals();
        int n = this.actuals.size();
        int i = 0;
        while (i < n) {
            cat.debug((Object)("class : " + ((Term)formals.elementAt(i)).getClass()));
            SimVarRefTerm simVar = (SimVarRefTerm)formals.elementAt(i);
            Evaluable actLit = this.actuals.elementAt(i);
            Entity act = actLit.evaluate(c, false);
            cat.debug((Object)("sim var : " + simVar));
            cat.debug((Object)("act : " + act));
            simVar.assign(c, act);
            cat.debug((Object)("sim var : " + simVar));
            ++i;
        }
        Evaluable where = (Evaluable)this.aut.getWhere();
        if (!c.evalBoolean(where)) {
            c.registerEvent(new WhereFailedEvent(this.aut));
        }
        Enumeration<PrimitiveAutomaton> e = this.primitiveAutomata.elements();
        while (e.hasMoreElements()) {
            ((ActualAutInterface)e.nextElement()).initialize(c, initState);
        }
        if (this.aut.getNDRStates() != null) {
            ActualCompositeAutomaton.initializeStates(c, this.aut.enumScheduleStates());
        }
        e = this.primitiveAutomata.elements();
        while (e.hasMoreElements()) {
            ActualAutomaton a = (ActualAutomaton)e.nextElement();
            this.duration.put(a, new Double(0.0));
        }
    }

    protected static void initializeStates(ExecControl c, Enumeration e) throws SimException {
        while (e.hasMoreElements()) {
            State state = (State)e.nextElement();
            Evaluable val = (Evaluable)state.getInitialValue();
            SimVariable var = (SimVariable)state.getVariable();
            var.assign(c, val != null ? val.evaluate(c, false) : ((SimSort)var.getSort()).newEntity());
        }
    }

    @Override
    public Step nextStep(ExecControl c) throws SimException {
        if (this.aut.getNDRStates() == null) {
            return this.nextStep_components(c);
        }
        if (this.scheduleControl == null) {
            cat.debug((Object)"Creating new scheduleControl");
            this.scheduleControl = c.newControl(this.aut.getSchedulePC());
        }
        try {
            this.scheduleControl.execute();
        }
        catch (FireProduct f) {
            cat.debug((Object)"Fire Product");
            if (this.infinite_trajectory.contains(f.actualTrans.getAutomaton())) {
                return this.abort();
            }
            return f.actualTrans;
        }
        catch (FollowProduct f) {
            cat.debug((Object)"Follow Product");
            ExecTrajectory execTraj = f.exectraj;
            if (this.infinite_trajectory.contains(execTraj.getAutomaton())) {
                return this.abort();
            }
            if (execTraj.getDuration() == AugmentedRealSort.POS_INFTY) {
                this.infinite_trajectory.add(execTraj.getAutomaton());
            }
            return execTraj;
        }
        catch (ExecProduct e) {
            throw new InternalError("unexpected product type in NDR evaluation");
        }
        cat.debug((Object)"Returning null for actual transition");
        this.scheduleControl = null;
        this.canSimulate = false;
        return null;
    }

    protected Step abort() {
        System.err.println("Warning: Steps scheduled after an infinite duration trajectory in automaton " + this.getName() + " were not executed");
        this.scheduleControl = null;
        this.canSimulate = false;
        return null;
    }

    private Step nextStep_components(ExecControl c) throws SimException {
        if (this.should_follow_trajectories) {
            return this.next_trajectory();
        }
        ActualAutInterface a = this.nextComponent(c);
        Step next = this.nextStep_from_component(a, c);
        if (next == null && this.should_follow_trajectories) {
            cat.debug((Object)("Following all trajectories for " + this.dur));
            return this.next_trajectory();
        }
        return next;
    }

    private ExecTrajectory next_trajectory() {
        if (!this.trajs_to_follow.isEmpty()) {
            ExecTrajectory traj = this.trajs_to_follow.lastElement();
            ExecTrajectory copy = new ExecTrajectory(traj.getAutomaton(), (SimTrajectory)traj.getTrajectory(), (Term)new SimLiteralTerm(traj.getDurationSort(), this.dur));
            if (this.trajs_to_follow.size() == this.primitiveAutomata.size()) {
                copy.setOrder(1);
            } else {
                copy.setOrder(2);
            }
            this.trajs_to_follow.remove(traj);
            double new_duration = this.duration.get(copy.getAutomaton()) - this.dur;
            this.duration.put(copy.getAutomaton(), new_duration);
            if (new_duration == 0.0) {
                cat.debug((Object)(String.valueOf(copy.getAutomaton().getName()) + " no longer in trajectory_waiting"));
                this.trajectory_waiting.remove(copy.getAutomaton());
            }
            cat.debug((Object)copy);
            if (this.trajs_to_follow.isEmpty()) {
                cat.debug((Object)"Done following all trajectories.");
                this.should_follow_trajectories = false;
                if (copy.getOrder() == 1) {
                    copy.setOrder(4);
                } else {
                    copy.setOrder(3);
                }
            }
            return copy;
        }
        cat.debug((Object)"Error");
        return null;
    }

    private ActualAutInterface nextComponent(ExecControl c) throws SimException {
        cat.debug((Object)"In Composite Next Transition\n");
        Vector clonedPA = (Vector)this.primitiveAutomata.clone();
        Random randGenerator = new Random();
        int sizePA = clonedPA.size();
        ActualAutInterface actAut = null;
        try {
            actAut = (ActualAutInterface)clonedPA.get(0);
        }
        catch (Exception e) {
            throw new SimException("Must declare at least one component in Composite Automaton");
        }
        if (sizePA > 0 && this.numberSimulatable > 0) {
            switch (componentSelectionPolicy) {
                case 1: {
                    int randomInt = 0;
                    if (sizePA > 1) {
                        int lo = 0;
                        int hi = sizePA - 1;
                        int n = hi - lo + 1;
                        randomInt = randGenerator.nextInt() % n;
                        if (randomInt < 0) {
                            randomInt = -randomInt;
                        }
                    }
                    actAut = (ActualAutInterface)clonedPA.remove(randomInt);
                    sizePA = clonedPA.size();
                    break;
                }
                case 2: {
                    if (sizePA > 1) {
                        ++this.nextComponent;
                        if (this.nextComponent == sizePA) {
                            this.nextComponent = 0;
                        }
                    } else {
                        this.nextComponent = 0;
                    }
                    actAut = (ActualAutInterface)clonedPA.get(this.nextComponent);
                    break;
                }
                case 3: {
                    int lo = 0;
                    int hi = weights[totalWeights];
                    int n = hi - lo + 1;
                    randGenerator.nextInt();
                    int randomInt = randGenerator.nextInt() % n;
                    if (randomInt < 0) {
                        randomInt = -randomInt;
                    }
                    actAut = this.getWeightedComp(randomInt);
                }
            }
            cat.debug((Object)("act aut returned : " + actAut.getName()));
            return actAut;
        }
        return null;
    }

    private Step nextStep_from_component(ActualAutInterface actAut, ExecControl c) throws SimException {
        if (this.duration.get(actAut) > 0.0) {
            cat.debug((Object)("This automaton did not finish executing " + this.traj_to_follow.get(actAut)));
            HashSet<ActualAutomaton> W = new HashSet<ActualAutomaton>();
            for (ActualAutomaton actualAutomaton : this.primitiveAutomata) {
                if (this.trajectory_waiting.contains(actualAutomaton)) continue;
                W.add(actualAutomaton);
                cat.debug((Object)("adding to W:" + actualAutomaton.getName()));
            }
            if (!W.isEmpty()) {
                ActualAutomaton yield = (ActualAutomaton)W.iterator().next();
                cat.debug((Object)("Yielding to " + yield.getName()));
                return this.nextStep_from_component(yield, c);
            }
        }
        String lastAut = "";
        String lastAction = "";
        boolean bl = false;
        if (!actAut.isSimulatable()) {
            cat.debug((Object)("Aut not simulatable : " + actAut.getName() + " simulatable left : " + this.numberSimulatable));
            return null;
        }
        cat.debug((Object)("Checking transitions for:" + actAut.getName()));
        Step step = actAut.nextStep(c);
        if (step instanceof ActualTransition) {
            ActualTransition actTrans = (ActualTransition)step;
            if (actTrans != null) {
                cat.debug((Object)"Returning Actual Transition");
                cat.debug((Object)("\nTrans Name: " + actTrans));
                if (this.notEverConnected(c, actTrans)) {
                    boolean bl2 = false;
                    return actTrans;
                }
                return new NOPstep(actTrans.getAutomaton());
            }
            if (!actAut.isSimulatable()) {
                --this.numberSimulatable;
                if (componentSelectionPolicy == 3) {
                    this.removeAutFromWeights(actAut.getName());
                }
            }
        } else if (step instanceof ExecTrajectory) {
            ExecTrajectory execTraj = (ExecTrajectory)step;
            ActualAutomaton aut = execTraj.getAutomaton();
            this.trajectory_waiting.add(aut);
            this.duration.put(aut, new Double(execTraj.getDuration()));
            this.traj_to_follow.put(aut, execTraj);
            HashSet<ActualAutomaton> W = new HashSet<ActualAutomaton>();
            for (ActualAutomaton actualAutomaton : this.primitiveAutomata) {
                if (this.trajectory_waiting.contains(actualAutomaton)) continue;
                W.add(actualAutomaton);
                cat.debug((Object)("adding to W:" + actualAutomaton.getName()));
            }
            if (!W.isEmpty()) {
                ActualAutomaton yield = (ActualAutomaton)W.iterator().next();
                cat.debug((Object)("Yielding to " + yield.getName()));
                return this.nextStep_from_component(yield, c);
            }
            double d = this.duration.entrySet().iterator().next().getValue();
            for (ActualAutomaton aa : this.duration.keySet()) {
                if (!(this.duration.get(aa) < d)) continue;
                d = this.duration.get(aa);
            }
            cat.debug((Object)("d: " + d));
            this.should_follow_trajectories = true;
            this.dur = d;
            Iterator<ActualAutomaton> j = this.traj_to_follow.keySet().iterator();
            while (j.hasNext()) {
                ExecTrajectory to_add = this.traj_to_follow.get(j.next());
                cat.debug((Object)("Adding " + to_add + " to list"));
                this.trajs_to_follow.add(to_add);
            }
            return null;
        }
        return null;
    }

    @Override
    public Vector<Evaluable> getActuals() {
        return this.actuals;
    }

    @Override
    public Enumeration enumModifiedVariables() {
        cat.debug((Object)"enumModifiedVariables");
        Vector<SimVariable> allMods = new Vector<SimVariable>();
        Enumeration<PrimitiveAutomaton> e = this.primitiveAutomata.elements();
        while (e.hasMoreElements()) {
            ActualAutomaton actAut = (ActualAutomaton)e.nextElement();
            cat.debug((Object)("for automaton :" + actAut.getName()));
            Enumeration autsModVars = actAut.enumModifiedVariables();
            while (autsModVars.hasMoreElements()) {
                SimVariable next = (SimVariable)autsModVars.nextElement();
                next.setAutName(actAut.getName());
                allMods.add(next);
            }
        }
        return allMods.elements();
    }

    @Override
    public Enumeration enumVariables() {
        cat.debug((Object)"enumVariables");
        Vector<SimVariable> allMods = new Vector<SimVariable>();
        Enumeration<PrimitiveAutomaton> e = this.primitiveAutomata.elements();
        while (e.hasMoreElements()) {
            ActualAutomaton actAut = (ActualAutomaton)e.nextElement();
            cat.debug((Object)("for automaton :" + actAut.getName()));
            Enumeration autsVars = actAut.enumVariables();
            while (autsVars.hasMoreElements()) {
                SimVariable next = (SimVariable)autsVars.nextElement();
                next.setAutName(actAut.getName());
                allMods.add(next);
            }
        }
        return allMods.elements();
    }

    @Override
    public final String getName() {
        return this.aut.getName();
    }

    public Term getWhere() {
        return this.aut.getWhere();
    }

    @Override
    public final Vector getInvariants() {
        cat.debug((Object)"getInvariants");
        Vector<Invariant> allInvs = new Vector<Invariant>();
        Enumeration<PrimitiveAutomaton> e = this.primitiveAutomata.elements();
        while (e.hasMoreElements()) {
            ActualAutomaton actAut = (ActualAutomaton)e.nextElement();
            allInvs.addAll(actAut.getInvariants());
        }
        allInvs.addAll(this.aut.getInvariants());
        return allInvs;
    }

    @Override
    public SimAutomaton getSimAutomaton() {
        return this.aut;
    }

    @Override
    public SValue toSValue() {
        return this.aut.toSValue();
    }

    @Override
    public void assignActuals(ExecControl c) throws SimException {
        this.aut.assignActuals(c);
    }

    @Override
    public void fireConnected(Simulator c, ActualTransition steped) {
        if (steped == null) {
            return;
        }
        Action action = null;
        cat.debug((Object)"In Fire Connected\n");
        if (steped.getActionType() == 1) {
            cat.debug((Object)" This is indeed an output action\n");
            SimTransition simSteped = (SimTransition)steped.getTransition();
            Vector actualParameters = steped.getActuals();
            Enumeration<PrimitiveAutomaton> e = this.primitiveAutomata.elements();
            while (e.hasMoreElements()) {
                ActualAutomaton primAut = (ActualAutomaton)e.nextElement();
                if (primAut.getName().equals(steped.getAutomaton().getName())) continue;
                cat.debug((Object)"Found an automaton with a different name than the one that just fired\n");
                boolean actionFound = false;
                Enumeration actions = primAut.getSimAutomaton().getActionTable().enumActions();
                while (actions.hasMoreElements()) {
                    action = (Action)actions.nextElement();
                    if (!action.getName().equals(simSteped.getAction().getName())) continue;
                    cat.debug((Object)action.getName());
                    actionFound = true;
                    break;
                }
                if (!actionFound || action.getType() != 0) continue;
                cat.debug((Object)"Found a matching input action\n");
                Enumeration actTrans = action.getTransitions().elements();
                while (actTrans.hasMoreElements()) {
                    cat.debug((Object)"This input action has at least one transition\n");
                    SimTransition simTran = (SimTransition)((Object)actTrans.nextElement());
                    ActualTransition connected = new ActualTransition(primAut, simTran, actualParameters);
                    connected.setConnected(steped);
                    try {
                        c.doStep(connected, false);
                    }
                    catch (SimException ex) {
                        cat.debug((Object)"dostep caused an exception\n");
                    }
                }
            }
        }
    }

    public ActualAutomaton getCompAutomaton(String name) {
        if (!this.compMapInitialized) {
            Enumeration<PrimitiveAutomaton> e = this.primitiveAutomata.elements();
            while (e.hasMoreElements()) {
                ActualAutomaton actAut = (ActualAutomaton)e.nextElement();
                cat.debug((Object)("Adding Actual Automaton in table: " + actAut.getName()));
                String actAutName = actAut.getName();
                this.compNameToAut.put(actAutName, actAut);
            }
        }
        ActualAutomaton a = this.compNameToAut.get(name);
        cat.debug((Object)("For " + name + " found actual automaton: " + a));
        return a;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    private boolean notEverConnected(ExecControl c, ActualTransition steped) throws SimException {
        Action action = null;
        if (steped.getActionType() == 0) {
            SimTransition simSteped = (SimTransition)steped.getTransition();
            Vector actualParameters = steped.getActuals();
            Enumeration<PrimitiveAutomaton> e = this.primitiveAutomata.elements();
            while (e.hasMoreElements()) {
                ActualAutomaton primAut = (ActualAutomaton)e.nextElement();
                if (primAut.getName().equals(steped.getAutomaton().getName())) continue;
                boolean actionFound = false;
                Enumeration actions = primAut.getSimAutomaton().getActionTable().enumActions();
                while (actions.hasMoreElements()) {
                    action = (Action)actions.nextElement();
                    if (!action.getName().equals(simSteped.getAction().getName())) continue;
                    actionFound = true;
                    break;
                }
                if (!actionFound || action.getType() != 1 || !this.actionStillConsidered(c, action, actualParameters)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean actionStillConsidered(ExecControl c, Action act, Vector actualParams) throws SimException {
        Enumeration enumFormals = act.getFormals().elements();
        Enumeration enumActualActuals = actualParams.elements();
        int opn = 1;
        while (enumFormals.hasMoreElements()) {
            Term f = (Term)enumFormals.nextElement();
            Entity aa = (Entity)enumActualActuals.nextElement();
            if (f.isConstant()) {
                Entity constVal = ((Evaluable)f).evaluate(c, false);
                if (!constVal.equals(aa)) {
                    return false;
                }
            } else {
                ((SimVarRefTerm)f).assign(c, aa);
            }
            ++opn;
        }
        return c.evalBoolean((Evaluable)act.getWherePred());
    }

    public static void setWeights(BufferedReader br) throws SimException {
        weightsHash = new Hashtable();
        componentSelectionPolicy = 3;
        Vector<Integer> tempWeights = new Vector<Integer>();
        int counter = 0;
        int totalWeight = 0;
        int weightInt = 0;
        try {
            String nextLine = br.readLine();
            while (nextLine != null) {
                ++counter;
                String[] linearray = nextLine.split("=");
                String compName = linearray[0];
                if (compName.equals(nextLine)) {
                    throw new SimException("Illegal line in weights file : " + compName);
                }
                compName = compName.trim();
                String weight = linearray[1];
                weight = weight.trim();
                try {
                    weightInt = Integer.valueOf(weight);
                }
                catch (NumberFormatException nfe) {
                    throw new SimException("Weight must be integer : " + nextLine);
                }
                if (weightInt < 0) {
                    throw new SimException("Weight must be nonnegative : " + nextLine);
                }
                weightsHash.put(new Integer(counter), compName);
                tempWeights.add(new Integer(totalWeight += weightInt));
                nextLine = br.readLine();
            }
        }
        catch (IOException ie) {
            throw new SimException("Illegal Weight File");
        }
        totalWeights = counter;
        weights = new int[totalWeights + 1];
        int counterB = 1;
        ActualCompositeAutomaton.weights[0] = 0;
        Enumeration e = tempWeights.elements();
        while (e.hasMoreElements()) {
            ActualCompositeAutomaton.weights[counterB] = (Integer)e.nextElement();
            ++counterB;
        }
    }

    private ActualAutInterface getWeightedComp(int randInt) throws SimException {
        int appropriateIndex = totalWeights;
        int a = 1;
        while (a < totalWeights + 1) {
            if (randInt < weights[a]) {
                appropriateIndex = a;
                break;
            }
            ++a;
        }
        String compToGet = (String)weightsHash.get(new Integer(appropriateIndex));
        ActualAutomaton nextComp = this.getCompAutomaton(compToGet);
        if (nextComp == null) {
            throw new SimException("Illegal Component Specified in Weigh File : " + compToGet);
        }
        return nextComp;
    }

    private void removeAutFromWeights(String autName) {
        boolean subtract = false;
        int toSubtract = 0;
        int a = 1;
        while (a < totalWeights + 1) {
            if (subtract) {
                ActualCompositeAutomaton.weights[a] = weights[a] - toSubtract;
            } else if (autName.equals((String)weightsHash.get(new Integer(a)))) {
                subtract = true;
                toSubtract = weights[a] - weights[a - 1];
                ActualCompositeAutomaton.weights[a] = weights[a] - toSubtract;
            }
            ++a;
        }
    }
}

