/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.nodes;

import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.il.nodes.State;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.Assignable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimSort;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.simulator.ui.WhereFailedEvent;
import com.veromodo.tioa.util.FilterEnumeration;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActualAutomaton
extends BasicILElement
implements ActualAutInterface {
    private static final IOACategory cat = IOACategory.getInstance((String)ActualAutomaton.class.getName());
    protected SimPrimitiveAutomaton aut;
    protected Vector<Evaluable> actuals;
    protected boolean canSimulate = true;
    static /* synthetic */ Class class$0;

    public ActualAutomaton(SimPrimitiveAutomaton aut, Vector<Evaluable> actuals) throws SimException {
        this.aut = aut;
        this.actuals = actuals;
        cat.debug((Object)("actuals: " + actuals));
    }

    @Override
    public boolean isSimulatable() {
        return this.canSimulate;
    }

    @Override
    public void setNotSimulatable() {
        this.canSimulate = false;
    }

    @Override
    public final void initialize(ExecControl c) throws SimException {
        this.initialize(c, true);
    }

    @Override
    public void initialize(ExecControl c, boolean initState) throws SimException {
        Vector formals = this.aut.getFormals();
        if (this.aut.getWithActs() != null) {
            int actSize = this.actuals.size();
            Vector withForms = this.aut.getWithForms();
            Vector withActs = this.aut.getWithActs();
            int withActsSize = withActs.size();
            int a = 0;
            while (a < withActsSize) {
                Term iAct = (Term)withActs.elementAt(a);
                Term iForm = (Term)withForms.elementAt(a);
                cat.debug((Object)("Declaration param num : " + a));
                cat.debug((Object)("Acts : " + iAct));
                cat.debug((Object)("Form : " + iForm));
                ((Assignable)iForm).assign(c, ((Evaluable)iAct).evaluate(c, false));
                ++a;
            }
            throw new RuntimeException("buggy method. fixme");
        }
        int n = this.actuals.size();
        int i = 0;
        while (i < n) {
            cat.debug((Object)("class : " + ((Term)formals.elementAt(i)).getClass()));
            SimVarRefTerm simVar = (SimVarRefTerm)formals.elementAt(i);
            Evaluable actLit = this.actuals.elementAt(i);
            Entity act = actLit.evaluate(c, false);
            cat.debug((Object)("sim var : " + simVar));
            cat.debug((Object)("act : " + act));
            simVar.assign(c, act);
            ++i;
        }
        Evaluable where = (Evaluable)this.getWhere();
        if (!c.evalBoolean(where)) {
            c.registerEvent(new WhereFailedEvent(this.aut));
        }
        if (initState) {
            ActualAutomaton.initializeStates(c, this.aut.getStates().enumerate());
        }
    }

    protected static void initializeStates(ExecControl c, Enumeration enum1) throws SimException {
        while (enum1.hasMoreElements()) {
            State state = (State)enum1.nextElement();
            Evaluable val = (Evaluable)state.getInitialValue();
            SimVariable var = (SimVariable)state.getVariable();
            var.assign(c, val != null ? val.evaluate(c, false) : ((SimSort)var.getSort()).newEntity());
        }
    }

    public Vector<Term> getWhereTerms() {
        Vector<Term> v = new Vector<Term>();
        if (this.aut.getWhere() != null) {
            v.add(this.aut.getWhere());
        }
        return v;
    }

    @Override
    public abstract Step nextStep(ExecControl var1) throws SimException;

    @Override
    public Vector<Evaluable> getActuals() {
        return this.actuals;
    }

    @Override
    public Enumeration enumModifiedVariables() {
        cat.debug((Object)"enumModifiedVariables");
        return new FilterEnumeration(this.aut.getStates().enumerate()){

            public Object filter(Object obj) {
                SimVariable var = (SimVariable)((State)obj).getVariable();
                return var.modified ? var : null;
            }
        };
    }

    @Override
    public Enumeration enumVariables() {
        cat.debug((Object)"enumVariables");
        return new FilterEnumeration(this.aut.getStates().enumerate()){

            public Object filter(Object obj) {
                return (SimVariable)((State)obj).getVariable();
            }
        };
    }

    @Override
    public final String getName() {
        return this.aut.getName();
    }

    @Override
    public final Vector<Invariant> getInvariants() {
        return this.aut.getInvariants();
    }

    public Term getWhere() {
        return this.aut.getWhere();
    }

    @Override
    public SimAutomaton getSimAutomaton() {
        return this.aut;
    }

    StateTable getStates() {
        return this.aut.getStates();
    }

    @Override
    public SValue toSValue() {
        return this.aut.toSValue();
    }

    @Override
    public void fireConnected(Simulator c, ActualTransition steped) {
    }

    @Override
    public void assignActuals(ExecControl c) throws SimException {
    }

    @Override
    public boolean isComposite() {
        return false;
    }
}

