/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.impl;

import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.registry.Environment;
import com.veromodo.tioa.registry.OpConstructor;
import com.veromodo.tioa.registry.OpImpl;
import com.veromodo.tioa.registry.OpTemplate;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.simulator.impl.BasicAssignableOpImpl;
import com.veromodo.tioa.simulator.impl.BasicOpImpl;
import com.veromodo.tioa.simulator.impl.ExtAssignableOpImpl;
import com.veromodo.tioa.simulator.impl.ExtOpImpl;
import java.util.Vector;

public class SimOpConstructor
extends OpConstructor {
    protected Class implClass;
    protected String methodName;
    protected int numParameters;
    protected final boolean isAssignOp;
    protected final String assignMethodName;
    protected final boolean isCurriedOp;
    protected final Vector builtIns;
    protected final boolean arrayMode;

    public SimOpConstructor(OpTemplate template, Class implClass, String methodName) {
        super(template);
        this.implClass = implClass;
        this.methodName = methodName;
        this.numParameters = template.getArity();
        this.isAssignOp = false;
        this.assignMethodName = "";
        this.isCurriedOp = false;
        this.builtIns = null;
        this.arrayMode = false;
    }

    public SimOpConstructor(OpTemplate template, Class implClass, String methodName, String assignMethodName) {
        super(template);
        this.implClass = implClass;
        this.methodName = methodName;
        this.numParameters = template.getArity();
        this.isAssignOp = true;
        this.assignMethodName = assignMethodName;
        this.isCurriedOp = false;
        this.builtIns = null;
        this.arrayMode = false;
    }

    public SimOpConstructor(OpTemplate template, Class implClass, String methodName, Vector builtIns, boolean arrayMode) {
        super(template);
        this.implClass = implClass;
        this.methodName = methodName;
        this.numParameters = template.getArity();
        this.isAssignOp = false;
        this.assignMethodName = "";
        this.isCurriedOp = true;
        this.builtIns = builtIns;
        this.arrayMode = arrayMode;
    }

    public SimOpConstructor(OpTemplate template, Class implClass, String methodName, String assignName, Vector builtIns, boolean arrayMode, int numParameters) {
        super(template);
        this.implClass = implClass;
        this.methodName = methodName;
        this.numParameters = template.getArity();
        this.isAssignOp = true;
        this.assignMethodName = assignName;
        this.isCurriedOp = true;
        this.builtIns = builtIns;
        this.arrayMode = arrayMode;
    }

    protected OpImpl construct(Operator op, Environment evn) throws RegistryException {
        if (this.isAssignOp) {
            if (this.isCurriedOp) {
                return new ExtAssignableOpImpl(this.implClass, this.methodName, this.numParameters, this.assignMethodName, this.builtIns, this.arrayMode);
            }
            return new BasicAssignableOpImpl(this.implClass, this.methodName, this.numParameters, this.assignMethodName);
        }
        if (this.isCurriedOp) {
            return new ExtOpImpl(this.implClass, this.methodName, this.numParameters, this.builtIns, this.arrayMode);
        }
        return new BasicOpImpl(this.implClass, this.methodName, this.numParameters);
    }
}

