/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.impl;

import com.veromodo.tioa.registry.ConstrImplRegistry;
import com.veromodo.tioa.registry.Installer;
import com.veromodo.tioa.registry.OpConstructor;
import com.veromodo.tioa.registry.OpImpl;
import com.veromodo.tioa.registry.OpTemplate;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.registry.SortConstructor;
import com.veromodo.tioa.registry.SortImpl;
import com.veromodo.tioa.registry.SortTemplate;
import com.veromodo.tioa.simulator.impl.BasicOpImpl;
import com.veromodo.tioa.simulator.impl.BasicSortImpl;
import com.veromodo.tioa.simulator.impl.ShortcutOpImpl;
import com.veromodo.tioa.simulator.impl.SimOpConstructor;
import com.veromodo.tioa.simulator.impl.SimShortcutOpConstructor;
import com.veromodo.tioa.simulator.impl.SimSortConstructor;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Vector;

public class SimInstaller
extends Installer {
    private static final IOACategory cat = IOACategory.getInstance((String)SimInstaller.class.getName());
    protected Class implClass = null;
    protected boolean initialized = false;
    static /* synthetic */ Class class$0;

    protected void ensureInitialized() throws RegistryException {
        if (!this.initialized) {
            this.initialize();
        }
    }

    public SimInstaller(String implClass, ConstrImplRegistry registry) {
        super(implClass, registry);
    }

    private void initialize() throws RegistryException {
        try {
            this.implClass = Class.forName(String.valueOf(this.implPackage) + "." + this.implClassName);
            this.initialized = true;
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException(e.getMessage());
        }
    }

    protected SortConstructor sortConstructorHook(boolean isLiteral, SortTemplate template) throws RegistryException {
        this.ensureInitialized();
        return new SimSortConstructor(this.implClass, template);
    }

    protected OpConstructor opConstructorHook(OpTemplate template, String methodName) throws RegistryException {
        this.ensureInitialized();
        return new SimOpConstructor(template, this.implClass, methodName);
    }

    protected OpConstructor shortcutOpConstructorHook(OpTemplate template, String methodName, String shortcutStyle) throws RegistryException {
        this.ensureInitialized();
        return new SimShortcutOpConstructor(template, this.implClass, methodName, shortcutStyle);
    }

    protected OpConstructor assignOpConstructorHook(OpTemplate template, String methodName, String assignMethod) throws RegistryException {
        this.ensureInitialized();
        return new SimOpConstructor(template, this.implClass, methodName, assignMethod);
    }

    protected SortImpl sortImplHook(String implClassPackage, boolean isLiteral) throws RegistryException {
        this.ensureInitialized();
        return new BasicSortImpl(this.implClass);
    }

    protected OpImpl opImplHook(String opName, String range, String[] domain, String methodName, int numParameters) throws RegistryException {
        this.ensureInitialized();
        return new BasicOpImpl(this.implClass, methodName, numParameters);
    }

    protected OpImpl opImplHook(String opName, String range, String methodName, int numParameters) throws RegistryException {
        this.ensureInitialized();
        return new BasicOpImpl(this.implClass, methodName, numParameters);
    }

    protected OpImpl shortcutOpImplHook(String opName, String range, String[] domain, String methodName, String style, int numParameters) throws RegistryException {
        this.ensureInitialized();
        return new ShortcutOpImpl(this.implClass, methodName, numParameters, style);
    }

    protected OpConstructor curriedOpConstrHook(OpTemplate opTemplate, String methodName, Vector builtIns, boolean arrayMode, int numParameters) throws RegistryException {
        this.ensureInitialized();
        return new SimOpConstructor(opTemplate, this.implClass, methodName, builtIns, arrayMode);
    }

    protected OpConstructor assignableCurriedOpConstrHook(OpTemplate opTemplate, String methodName, String assignName, Vector builtIns, boolean arrayMode, int numParameters) throws RegistryException {
        this.ensureInitialized();
        return new SimOpConstructor(opTemplate, this.implClass, methodName, assignName, builtIns, arrayMode, numParameters);
    }
}

