/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.exec;

import com.veromodo.tioa.il.nodes.BasicVariable;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.ExecTrajectory;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.ActualCompositeAutomaton;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.nodes.ndr.SimPrimitiveAutomaton;
import com.veromodo.tioa.simulator.ui.BeginStepEvent;
import com.veromodo.tioa.simulator.ui.ExecEndedEvent;
import com.veromodo.tioa.simulator.ui.InitializedEvent;
import com.veromodo.tioa.simulator.ui.InvariantFailedEvent;
import com.veromodo.tioa.simulator.ui.SimEvent;
import com.veromodo.tioa.util.ArrayUtil;
import com.veromodo.tioa.util.CollectionsUtils;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simulator
extends ExecControl {
    private static final IOACategory cat = IOACategory.getInstance((String)Simulator.class.getName());
    private static final IOACategory catInit = IOACategory.getInstance((String)(String.valueOf(Simulator.class.getName()) + ".init"));
    protected ActualAutInterface aut;
    public static int MAX_NDR_STEPS = 500;
    protected boolean canContinue = true;
    static /* synthetic */ Class class$0;

    public Simulator(ActualAutInterface aut) {
        super(null);
        this.aut = aut;
    }

    @Override
    public Simulator getSimulator() {
        return this;
    }

    public boolean initialize() throws SimException {
        this.canContinue = true;
        this.clearModified();
        this.aut.initialize(this);
        this.registerEvent(new InitializedEvent());
        this.checkInvariants();
        this.clearModified();
        return this.canContinue;
    }

    public Step preStep() throws SimException {
        if (!this.canContinue) {
            throw new SimException("No more automaton steps");
        }
        Step result = this.aut.nextStep(this);
        if (result != null) {
            this.registerEvent(new BeginStepEvent(result, result.getAutomaton()));
        }
        return result;
    }

    public Step doStep(Step step) throws SimException {
        return this.doStep(step, true);
    }

    public Step doStep(Step step, boolean beginEventFlag) throws SimException {
        if (step == null) {
            ExecEndedEvent ev = new ExecEndedEvent(this);
            this.registerEvent(ev);
            this.canContinue = false;
        } else {
            this.pc = step;
            try {
                int counter = 0;
                cat.debug((Object)("About to execute step " + step));
                while (this.pc != null && this.canContinue) {
                    cat.debug((Object)("Looping actualTransition/execTrajectory: " + new Integer(++counter) + ": " + this.pc));
                    this.pc.execute(this);
                    if (this.pc instanceof ActualTransition) continue;
                }
                if (step instanceof ExecTrajectory || step instanceof ActualTransition && !((ActualTransition)step).isConnected()) {
                    this.clearModified();
                }
            }
            catch (ExecProduct p) {
                throw new InternalError("unexpected execution product: " + p);
            }
            if (this.canContinue && step instanceof ActualTransition && !((ActualTransition)step).isConnected()) {
                this.checkInvariants();
            }
        }
        return step;
    }

    public Step step() throws SimException {
        cat.debug((Object)"step()");
        Step step = this.preStep();
        if (step instanceof ActualTransition) {
            this.aut.fireConnected(this, (ActualTransition)step);
        }
        this.doStep(step);
        return step;
    }

    public boolean canStep() {
        return this.canContinue;
    }

    public final ActualAutInterface getAutomaton() {
        return this.aut;
    }

    protected boolean checkInvariants() throws SimException {
        cat.debug((Object)(String.valueOf(this.aut.getName()) + "'s state variables are " + CollectionsUtils.makeString(this.aut.enumVariables())));
        boolean someFailed = false;
        Enumeration enum1 = this.aut.getInvariants().elements();
        while (enum1.hasMoreElements()) {
            Invariant inv = (Invariant)enum1.nextElement();
            if (this.evalBoolean((Evaluable)inv.getPredicate())) continue;
            someFailed = true;
            boolean bl = this.canContinue = this.registerEvent(new InvariantFailedEvent(inv)) && this.canContinue;
        }
        return !someFailed;
    }

    public final Enumeration enumModifiedVariables() {
        return this.aut.enumModifiedVariables();
    }

    public final Enumeration<SimVariable> enumVariables() {
        return this.aut.enumVariables();
    }

    @Override
    public boolean registerEvent(SimEvent ev) throws SimException {
        boolean result = super.registerEvent(ev);
        this.canContinue = this.canContinue && result;
        return result;
    }

    @Override
    public ExecControl newControl(Executable pc) {
        cat.debug((Object)("newControl(" + pc + ")"));
        Simulator s = new Simulator(this, pc);
        s.aut = this.aut;
        return s;
    }

    @Override
    public ExecControl newControl(Executable pc, ActualAutInterface aai) {
        cat.debug((Object)("newControl(" + pc + ")"));
        Simulator s = new Simulator(this, pc);
        s.aut = aai;
        return s;
    }

    private Simulator(ExecControl c, Executable pc) {
        super(c, pc);
    }

    @Override
    public final Vector evalVector(Vector v, boolean asLValue) throws SimException {
        cat.debug((Object)("first vector " + ArrayUtil.makeString(v.toArray())));
        Vector newvec = super.evalVector(v, asLValue);
        if (newvec == null) {
            return newvec;
        }
        cat.debug((Object)("doing sim-specific checks for vector " + ArrayUtil.makeString(newvec.toArray())));
        cat.debug((Object)("myAut is: " + this.aut.getName()));
        int i = 0;
        while (i < newvec.size()) {
            SimVarRefTerm svrt;
            BasicVariable var;
            SimAutomaton primaut;
            Evaluable ev;
            Entity ent = (Entity)newvec.elementAt(i);
            if (ent == null && (ev = (Evaluable)v.elementAt(i)) instanceof SimVarRefTerm && (primaut = this.getAutForName((var = (BasicVariable)(svrt = (SimVarRefTerm)ev).getRefVariable()).getName())) != null) {
                cat.debug((Object)"making an Entity in the result an Automaton");
                newvec.setElementAt(primaut, i);
            }
            ++i;
        }
        return newvec;
    }

    protected SimAutomaton getAutForName(String s) throws SimException {
        SimPrimitiveAutomaton simAut;
        cat.debug((Object)("getAutForName : " + s));
        if (s.equals(this.aut.getName())) {
            return this.aut.getSimAutomaton();
        }
        if (this.aut.getSimAutomaton() instanceof SimPrimitiveAutomaton && (simAut = (SimPrimitiveAutomaton)this.aut.getSimAutomaton()).getBasedOnAutomaton() != null && s.equals(simAut.getBasedOnAutomaton())) {
            return simAut;
        }
        if (this.aut instanceof ActualCompositeAutomaton) {
            ActualCompositeAutomaton aCa = (ActualCompositeAutomaton)this.aut;
            cat.debug((Object)("aCa:" + aCa.getName()));
            ActualAutomaton aa = aCa.getCompAutomaton(s);
            if (aa != null) {
                return aa.getSimAutomaton();
            }
        }
        return null;
    }
}

