/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.exec;

import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.Assignable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.SimTransition;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class PairedActualTransition
extends ActualTransition
implements Executable {
    private static final IOACategory debug = IOACategory.getInstance((String)PairedActualTransition.class.getName());
    protected Dictionary substTable;
    static /* synthetic */ Class class$0;

    public PairedActualTransition(ActualAutomaton aut, SimTransition transition, Vector actuals, Dictionary substTable) {
        super(aut, transition, actuals);
        this.substTable = substTable;
    }

    public final void assignChoiceSubsts(ExecControl c) throws SimException {
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("assigning choice substitutions for " + this));
        }
        if (this.substTable != null) {
            Enumeration enum1 = this.substTable.keys();
            while (enum1.hasMoreElements()) {
                Assignable var = (Assignable)enum1.nextElement();
                Entity value = (Entity)this.substTable.get(var);
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("  assigning: " + value + " for " + var));
                }
                var.assign(c, value);
            }
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("  done assigning choice substitutions for" + this));
        }
    }

    protected final void clearChoiceSubsts(ExecControl c) throws SimException {
        debug.debug((Object)("clearing choice substitutions for" + this));
        if (this.substTable != null) {
            Enumeration enum1 = this.substTable.keys();
            while (enum1.hasMoreElements()) {
                ((Assignable)enum1.nextElement()).assign(c, null);
            }
        }
        debug.debug((Object)("done clearing choice substitutions for" + this));
    }

    public void execute(ExecControl c) throws SimException, ExecProduct {
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("executing spec transition " + this));
        }
        super.execute(c);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append(super.toString());
        boolean comma = false;
        boolean didUsing = false;
        Enumeration enum1 = this.substTable.keys();
        while (enum1.hasMoreElements()) {
            if (!didUsing) {
                buf.append(" using ");
                didUsing = true;
            }
            if (comma) {
                buf.append(", ");
            }
            Variable v = (Variable)enum1.nextElement();
            Entity val = (Entity)this.substTable.get(v);
            buf.append(val.toString()).append(" for ").append(v.getName());
            comma = true;
        }
        return buf.toString();
    }
}

