/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.exec;

import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.exec.TrajExec;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.SimApplicationTerm;
import com.veromodo.tioa.simulator.nodes.SimLiteralTerm;
import com.veromodo.tioa.simulator.nodes.SimTrajectory;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.util.logger.IOACategory;

public class ExecTrajectory
extends Step {
    private static final IOACategory debug = IOACategory.getInstance((String)ExecTrajectory.class.getName());
    protected ActualAutomaton aut;
    protected SimTrajectory trajectory;
    protected Term duration;
    public static final int NONE = 0;
    public static final int FIRST = 1;
    public static final int IN_BETWEEN = 2;
    public static final int LAST = 3;
    public static final int FIRST_AND_LAST = 4;
    public boolean printAutomatonName = false;
    protected int order = 0;
    static /* synthetic */ Class class$0;

    public ExecTrajectory(ActualAutomaton aut, SimTrajectory trajectory, Term duration) {
        this.aut = aut;
        this.trajectory = trajectory;
        this.duration = duration;
    }

    public ActualAutomaton getAutomaton() {
        return this.aut;
    }

    public Trajectory getTrajectory() {
        return this.trajectory;
    }

    public Entity getDurationEntity() {
        ExecControl c = new ExecControl(null, null);
        try {
            if (this.duration instanceof SimApplicationTerm) {
                return ((SimApplicationTerm)this.duration).evaluate(c, false);
            }
            if (this.duration instanceof SimVarRefTerm) {
                return ((SimVarRefTerm)this.duration).evaluate(c, false);
            }
            if (this.duration instanceof SimLiteralTerm) {
                return ((SimLiteralTerm)this.duration).evaluate(null, false);
            }
            throw new RuntimeException("Duration Type: " + this.duration.getClass() + " not supported for printing");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public double getDuration() {
        return Double.parseDouble(this.getDurationEntity().toString());
    }

    public Sort getDurationSort() {
        return this.duration.getSort();
    }

    public void setDuration(double d) {
        this.duration = new SimLiteralTerm(this.duration.getSort(), d);
    }

    public void execute(ExecControl c) throws SimException, ExecProduct {
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("executing: " + this));
        }
        Executable evolveExec = this.trajectory.getCompiledEvolve(this.duration);
        c.pc = new TrajExec(evolveExec, this);
    }

    public String toString() {
        return "trajectory " + this.getDescription();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        if (this.printAutomatonName) {
            sb.append(this.aut.getName());
            sb.append(".");
        }
        sb.append(this.trajectory.getTrajectoryName());
        sb.append(" for ");
        sb.append(this.getDuration());
        sb.append(this.getDuration() == 1.0 ? " unit" : " units");
        return sb.toString();
    }

    public boolean isError() {
        return false;
    }

    public String eventDescription() {
        return this.toString();
    }

    public void setOrder(int i) {
        this.order = i;
    }

    public int getOrder() {
        return this.order;
    }
}

