/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.exec;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.Assignable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.Executable;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.exec.StepsExceededProduct;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.ui.SimEvent;
import com.veromodo.tioa.simulator.ui.SimListener;
import com.veromodo.tioa.util.ArrayUtil;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class ExecControl {
    private static final IOACategory cat = IOACategory.getInstance((String)ExecControl.class.getName());
    public Executable pc;
    protected Simulator sim;
    protected Vector modified;
    protected Vector listeners;
    protected Stack stack;
    static /* synthetic */ Class class$0;

    public Simulator getSimulator() {
        return this.sim;
    }

    protected ExecControl(ExecControl c, Executable pc) {
        cat.debug((Object)("new ExecControl(" + pc + ") from " + c));
        if (c != null) {
            this.sim = c.getSimulator();
            this.listeners = c.listeners;
        } else {
            this.sim = null;
            this.listeners = new Vector(2);
        }
        this.pc = pc;
        this.modified = new Vector(10);
        this.stack = new Stack();
    }

    public ExecControl(Executable pc) {
        this(null, pc);
    }

    public ExecControl newControl(Executable pc) {
        cat.debug((Object)("newControl(" + pc + ")"));
        return new ExecControl(this, pc);
    }

    public ExecControl newControl(Executable pc, ActualAutInterface aai) {
        cat.debug((Object)("newControl(" + pc + ")"));
        return new ExecControl(this, pc);
    }

    public void setModified(SimVariable v) {
        if (!v.modified) {
            v.modified = true;
            cat.debug((Object)("setModified: " + v));
            this.modified.addElement(v);
        }
    }

    public void clearModified() {
        cat.debug((Object)"clearModified");
        Enumeration enum1 = this.modified.elements();
        while (enum1.hasMoreElements()) {
            ((SimVariable)enum1.nextElement()).modified = false;
        }
        this.modified.removeAllElements();
    }

    public Enumeration enumModified() {
        cat.debug((Object)"enumModified");
        return this.modified.elements();
    }

    public final void execute() throws SimException, ExecProduct {
        cat.debug((Object)"ExecControl.execute()");
        while (true) {
            if (this.pc != null) {
                this.pc.execute(this);
                continue;
            }
            if (this.stack.isEmpty()) break;
            this.pc = (Executable)this.stack.pop();
        }
    }

    public final void execute(int maxSteps) throws SimException, ExecProduct {
        cat.debug((Object)"ExecControl.execute()");
        int steps = 0;
        while (true) {
            if (this.pc != null) {
                if (++steps > maxSteps) {
                    throw new StepsExceededProduct();
                }
                this.pc.execute(this);
                continue;
            }
            if (this.stack.isEmpty()) break;
            this.pc = (Executable)this.stack.pop();
        }
    }

    public Vector evalVector(Vector v, boolean asLValue) throws SimException {
        cat.debug((Object)("calling evalVector for vector " + ArrayUtil.makeString(v.toArray())));
        if (v == null) {
            return null;
        }
        Vector<Entity> _v = new Vector<Entity>(v.size());
        boolean firstAsLValue = asLValue;
        Enumeration enum1 = v.elements();
        while (enum1.hasMoreElements()) {
            _v.addElement(((Evaluable)enum1.nextElement()).evaluate(this, firstAsLValue));
            firstAsLValue = false;
        }
        return _v;
    }

    public final void assignVector(Vector lhs, Vector rhs) throws SimException {
        Enumeration enum1 = lhs.elements();
        Enumeration enum2 = rhs.elements();
        while (enum1.hasMoreElements()) {
            ((Assignable)enum1.nextElement()).assign(this, (Entity)enum2.nextElement());
        }
    }

    public final void unassignVector(Vector lhs) throws SimException {
        Enumeration enum1 = lhs.elements();
        while (enum1.hasMoreElements()) {
            ((Assignable)enum1.nextElement()).assign(this, null);
        }
    }

    public final boolean evalBoolean(Evaluable pred) throws SimException {
        if (pred == null) {
            return true;
        }
        Entity ob = pred.evaluate(this, false);
        return ((ADT)ob).booleanValue();
    }

    public final void push(Executable exec) {
        this.stack.push(exec);
    }

    public void addListener(SimListener l) {
        this.listeners.addElement(l);
    }

    public void removeListener(SimListener l) {
        this.listeners.removeElement(l);
    }

    public boolean registerEvent(SimEvent ev) throws SimException {
        if (this.sim != null) {
            return this.sim.registerEvent(ev);
        }
        boolean canContinue = true;
        Enumeration enum1 = this.listeners.elements();
        while (enum1.hasMoreElements()) {
            SimListener l = (SimListener)enum1.nextElement();
            boolean bl = canContinue = l.handleSimEvent(ev) && canContinue;
        }
        return canContinue;
    }
}

