/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.exec;

import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.exceptions.SimException;
import com.veromodo.tioa.simulator.exec.AnnouncerExec;
import com.veromodo.tioa.simulator.exec.Assignable;
import com.veromodo.tioa.simulator.exec.Evaluable;
import com.veromodo.tioa.simulator.exec.ExecControl;
import com.veromodo.tioa.simulator.exec.ExecProduct;
import com.veromodo.tioa.simulator.exec.Step;
import com.veromodo.tioa.simulator.nodes.ActualAutomaton;
import com.veromodo.tioa.simulator.nodes.SimTransition;
import com.veromodo.tioa.simulator.nodes.SimVarRefTerm;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.ui.BadScheduleEvent;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ActualTransition
extends Step {
    private static final IOACategory debug = IOACategory.getInstance((String)ActualTransition.class.getName());
    protected ActualAutomaton aut;
    protected SimTransition transition;
    protected Vector actuals;
    protected StringBuffer connectedOutput = new StringBuffer();
    protected boolean connectedTransition = false;
    protected ActualTransition initial = null;
    public boolean printAutomatonName = false;
    static /* synthetic */ Class class$0;

    public ActualTransition(ActualAutomaton aut, SimTransition transition, Vector actuals) {
        this.aut = aut;
        this.transition = transition;
        this.actuals = actuals;
    }

    public ActualAutomaton getAutomaton() {
        return this.aut;
    }

    public void execute(ExecControl c) throws SimException, ExecProduct {
        Evaluable precondition;
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("executing: " + this));
        }
        Enumeration enumFormals = this.transition.getAction().getFormals().elements();
        Enumeration enumActuals = this.transition.getActionActuals().elements();
        Enumeration enumActualActuals = this.actuals.elements();
        int opn = 1;
        while (enumFormals.hasMoreElements()) {
            Term f = (Term)enumFormals.nextElement();
            Term a = (Term)enumActuals.nextElement();
            Entity aa = (Entity)enumActualActuals.nextElement();
            if (f.isConstant()) {
                Entity constVal = ((Evaluable)f).evaluate(c, false);
                if (!constVal.equals(aa)) {
                    if (this.isConnected()) {
                        c.pc = null;
                        return;
                    }
                    if (!c.registerEvent(new BadScheduleEvent(this, "actual parameter does not equal a constant formal"))) {
                        c.pc = null;
                        return;
                    }
                }
            } else {
                debug.debug((Object)"about to assign to formal");
                ((SimVarRefTerm)f).assign(c, aa);
            }
            if (a instanceof VarRefTerm) {
                ((Assignable)a).assign(c, aa);
            } else if (!c.registerEvent(new BadScheduleEvent(this, "Simulator can not handle compound expressions in transition signatures"))) {
                c.pc = null;
                return;
            }
            ++opn;
        }
        if (this.transition.getChooseFormals() != null) {
            for (SimVariable a : this.transition.getChooseFormals()) {
                Entity aa = (Entity)enumActualActuals.nextElement();
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("  Assigning local: " + a));
                }
                a.assign(c, aa);
            }
        }
        Assert.assertTrue(!enumActualActuals.hasMoreElements());
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("  Checking preconditions, etc. for: " + this));
        }
        if (!c.evalBoolean((Evaluable)this.transition.getAction().getWherePred())) {
            if (this.isConnected()) {
                c.pc = null;
                return;
            }
            if (!c.registerEvent(new BadScheduleEvent(this, "where clause of action does not hold"))) {
                c.pc = null;
                return;
            }
        }
        if (!c.evalBoolean((Evaluable)this.transition.getWherePred())) {
            if (this.isConnected()) {
                c.pc = null;
                return;
            }
            if (!c.registerEvent(new BadScheduleEvent(this, "where clause does not hold"))) {
                c.pc = null;
                return;
            }
        }
        if ((precondition = (Evaluable)this.transition.getPrecondition()) != null && !c.evalBoolean(precondition)) {
            debug.debug((Object)("Failed Precondition : " + precondition));
            if (!c.registerEvent(new BadScheduleEvent(this, "precondition fails"))) {
                c.pc = null;
                return;
            }
        }
        if (this.isConnected()) {
            this.initial.addConnectedOutput("\n     " + this.getDescription());
        }
        c.pc = new AnnouncerExec(this.transition.getCompiledEffect(), this, this.connectedTransition);
    }

    public Vector getActuals() {
        return this.actuals;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public int getActionType() {
        return this.transition.getAction().getType();
    }

    public String toString() {
        return this.getDescription();
    }

    public String getDescription() {
        String caseName;
        StringBuffer buf = new StringBuffer();
        switch (this.transition.getAction().getType()) {
            case 0: {
                buf.append("input ");
                break;
            }
            case 1: {
                buf.append("output ");
                break;
            }
            case 2: {
                buf.append("internal ");
            }
        }
        buf.append("transition ");
        if (this.printAutomatonName || this.isConnected()) {
            buf.append(String.valueOf(this.aut.getName()) + ".");
        }
        buf.append(this.transition.getAction().getName());
        if (this.actuals != null && !this.actuals.isEmpty()) {
            buf.append("(");
            Enumeration enum1 = this.actuals.elements();
            while (enum1.hasMoreElements()) {
                Object o = enum1.nextElement();
                if (o != null) {
                    buf.append(o);
                } else {
                    buf.append("#null");
                }
                if (!enum1.hasMoreElements()) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((caseName = this.transition.getCaseName()) != null && !caseName.equals("")) {
            buf.append(" case " + caseName);
        }
        return buf.toString();
    }

    public String actionString() {
        return this.transition.getId();
    }

    public boolean sameTransition(ActualTransition t) {
        Action act1 = this.transition.getAction();
        Action act2 = t.transition.getAction();
        if (act1.getType() != act2.getType() || !act1.getName().equals(act2.getName())) {
            return false;
        }
        Enumeration enum1 = this.actuals.elements();
        Enumeration enum2 = t.actuals.elements();
        try {
            while (enum1.hasMoreElements()) {
                if (((Entity)enum1.nextElement()).equals((Entity)enum2.nextElement())) continue;
                return false;
            }
            if (enum2.hasMoreElements()) {
                return false;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public boolean isError() {
        return false;
    }

    public String eventDescription() {
        return this.toString();
    }

    public void setConnected(ActualTransition init) {
        this.connectedTransition = true;
        this.initial = init;
    }

    public boolean isConnected() {
        return this.connectedTransition;
    }

    public void addConnectedOutput(String s) {
        this.connectedOutput.append(s);
    }

    public String getConnectedOutput() {
        return this.connectedOutput.toString();
    }
}

