/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.daikon;

import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.simulator.daikon.DaikonListener;
import com.veromodo.tioa.simulator.daikon.DaikonPrinter;
import com.veromodo.tioa.simulator.daikon.JavaConverter;
import com.veromodo.tioa.simulator.daikon.VarInfo;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.util.CollectionsUtils;
import com.veromodo.tioa.util.logger.IOACategory;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SplitterWriter
extends DaikonPrinter {
    private static final IOACategory cat = IOACategory.getInstance((String)SplitterWriter.class.getName());
    static /* synthetic */ Class class$0;

    public SplitterWriter(PrintWriter out, Simulator sim, DaikonListener listener) {
        super(out, sim, listener);
    }

    protected void printVar(VarInfo var) {
        throw new Error();
    }

    public void print() {
        this.out.println("# Spinfo file for " + System.getProperty("tioa.util.shell.fileName") + " generated by " + this.getClass().getName());
        Date date = new Date();
        if (System.getProperty("tioa.util.shell.rseed") == null) {
            this.out.println("# Generation date: " + date.toString());
        }
        this.out.println("PPT_NAME " + this.getPointFormat(null, "CLASS"));
        ActualAutInterface actualAut = this.sim.getAutomaton();
        SimAutomaton ilAut = actualAut.getSimAutomaton();
        List autVars = CollectionsUtils.enumerationToList(actualAut.enumVariables());
        for (Object obj : this.listener.getVariables().keySet()) {
            if (!(obj instanceof Transition)) continue;
            Transition transition = (Transition)obj;
            Term precond = transition.getPrecondition();
            List preconds = this.splitAnds(precond);
            if (precond == null) continue;
            for (Term cond : preconds) {
                String converted = JavaConverter.convert(cond, autVars);
                if (converted == null) continue;
                this.out.println(converted);
            }
        }
        this.out.println();
        this.out.flush();
    }

    private List splitAnds(Term precond) {
        ArrayList<Term> result = new ArrayList<Term>();
        if (precond instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)precond;
            if (at.getOperator().getName1().equals("/\\")) {
                result.addAll(this.splitAnds((Term)at.getOperands().get(0)));
                result.addAll(this.splitAnds((Term)at.getOperands().get(1)));
            } else {
                result.add(precond);
            }
        } else {
            result.add(precond);
        }
        return result;
    }
}

