/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.daikon;

import com.veromodo.tioa.il.ILVisitor;
import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.LiteralTerm;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.QuantifierTerm;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class JavaConverter {
    private static final IOACategory debug = IOACategory.getInstance((String)JavaConverter.class.getName());
    private static Map opNames;
    private static JavaVisitor visitor;
    private static boolean initialized;
    static /* synthetic */ Class class$0;

    static {
        initialized = false;
    }

    private JavaConverter() {
        throw new Error();
    }

    public static String convert(Term term, List autVars) {
        Object result;
        if (!initialized) {
            JavaConverter.initialize();
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("Trying: " + term.toString()));
        }
        try {
            JavaConverter.visitor.autVars = autVars;
            result = visitor.visit((ILElement)term);
        }
        catch (JavaVisitException jve) {
            if (debug.isDebugEnabled()) {
                debug.debug((Object)"VisitException");
            }
            result = null;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("Result " + result));
        }
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        visitor = new JavaVisitor();
        initialized = true;
        opNames = new HashMap();
        JavaConverter.addOpName("nil", "null");
        JavaConverter.addOpName("~", "!");
        JavaConverter.addOpName("=", "==");
        JavaConverter.addOpName("/\\", "&&");
        JavaConverter.addOpName("~=", "!=");
        JavaConverter.addOpName("\\/", "||");
        JavaConverter.addOpName("~", "!");
    }

    private static void addOpName(String ioaName, String javaName) {
        opNames.put(ioaName, javaName);
    }

    static class JavaVisitor
    extends ILVisitor {
        public List autVars = new ArrayList();

        public Object visitApplicationTerm(ApplicationTerm term) {
            StringBuffer result = new StringBuffer();
            Vector opands = new Vector(term.getOperands());
            Operator op = term.getOperator();
            result.append('(');
            if (debug.isDebugEnabled()) {
                debug.debug((Object)("VisitApplicationTerm: " + term.toSValue().toString()));
            }
            switch (op.getType() & 0xFFFFFF7F & 0xFFFFFFBF) {
                case 0: {
                    result.append(this.visit((ILElement)op));
                    break;
                }
                case 6: {
                    Assert.assertTrue(opands.size() == 0, "Constants have no operands");
                    result.append(op.getName());
                    break;
                }
                case 7: {
                    Assert.assertTrue(opands.size() == 3, "If ops have 3 operands");
                    ILElement pred = (ILElement)opands.get(0);
                    ILElement op1 = (ILElement)opands.get(1);
                    ILElement op2 = (ILElement)opands.get(2);
                    result.append(this.visit(pred)).append(" ? ").append(this.visit(op1)).append(" : ").append(this.visit(op2));
                    break;
                }
                case 1: {
                    debug.debug((Object)"VisitApplicationTerm: Infix");
                    Assert.assertTrue(opands.size() == 2, "Infix ops have 2 operands");
                    ILElement op1 = (ILElement)opands.get(0);
                    ILElement op2 = (ILElement)opands.get(1);
                    if (op.getName1().equals("\\in")) {
                        result.append("UtilMDE.ArraysMDE.indexOf(").append(this.visit(op1)).append(", ").append(this.visit(op2)).append(")");
                        result.append(" >= 0");
                        break;
                    }
                    result.append(this.visit(op1));
                    result.append(' ');
                    result.append(this.visit((ILElement)op));
                    result.append(' ');
                    result.append(this.visit(op2));
                    break;
                }
                case 2: {
                    debug.debug((Object)"VisitApplicationTerm: Prefix");
                    Assert.assertTrue(opands.size() == 1, "Prefix ops have 1 operand");
                    ILElement op1 = (ILElement)opands.get(0);
                    result.append(this.visit((ILElement)op));
                    result.append(' ');
                    result.append(this.visit(op1));
                    break;
                }
                case 3: {
                    debug.debug((Object)"VisitApplicationTerm: Postfix");
                    Assert.assertTrue(opands.size() == 1, "Postfix ops have 1 operand");
                    ILElement op1 = (ILElement)opands.get(0);
                    result.append(this.visit(op1));
                    result.append(' ');
                    result.append(this.visit((ILElement)op));
                    break;
                }
                case 4: {
                    debug.debug((Object)"VisitApplicationTerm: Mixfix");
                    boolean mfBefore = (op.getType() & 0x40) != 0;
                    boolean mfAfter = (op.getType() & 0x80) != 0;
                    Term tBefore = null;
                    Term tAfter = null;
                    if (mfBefore) {
                        tBefore = (Term)opands.get(0);
                        opands.remove(0);
                        result.append(this.visit((ILElement)tBefore));
                    }
                    if (mfAfter) {
                        tAfter = (Term)opands.get(opands.size() - 1);
                        opands.remove(opands.size() - 1);
                    }
                    result.append(op.getName1());
                    Iterator i = opands.iterator();
                    while (i.hasNext()) {
                        result.append(this.visit((ILElement)((Term)i.next())));
                        if (!i.hasNext()) continue;
                        result.append(", ");
                    }
                    result.append(op.getName2());
                    if (mfAfter) {
                        result.append(this.visit((ILElement)tAfter));
                    }
                    debug.debug((Object)result);
                    break;
                }
                default: {
                    debug.debug((Object)"Doing default handling");
                    result.append(this.visit((ILElement)op));
                    for (Term opand : opands) {
                        result.append(" ");
                        result.append(this.visit((ILElement)opand).toString());
                    }
                }
            }
            result.append(')');
            return result.toString();
        }

        public Object visitQuantifierTerm(QuantifierTerm qt) {
            throw new JavaVisitException();
        }

        public Object visitVariable(Variable var) {
            if (this.autVars.contains(var)) {
                return var.getName();
            }
            return "anIndex:" + var.getSort().getName();
        }

        public Object visitVarRefTerm(VarRefTerm var) {
            return this.visit((ILElement)var.getRefVariable());
        }

        public Object visitLiteralTerm(LiteralTerm term) {
            return new Double(term.getValue()).toString();
        }

        public Object visitOperator(Operator op) {
            String n1 = op.getName1();
            String result = "";
            result = opNames.get(n1);
            if (result == null) {
                result = n1;
            }
            if (op.getRange().isEnum()) {
                result = result + ":" + op.getRange().getName();
            }
            return result;
        }
    }

    static class JavaVisitException
    extends RuntimeException {
    }
}

