/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.daikon;

import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.runtime.adt.ArraySort;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.IntSort;
import com.veromodo.tioa.runtime.adt.NatSort;
import com.veromodo.tioa.runtime.adt.SetSort;
import com.veromodo.tioa.runtime.adt.StackSort;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.daikon.DaikonListener;
import com.veromodo.tioa.simulator.daikon.DaikonPrinter;
import com.veromodo.tioa.simulator.daikon.DaikonSort;
import com.veromodo.tioa.simulator.daikon.DaikonType;
import com.veromodo.tioa.simulator.daikon.VarInfo;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.util.logger.IOACategory;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

class DtracePrinter
extends DaikonPrinter {
    private static final IOACategory cat = IOACategory.getInstance((String)DtracePrinter.class.getName());
    static /* synthetic */ Class class$0;

    public DtracePrinter(PrintWriter out, Simulator sim, DaikonListener listener) {
        super(out, sim, listener);
    }

    public void print(String type, String transitionName, ActualTransition transition) {
        this.printPointName(transition == null ? null : transition.getTransition(), type);
        if (type == "ENTER") {
            this.printVarsList(transition, true);
        } else {
            this.printVarsList(transition, false);
        }
    }

    protected void printVar(VarInfo var) {
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("printVar for " + var.parent + var.name));
            cat.debug((Object)("Value is " + var.value));
        }
        this.out.println(String.valueOf(var.parent) + this.safeVarName(var.sort, var.name, var.sort instanceof DaikonSort));
        this.out.println(this.safePrintADT(var.sort, var.value));
        if (var.modInfo instanceof SimVariable && ((SimVariable)var.modInfo).modified) {
            this.out.println(1);
        } else if (var.modInfo == null) {
            this.out.println(1);
        } else {
            this.out.println(0);
        }
        this.out.flush();
    }

    protected void printVarsList(ActualTransition transition, boolean modifiedHandle) {
        String key = "CLASS";
        if (transition != null) {
            key = transition.getTransition();
        }
        List vars = (List)this.listener.getVariables().get(key);
        for (SimVariable simVar : vars) {
            VarInfo var = new VarInfo(simVar.getSort(), simVar.getName(), (String)this.listener.getNameBases().get(simVar), simVar.value, key, modifiedHandle ? null : simVar, "", false);
            this.printVarRecurse(var);
        }
    }

    protected String safePrintADT(Sort sort, Entity entity) {
        DaikonType type = DaikonType.getType(sort);
        if (DaikonType.isArray(type)) {
            if (entity == null) {
                return "[]";
            }
            return this.safePrintArray(entity, type);
        }
        if (type == DaikonType.NUMERIC) {
            if (entity == null) {
                return "0";
            }
            return entity.toString();
        }
        if (type == DaikonType.HASHCODE) {
            if (entity == null) {
                return "0";
            }
            return "" + entity.hashCode();
        }
        if (type == DaikonType.STRING) {
            if (entity == null) {
                return "\"\"";
            }
            return "\"" + entity.toString() + "\"";
        }
        if (type == DaikonType.BOOLEAN) {
            if (entity == null) {
                return "0";
            }
            return entity.equals(BoolSort.lit(true)) ? "1" : "0";
        }
        throw new RuntimeException("Unrecognized DaikonType " + type);
    }

    protected String safePrintArray(Entity arrayRep, DaikonType type) {
        if (arrayRep instanceof ArraySort) {
            return this.safePrintArrayArray((ArraySort)arrayRep, type);
        }
        if (arrayRep instanceof SetSort) {
            return this.safePrintArraySet((SetSort)arrayRep, type);
        }
        if (arrayRep instanceof StackSort) {
            return this.safePrintArrayStack((StackSort)arrayRep, type);
        }
        cat.warn((Object)"Warning: unrecognized type being passed in as array");
        return "[]";
    }

    protected String safePrintArrayStack(StackSort array, DaikonType type) {
        List l = array.toList();
        Iterator i = l.iterator();
        String retval = "[";
        while (i.hasNext()) {
            Object o = i.next();
            retval = type == DaikonType.ARRAY_NUMERIC ? String.valueOf(retval) + o.toString() : (type == DaikonType.ARRAY_BOOLEAN ? String.valueOf(retval) + (o.equals(BoolSort.lit(true)) ? "1" : "0") : (type == DaikonType.ARRAY_STRING ? String.valueOf(retval) + "\"" + o.toString() + "\"" : String.valueOf(retval) + o.hashCode()));
            if (!i.hasNext()) continue;
            retval = String.valueOf(retval) + " ";
        }
        retval = String.valueOf(retval) + "]";
        return retval;
    }

    protected String safePrintArraySet(SetSort array, DaikonType type) {
        ArrayList l = System.getProperty("tioa.util.shell.rseed") == null ? new ArrayList(array.getSet()) : new ArrayList(array.getSetOrdered());
        Iterator i = l.iterator();
        String retval = "[";
        while (i.hasNext()) {
            Object o = i.next();
            retval = type == DaikonType.ARRAY_NUMERIC ? String.valueOf(retval) + o.toString() : (type == DaikonType.ARRAY_BOOLEAN ? String.valueOf(retval) + (o.equals(BoolSort.lit(true)) ? "1" : "0") : (type == DaikonType.ARRAY_STRING ? String.valueOf(retval) + "\"" + o.toString() + "\"" : String.valueOf(retval) + o.hashCode()));
            if (!i.hasNext()) continue;
            retval = String.valueOf(retval) + " ";
        }
        retval = String.valueOf(retval) + "]";
        return retval;
    }

    protected String safePrintArrayArray(ArraySort array, DaikonType type) {
        Enumeration enumIndices = array.enumIndices();
        int max = -1;
        boolean indexType = false;
        while (enumIndices.hasMoreElements()) {
            Entity index = (Entity)enumIndices.nextElement();
            if (index instanceof IntSort) {
                indexType = false;
                max = Math.max(max, (int)((IntSort)index).value());
                continue;
            }
            indexType = true;
            max = Math.max(max, (int)((NatSort)index).value());
        }
        String retval = "[";
        int i = 0;
        while (i <= max) {
            Entity element = !indexType ? (Entity)ArraySort.elementAt(array, IntSort.lit(i)) : (Entity)ArraySort.elementAt(array, NatSort.lit(i));
            retval = type == DaikonType.ARRAY_NUMERIC ? String.valueOf(retval) + element.toString() : (type == DaikonType.ARRAY_BOOLEAN ? String.valueOf(retval) + (element.equals(BoolSort.lit(true)) ? "1" : "0") : (type == DaikonType.ARRAY_STRING ? String.valueOf(retval) + "\"" + element.toString() + "\"" : String.valueOf(retval) + element.hashCode()));
            if (i < max) {
                retval = String.valueOf(retval) + " ";
            }
            ++i;
        }
        retval = String.valueOf(retval) + "]";
        return retval;
    }

    protected void printPointName(Transition transition, String type) {
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("entering printPointName: " + this.getPointFormat(transition, type) + ":::" + type));
        }
        this.out.println("");
        this.out.println(this.getPointFormat(transition, type));
        this.out.flush();
    }
}

