/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.daikon;

import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.simulator.daikon.DaikonListener;
import com.veromodo.tioa.simulator.daikon.DaikonPrinter;
import com.veromodo.tioa.simulator.daikon.DaikonSort;
import com.veromodo.tioa.simulator.daikon.DaikonType;
import com.veromodo.tioa.simulator.daikon.VarInfo;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.util.logger.IOACategory;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

class DeclsPrinter
extends DaikonPrinter {
    private static final IOACategory cat = IOACategory.getInstance((String)DeclsPrinter.class.getName());
    private static final String standardAppends = " # nullTerminating=false, hasNull=false";
    static /* synthetic */ Class class$0;

    public DeclsPrinter(PrintWriter out, Simulator sim, DaikonListener listener) {
        super(out, sim, listener);
    }

    public void print() {
        this.out.println("// Decls file for " + System.getProperty("tioa.util.shell.fileName") + " generated by " + this.getClass().getName());
        Date date = new Date();
        if (System.getProperty("tioa.util.shell.rseed") == null) {
            this.out.println("// Generation date: " + date.toString());
        }
        this.out.println();
        this.out.println("VarComparability");
        this.out.println("none");
        this.out.println();
        Vector globalVars = new Vector();
        ActualAutInterface actualAut = this.sim.getAutomaton();
        SimAutomaton ilAut = actualAut.getSimAutomaton();
        List stateVarsList = (List)this.listener.getVariables().get("CLASS");
        HashSet stateVars = new HashSet(stateVarsList);
        this.printTransitionDecl(null, "CLASS", stateVarsList, "CLASS", stateVars);
        if (this.listener.getProperties().getFlag(String.valueOf("tioa.simulator.daikon.") + "printSteps")) {
            for (Object obj : this.listener.getVariables().keySet()) {
                if (!(obj instanceof Transition)) continue;
                Transition transition = (Transition)obj;
                List vars = (List)this.listener.getVariables().get(obj);
                this.printTransitionDecl(transition, "ENTER", vars, transition, stateVars);
                this.printTransitionDecl(transition, "EXIT0", vars, transition, stateVars);
            }
        }
        this.out.flush();
    }

    protected void printVar(VarInfo var) {
        this.out.println(String.valueOf(var.parent) + this.safeVarName(var.sort, var.name, var.sort instanceof DaikonSort));
        this.out.println(this.declType(var.sort, var));
        this.out.print(this.repType(var.sort));
        if (var.value != null) {
            this.out.println(" = " + var.value.hashCode());
        } else {
            this.out.println();
        }
        this.out.println(this.lackwitType(var.sort));
    }

    protected void printTransitionDecl(Transition transition, String type, List vars, Object key, Set stateVars) {
        this.out.println("");
        this.out.println("DECLARE");
        this.out.println(this.getPointFormat(transition, type));
        for (SimVariable simVar : vars) {
            boolean isParam = !stateVars.contains(simVar);
            VarInfo var = new VarInfo(simVar.getSort(), simVar.getName(), (String)this.listener.getNameBases().get(simVar), null, key, simVar, "", isParam);
            this.printVarRecurse(var);
        }
        for (SimVariable simVar : this.listener.getConstants()) {
            VarInfo var = new VarInfo(simVar.getSort(), String.valueOf(simVar.getName()) + ":" + simVar.getSort().getName(), "", simVar.value, key, simVar, "", false);
            this.printVarRecurse(var);
        }
    }

    private String declType(Sort sort, VarInfo var) {
        DaikonType type;
        String typeInfo = var.typeInfo;
        if (var.isParam) {
            typeInfo = String.valueOf(typeInfo) + ", isParam=true";
        }
        if (DaikonType.isArray(type = DaikonType.getType(sort))) {
            if (type == DaikonType.ARRAY_BOOLEAN) {
                return "boolean[] # nullTerminating=false, hasNull=false" + typeInfo;
            }
            if (sort.getName().equalsIgnoreCase("set")) {
                Vector oldSubSorts = sort.getSubsorts();
                Vector<DaikonSort> newSubSorts = new Vector<DaikonSort>(oldSubSorts);
                newSubSorts.add(0, new DaikonSort("Int", new Vector()));
                Sort rangeSort = DaikonType.getArrayRangeSort(sort);
                String result = String.valueOf(this.safeSortName(rangeSort)) + "[]" + standardAppends + typeInfo;
                return String.valueOf(result) + ", hasDuplicates=false, hasOrder=false, hasSize=true, " + "collectionType=list, indexType=\"\", valueType=\"" + rangeSort.toString() + "\"";
            }
            Sort rangeSort = DaikonType.getArrayRangeSort(sort);
            Sort domainSort = DaikonType.getArrayDomainSort(sort);
            typeInfo = String.valueOf(typeInfo) + ", collectionType=map, indexType=\"" + domainSort.toString() + "\", valueType=\"" + rangeSort.toString() + "\"";
            String result = String.valueOf(this.safeSortName(rangeSort)) + "[]" + standardAppends + ", hasSize=false" + typeInfo;
            if (domainSort.getName().equalsIgnoreCase("null")) {
                result = String.valueOf(result) + ", hasNull=true";
            }
            return result;
        }
        String result = String.valueOf(this.safeSortName(sort)) + standardAppends + typeInfo;
        if (sort.getName().equalsIgnoreCase("null")) {
            result = String.valueOf(result) + ", hasNull=true";
        }
        return result;
    }

    private String repType(Sort sort) {
        DaikonType type = DaikonType.getType(sort);
        return type.getRep();
    }

    private String lackwitType(Sort sort) {
        if (DaikonType.isArray(sort)) {
            Sort domainSort = DaikonType.getArrayDomainSort(sort);
            Sort rangeSort = DaikonType.getArrayRangeSort(sort);
            String rangeSortString = String.valueOf(rangeSort.toString().hashCode());
            String domainSortString = String.valueOf(domainSort.toString().hashCode());
            return String.valueOf(rangeSortString) + "[" + domainSortString + "]";
        }
        String stringForm = String.valueOf(sort.toString().hashCode());
        return stringForm;
    }
}

