/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.daikon;

import com.veromodo.tioa.il.nodes.BasicSort;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.simulator.daikon.DaikonSort;
import java.util.Vector;

class DaikonType {
    private String representation;
    public static final DaikonType NUMERIC = new DaikonType("int");
    public static final DaikonType BOOLEAN = new DaikonType("boolean");
    public static final DaikonType HASHCODE = new DaikonType("hashcode");
    public static final DaikonType STRING = new DaikonType("java.lang.String");
    public static final DaikonType ARRAY_NUMERIC = new DaikonType("int[]");
    public static final DaikonType ARRAY_BOOLEAN = new DaikonType("boolean[]");
    public static final DaikonType ARRAY_STRING = new DaikonType("java.lang.String[]");
    public static final DaikonType ARRAY_HASHCODE = new DaikonType("hashcode[]");

    private DaikonType(String arg) {
        this.representation = arg;
    }

    public static Sort getArrayDomainSort(Sort sort) {
        if (!DaikonType.isArray(sort)) {
            new RuntimeException("The sort " + sort + " is not an array sort");
        }
        Vector subs = sort.getSubsorts();
        if (sort.getName().equalsIgnoreCase("Array")) {
            return (Sort)subs.get(0);
        }
        DaikonSort result = new DaikonSort("Int", new Vector());
        return result;
    }

    public static Sort getArrayRangeSort(Sort sort) {
        if (!DaikonType.isArray(sort)) {
            new RuntimeException("The sort " + sort + " is not an array sort");
        }
        Vector subs = sort.getSubsorts();
        if (sort.getName().equalsIgnoreCase("Array")) {
            return (Sort)subs.get(1);
        }
        if (sort.getName().equalsIgnoreCase("Set") || sort.getName().equalsIgnoreCase("Stack")) {
            return (Sort)subs.get(0);
        }
        throw new RuntimeException("The sort " + sort + " is not an array sort");
    }

    public static DaikonType getType(Sort sort) {
        Vector subs = sort.getSubsorts();
        String sortName = sort instanceof BasicSort ? sort.getName() : sort.toString();
        if (sortName.equalsIgnoreCase("int") || sortName.equalsIgnoreCase("nat")) {
            return NUMERIC;
        }
        if (sortName.equalsIgnoreCase("bool")) {
            return BOOLEAN;
        }
        if (sortName.equalsIgnoreCase("string")) {
            return STRING;
        }
        if (sort.getSubsorts().size() == 2 && sortName.equalsIgnoreCase("Array")) {
            Sort elemType = (Sort)subs.elementAt(0);
            if (DaikonType.getType(elemType) == NUMERIC) {
                elemType = (Sort)subs.elementAt(1);
                DaikonType elemTypeType = DaikonType.getType(elemType);
                if (elemTypeType == NUMERIC) {
                    return ARRAY_NUMERIC;
                }
                if (elemTypeType == BOOLEAN) {
                    return ARRAY_BOOLEAN;
                }
                if (elemTypeType == STRING) {
                    return ARRAY_STRING;
                }
                return ARRAY_HASHCODE;
            }
            return HASHCODE;
        }
        if (sort.getSubsorts().size() == 1 && (sortName.equalsIgnoreCase("Set") || sortName.equalsIgnoreCase("Stack"))) {
            Sort elemType = (Sort)subs.elementAt(0);
            DaikonType elemTypeType = DaikonType.getType(elemType);
            if (elemTypeType == NUMERIC) {
                return ARRAY_NUMERIC;
            }
            if (elemTypeType == BOOLEAN) {
                return ARRAY_BOOLEAN;
            }
            if (elemTypeType == STRING) {
                return ARRAY_STRING;
            }
            return ARRAY_HASHCODE;
        }
        return HASHCODE;
    }

    public static boolean isArray(Sort sort) {
        return DaikonType.isArray(DaikonType.getType(sort));
    }

    public static boolean isArray(DaikonType type) {
        return type == ARRAY_STRING || type == ARRAY_NUMERIC || type == ARRAY_BOOLEAN || type == ARRAY_HASHCODE;
    }

    public static boolean isArraySort(Sort sort) {
        return sort.getName().equalsIgnoreCase("Array");
    }

    public String toString() {
        return this.representation;
    }

    public String getRep() {
        return this.representation;
    }
}

