/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.daikon;

import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.ArraySort;
import com.veromodo.tioa.runtime.adt.IntSort;
import com.veromodo.tioa.runtime.adt.NullSort;
import com.veromodo.tioa.runtime.adt.SetSort;
import com.veromodo.tioa.runtime.adt.StackSort;
import com.veromodo.tioa.runtime.adt.TupleSort;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.simulator.daikon.DaikonListener;
import com.veromodo.tioa.simulator.daikon.DaikonSort;
import com.veromodo.tioa.simulator.daikon.DaikonType;
import com.veromodo.tioa.simulator.daikon.VarInfo;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.CollectionsUtils;
import com.veromodo.tioa.util.logger.IOACategory;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

abstract class DaikonPrinter {
    private static final IOACategory debug = IOACategory.getInstance((String)DaikonPrinter.class.getName());
    public static final String EXIT = "EXIT0";
    public static final String ENTER = "ENTER";
    public static final String OBJECT = "CLASS";
    protected PrintWriter out;
    protected Simulator sim;
    protected DaikonListener listener;
    static /* synthetic */ Class class$0;

    protected DaikonPrinter(PrintWriter out, Simulator sim, DaikonListener listener) {
        this.out = out;
        this.sim = sim;
        this.listener = listener;
    }

    protected abstract void printVar(VarInfo var1);

    protected void printVarRecurse(VarInfo var) {
        if (this.listener.getProperties().getFlag("tioa.simulator.daikon.exclude." + var.name)) {
            return;
        }
        this.printVar(var);
        this.printVarRecurseBasics(var);
        if (DaikonType.isArray(var.sort)) {
            this.printVarRecurseArrayTuple(var);
            this.printVarRecurseArrayNull(var);
        } else if (DaikonType.isArraySort(var.sort)) {
            this.printVarRecurseArraySampling(var);
            this.printVarRecurseArraySlicing(var);
            this.printVarRecurseArrayFiniteEnumerating(var);
            this.printVarRecurseArrayIndexing(var);
        }
    }

    private void printVarRecurseBasics(VarInfo var) {
        if (var.sort.isTuple()) {
            TupleSort tup = null;
            if (var.value instanceof TupleSort) {
                tup = (TupleSort)var.value;
            }
            Vector fieldNames = var.sort.getFieldNames();
            Vector fieldSorts = var.sort.getFieldSorts();
            Iterator i = fieldNames.iterator();
            Iterator j = fieldSorts.iterator();
            while (i.hasNext()) {
                String fieldName = (String)i.next();
                VarInfo newVar = new VarInfo(var);
                newVar.sort = (Sort)j.next();
                newVar.name = fieldName;
                newVar.parent = String.valueOf(var.parent) + var.name + ".";
                newVar.value = tup != null ? TupleSort.lookupField(fieldName, tup) : null;
                this.printVarRecurse(newVar);
            }
        }
        if (var.sort.getName().equalsIgnoreCase("Null")) {
            Vector subsorts = var.sort.getSubsorts();
            Sort underlyingSort = (Sort)subsorts.get(0);
            Entity underlyingVal = null;
            if (var.value != null) {
                NullSort nullValue = (NullSort)var.value;
                underlyingVal = nullValue.equals(NullSort.nil()) ? null : (Entity)NullSort.val(nullValue);
            }
            VarInfo newVar = new VarInfo(var);
            newVar.sort = underlyingSort;
            newVar.name = String.valueOf(newVar.name) + ".val";
            newVar.value = underlyingVal;
            this.printVarRecurse(newVar);
        }
    }

    private void printVarRecurseArrayIndexing(VarInfo var) {
        if (!this.listener.getProperties().getFlag("tioa.simulator.daikon.arrayIndexing")) {
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("arrayIndex handling " + var.parent + var.name));
        }
        Sort domainSort = DaikonType.getArrayDomainSort(var.sort);
        Sort rangeSort = DaikonType.getArrayRangeSort(var.sort);
        List vars = (List)this.listener.getVariables().get(var.transitionKey);
        for (SimVariable simVar : vars) {
            Sort varSort = simVar.getSort();
            if (domainSort != varSort) continue;
            Entity itemValue = var.value == null ? null : (Entity)ArraySort.elementAt((ArraySort)var.value, (ADT)simVar.value);
            Object newAuxInfo = var.modInfo;
            if (newAuxInfo instanceof SimVariable && simVar.modified) {
                newAuxInfo = null;
            }
            VarInfo newVar = new VarInfo(var);
            newVar.sort = rangeSort;
            newVar.name = String.valueOf(var.name) + "[" + var.parent + simVar.getName() + "]";
            newVar.value = itemValue;
            newVar.modInfo = newAuxInfo;
            newVar.isParam = false;
            if (debug.isDebugEnabled()) {
                debug.debug((Object)("  var name: " + simVar.getName()));
            }
            this.printVarRecurse(newVar);
        }
    }

    private void printVarRecurseArraySampling(VarInfo var) {
        if (!this.listener.getProperties().getFlag("tioa.simulator.daikon.arraySampling")) {
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("array sample handling " + var.parent + var.name));
        }
        Sort domainSort = DaikonType.getArrayDomainSort(var.sort);
        Sort rangeSort = DaikonType.getArrayRangeSort(var.sort);
        String sampledVarName = "anIndex:" + domainSort.getName();
        String sampledVarName2 = "anotherIndex:" + domainSort.getName();
        Entity itemValue = null;
        Entity itemValue2 = null;
        if (var.value != null) {
            Object itemIndex2;
            Object itemIndex;
            ArraySort array = (ArraySort)var.value;
            Map sampleValues = this.listener.getSampleValues();
            if (sampleValues.get(var.sort) == null) {
                Map theMap = array.getMap();
                Set keySet = theMap.keySet();
                itemIndex = DaikonPrinter.getRandomElt(keySet, null);
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("Getting new index for " + var.sort + " name: " + var.parent + var.name));
                    debug.debug((Object)("  value is: " + itemIndex));
                }
                if (itemIndex == null) {
                    itemIndex = this;
                }
                itemValue = (Entity)ArraySort.elementAt(array, (ADT)itemIndex);
                sampleValues.put(var.sort, itemIndex);
            } else {
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("Getting old index for " + var.sort + " " + var.parent + var.name));
                }
                itemIndex = sampleValues.get(var.sort);
                itemValue = (Entity)ArraySort.elementAt(array, itemIndex);
            }
            Map sampleValues2 = this.listener.getSampleValues2();
            if (sampleValues2.get(var.sort) == null) {
                Map theMap = array.getMap();
                Set keySet = theMap.keySet();
                itemIndex2 = DaikonPrinter.getRandomElt(keySet, itemIndex);
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("Getting new index for " + var.sort + " name: " + var.parent + var.name));
                    debug.debug((Object)("  value is: " + itemIndex2));
                }
                if (itemIndex2 == null) {
                    itemIndex2 = this;
                }
                Assert.assertTrue(itemIndex != itemIndex2 || itemIndex2 == this);
                itemValue2 = (Entity)ArraySort.elementAt(array, itemIndex2);
                sampleValues2.put(var.sort, itemIndex2);
            } else {
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("Getting old index for " + var.sort + " " + var.parent + var.name));
                }
                itemIndex2 = sampleValues2.get(var.sort);
                itemValue2 = (Entity)ArraySort.elementAt(array, itemIndex2);
            }
        }
        VarInfo newVar = new VarInfo(var);
        newVar.sort = rangeSort;
        newVar.name = String.valueOf(var.name) + "[" + var.parent + sampledVarName + "]";
        newVar.value = itemValue;
        this.printVarRecurse(newVar);
        VarInfo newVar2 = new VarInfo(newVar);
        newVar2.name = String.valueOf(var.name) + "[" + var.parent + sampledVarName2 + "]";
        newVar2.value = itemValue2;
        this.printVarRecurse(newVar2);
    }

    private void printVarRecurseArrayFiniteEnumerating(VarInfo var) {
        if (!this.listener.getProperties().getFlag("tioa.simulator.daikon.arrayEnumerating")) {
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("array enumeration handling " + var.parent + var.name));
        }
        Sort domainSort = DaikonType.getArrayDomainSort(var.sort);
        Sort rangeSort = DaikonType.getArrayRangeSort(var.sort);
        if (!domainSort.isEnum()) {
            debug.debug((Object)("  handling not needed for type: " + domainSort.getName()));
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)"  handling is desired");
        }
        Vector newVarInfos = new Vector();
        ArraySort array = (ArraySort)var.value;
        HashMap<String, Object> namesToValues = new HashMap<String, Object>();
        if (array != null) {
            Iterator iValues = CollectionsUtils.enumToIter(array.enumIndices());
            while (iValues.hasNext()) {
                Object domainVal = iValues.next();
                String domainValName = domainVal.toString();
                Object rangeVal = ArraySort.elementAt(array, domainVal);
                namesToValues.put(domainValName, rangeVal);
            }
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("Domains map is: " + namesToValues));
        }
        for (String eltName : domainSort.getEnumEltNames()) {
            VarInfo newVarInfo = new VarInfo(var);
            newVarInfo.sort = rangeSort;
            newVarInfo.name = String.valueOf(var.name) + "[" + eltName + "]";
            if (array != null) {
                Entity newValue = (Entity)namesToValues.get(eltName);
                if (newValue == null) {
                    newValue = (Entity)ArraySort.elementAt(array, this);
                }
                Assert.assertTrue(newValue != null);
                newVarInfo.value = newValue;
            }
            this.printVarRecurse(newVarInfo);
        }
    }

    private void printVarRecurseArraySlicing(VarInfo var) {
        if (!this.listener.getProperties().getFlag("tioa.simulator.daikon.arraySlicing")) {
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("array split handling " + var.parent + var.name));
        }
        Sort domainSort = DaikonType.getArrayDomainSort(var.sort);
        Sort rangeSort = DaikonType.getArrayRangeSort(var.sort);
        DaikonSort newDomainSort = new DaikonSort("Int", new Vector());
        Vector<DaikonSort> subSorts1 = new Vector<DaikonSort>();
        Vector<DaikonSort> subSorts2 = new Vector<DaikonSort>();
        subSorts1.add(new DaikonSort("Int", new Vector()));
        subSorts2.add(new DaikonSort("Int", new Vector()));
        subSorts1.add((DaikonSort)domainSort);
        subSorts2.add((DaikonSort)rangeSort);
        DaikonSort newSort1 = new DaikonSort("Array", subSorts1);
        DaikonSort newSort2 = new DaikonSort("Array", subSorts2);
        ArraySort itemValue1 = null;
        ArraySort itemValue2 = null;
        if (var.value != null) {
            ArraySort array = (ArraySort)var.value;
            itemValue2 = ArraySort.constant((ADT)ArraySort.elementAt(array, this));
            int keyCtr = 0;
            Iterator iValues = CollectionsUtils.enumToIter(array.enumIndices());
            while (iValues.hasNext()) {
                Object domainVal = iValues.next();
                Object rangeVal = ArraySort.elementAt(array, domainVal);
                if (itemValue1 == null) {
                    itemValue1 = ArraySort.constant((ADT)domainVal);
                }
                itemValue1 = ArraySort.assign(itemValue1, IntSort.lit(keyCtr), (ADT)domainVal);
                itemValue2 = ArraySort.assign(itemValue2, IntSort.lit(keyCtr), (ADT)rangeVal);
                ++keyCtr;
            }
            if (itemValue1 == null) {
                itemValue1 = ArraySort.constant(IntSort.lit(0.0));
            }
        }
        VarInfo newVarIndices = new VarInfo(var);
        newVarIndices.sort = newSort1;
        newVarIndices.name = String.valueOf(var.name) + "[].indices";
        newVarIndices.value = itemValue1;
        newVarIndices.typeInfo = String.valueOf(newVarIndices.typeInfo) + ", allOfType=true";
        VarInfo newVarValues = new VarInfo(var);
        newVarValues.sort = newSort2;
        newVarValues.name = String.valueOf(var.name) + "[].values";
        newVarValues.value = itemValue2;
        this.printVarRecurse(newVarValues);
    }

    private void printVarRecurseArrayNull(VarInfo var) {
        Sort rangeSort = DaikonType.getArrayRangeSort(var.sort);
        if (!this.listener.getProperties().getFlag("tioa.simulator.daikon.arrayNull")) {
            return;
        }
        if (!rangeSort.getName().equalsIgnoreCase("null")) {
            return;
        }
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("arrayNull handling " + var.parent + var.name));
        }
        DaikonSort newDomainSort = new DaikonSort("Int", new Vector());
        Vector<DaikonSort> subSorts = new Vector<DaikonSort>();
        subSorts.add(new DaikonSort("Int", new Vector()));
        subSorts.addAll(rangeSort.getSubsorts());
        DaikonSort newSort = new DaikonSort("Array", subSorts);
        ArraySort itemValue = null;
        if (var.value != null) {
            ArraySort array = (ArraySort)var.value;
            int keyCtr = 0;
            Iterator iValues = CollectionsUtils.enumToIter(array.enumIndices());
            while (iValues.hasNext()) {
                Object domainVal = iValues.next();
                NullSort rangeVal = (NullSort)ArraySort.elementAt(array, domainVal);
                if (rangeVal.equals(NullSort.nil())) continue;
                Object rangeValVal = NullSort.val(rangeVal);
                if (itemValue == null) {
                    itemValue = ArraySort.constant((ADT)rangeValVal);
                }
                itemValue = ArraySort.assign(itemValue, IntSort.lit(keyCtr), (ADT)rangeValVal);
                ++keyCtr;
            }
            if (itemValue == null) {
                itemValue = ArraySort.constant(IntSort.lit(0.0));
            }
        }
        VarInfo newVar = new VarInfo(var);
        newVar.sort = newSort;
        newVar.name = String.valueOf(var.name) + (var.sort instanceof DaikonSort ? "" : "[]") + ".val(nonNull)";
        newVar.value = itemValue;
        this.printVarRecurse(newVar);
    }

    private void printVarRecurseArrayTuple(VarInfo var) {
        Sort rangeSort = DaikonType.getArrayRangeSort(var.sort);
        if (debug.isDebugEnabled()) {
            debug.debug((Object)("Range Sort for arrayTuple: " + rangeSort));
        }
        if (this.listener.getProperties().getFlag("tioa.simulator.daikon.arrayTuples") && !this.listener.getProperties().getFlag("tioa.simulator.daikon.exclude.arrayTuples" + var.name) && rangeSort.isTuple() && rangeSort.getFieldNames().size() >= 2) {
            if (debug.isDebugEnabled()) {
                debug.debug((Object)("arrayTuple handling " + var.parent + var.name));
            }
            Vector fieldNames = rangeSort.getFieldNames();
            Vector fieldSorts = rangeSort.getFieldSorts();
            Iterator i = fieldNames.iterator();
            Iterator j = fieldSorts.iterator();
            while (i.hasNext()) {
                ArraySort arraySort;
                Object k;
                String fieldName = (String)i.next();
                Sort fieldSort = (Sort)j.next();
                Vector<DaikonSort> subSorts = new Vector<DaikonSort>();
                subSorts.add(new DaikonSort("Int", new Vector()));
                subSorts.add((DaikonSort)fieldSort);
                DaikonSort daikonSort = new DaikonSort("Array", subSorts);
                if (var.value instanceof ArraySort) {
                    ArraySort valueArray = (ArraySort)var.value;
                    ArraySort arraySort2 = new ArraySort(IntSort.lit(2.147483647E9));
                    k = valueArray.enumIndices();
                    while (k.hasMoreElements()) {
                        Object index = k.nextElement();
                        TupleSort arrayTup = (TupleSort)ArraySort.elementAt(valueArray, index);
                        arraySort2 = ArraySort.assign(arraySort2, index, TupleSort.lookupField(fieldName, arrayTup));
                    }
                    VarInfo newVar = new VarInfo(var);
                    newVar.sort = daikonSort;
                    newVar.name = fieldName;
                    newVar.parent = String.valueOf(var.parent) + var.name + (var.sort instanceof DaikonSort ? "" : "[]") + ".";
                    newVar.value = arraySort2;
                    this.printVarRecurse(newVar);
                    continue;
                }
                if (var.value instanceof SetSort) {
                    arraySort = new ArraySort(IntSort.lit(2.147483647E9));
                    SetSort valueSet = (SetSort)var.value;
                    Set set = valueSet.getSet();
                    Iterator k2 = set.iterator();
                    int l = 0;
                    while (k2.hasNext()) {
                        TupleSort setTup = (TupleSort)k2.next();
                        arraySort = ArraySort.assign(arraySort, IntSort.lit(l), TupleSort.lookupField(fieldName, setTup));
                        ++l;
                    }
                    VarInfo newVar = new VarInfo(var);
                    newVar.sort = daikonSort;
                    newVar.name = fieldName;
                    newVar.parent = String.valueOf(var.parent) + var.name + (var.sort instanceof DaikonSort ? "" : "[]") + ".";
                    newVar.value = arraySort;
                    this.printVarRecurse(newVar);
                    continue;
                }
                if (var.value instanceof StackSort) {
                    arraySort = new ArraySort(IntSort.lit(2.147483647E9));
                    StackSort valueStack = (StackSort)var.value;
                    k = valueStack.toList().iterator();
                    int l = 0;
                    while (k.hasNext()) {
                        TupleSort setTup = (TupleSort)k.next();
                        arraySort = ArraySort.assign(arraySort, IntSort.lit(l), TupleSort.lookupField(fieldName, setTup));
                        ++l;
                    }
                    VarInfo newVar = new VarInfo(var);
                    newVar.sort = daikonSort;
                    newVar.name = fieldName;
                    newVar.parent = String.valueOf(var.parent) + var.name + (var.sort instanceof DaikonSort ? "" : "[]") + ".";
                    newVar.value = arraySort;
                    this.printVarRecurse(newVar);
                    continue;
                }
                VarInfo newVar = new VarInfo(var);
                newVar.sort = daikonSort;
                newVar.name = fieldName;
                newVar.parent = String.valueOf(var.parent) + var.name + (var.sort instanceof DaikonSort ? "" : "[]") + ".";
                newVar.value = null;
                this.printVarRecurse(newVar);
            }
        }
    }

    protected String safeVarName(Sort sort, String name, boolean alreadyIsArray) {
        if (DaikonType.isArray(sort) && !(sort instanceof DaikonSort)) {
            return String.valueOf(name) + "[]";
        }
        return name;
    }

    protected String safeSortName(Sort sort) {
        return sort.toString().replace('[', '(').replace(']', ')');
    }

    protected String getPointFormat(Transition transition, String type) {
        String autName;
        String retval = autName = this.sim.getAutomaton().getName();
        if (transition != null) {
            Action action = transition.getAction();
            String actionName = action.getName();
            retval = String.valueOf(retval) + "." + actionName + "(";
            Iterator i = action.getFormals().iterator();
            while (i.hasNext()) {
                String paramName = ((VarRefTerm)i.next()).getRefVariable().getName();
                retval = String.valueOf(retval) + paramName + (i.hasNext() ? ", " : "");
            }
            retval = String.valueOf(retval) + ")";
        }
        retval = String.valueOf(retval) + ":::" + type;
        return retval;
    }

    private static Object getRandomElt(Set s, Object o) {
        ArrayList l = new ArrayList(s);
        int size = l.size();
        if (size == 0) {
            return null;
        }
        if ((size -= o == null ? 0 : 1) == 0) {
            return null;
        }
        int elt = DaikonListener.rnd.nextInt(size);
        if (l.get(elt) == o) {
            ++elt;
        }
        return l.get(elt);
    }
}

