/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.simulator.daikon;

import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.SymbolTable;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.runtime.adt.EnumSort;
import com.veromodo.tioa.simulator.daikon.DeclsPrinter;
import com.veromodo.tioa.simulator.daikon.DtracePrinter;
import com.veromodo.tioa.simulator.daikon.SplitterWriter;
import com.veromodo.tioa.simulator.exec.ActualTransition;
import com.veromodo.tioa.simulator.exec.Simulator;
import com.veromodo.tioa.simulator.nodes.ActualAutInterface;
import com.veromodo.tioa.simulator.nodes.SimAutomaton;
import com.veromodo.tioa.simulator.nodes.SimVariable;
import com.veromodo.tioa.simulator.shell.BasicListener;
import com.veromodo.tioa.simulator.ui.BeginStepEvent;
import com.veromodo.tioa.simulator.ui.EndStepEvent;
import com.veromodo.tioa.simulator.ui.ExecEndedEvent;
import com.veromodo.tioa.simulator.ui.InitializedEvent;
import com.veromodo.tioa.simulator.ui.SimEvent;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.CollectionsUtils;
import com.veromodo.tioa.util.IOAProperties;
import com.veromodo.tioa.util.ToStringComparator;
import com.veromodo.tioa.util.logger.IOACategory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class DaikonListener
extends BasicListener {
    private static final IOACategory cat = IOACategory.getInstance((String)DaikonListener.class.getName());
    static Random rnd = new Random();
    private String declsFileName;
    private String dtraceFileName;
    private String spinfoFileName;
    protected FileOutputStream dtraceFile;
    protected FileOutputStream declFile;
    protected FileOutputStream spinfoFile;
    protected DtracePrinter dtrace;
    protected SplitterWriter split;
    protected DeclsPrinter decls;
    protected Map variables;
    protected Map nameBases;
    protected Map sampleValues;
    protected Map sampleValues2;
    protected Set constants;
    protected SymbolTable sym;
    IOAProperties properties = new IOAProperties(System.getProperties());
    private boolean ignoringFirst;
    public static final String propertyBase = "tioa.simulator.daikon.";
    public static final String propertyBaseExclude = "tioa.simulator.daikon.exclude.";
    public static final String propertyBaseExcludeArrayTuple = "tioa.simulator.daikon.exclude.arrayTuples";
    static /* synthetic */ Class class$0;

    public DaikonListener(Simulator sim, SymbolTable sym) {
        super(sim);
        cat.debug((Object)this.properties);
        this.declsFileName = this.properties.getProperty("tioa.util.shell.outDecls");
        this.dtraceFileName = this.properties.getProperty("tioa.util.shell.outDtrace");
        this.spinfoFileName = this.properties.getProperty("tioa.util.shell.outSpinfo");
        Assert.assertTrue(this.declsFileName != null);
        Assert.assertTrue(this.dtraceFileName != null);
        Assert.assertTrue(this.spinfoFileName != null);
        this.sym = sym;
        this.declFile = null;
        this.dtraceFile = null;
        this.spinfoFile = null;
        this.dtrace = null;
        this.decls = null;
        this.ignoringFirst = false;
        this.variables = new TreeMap(new ToStringComparator());
        this.nameBases = new HashMap();
        this.sampleValues = new HashMap();
        this.sampleValues2 = new HashMap();
        this.constants = new HashSet();
        if (this.properties.getFlag("tioa.util.shell.daikonIgnoreFirst")) {
            cat.debug((Object)"Ignoring first");
            this.ignoringFirst = true;
        }
        if (this.properties.getProperty("tioa.simulator.daikon.printSteps") == null || this.properties.getProperty("tioa.simulator.daikon.printSteps") == " ") {
            this.properties.setFlag("tioa.simulator.daikon.printSteps", true);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.arrayIndexing") == null || this.properties.getProperty("tioa.simulator.daikon.arrayIndexing") == "") {
            this.properties.setFlag("tioa.simulator.daikon.arrayIndexing", true);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.arrayTuples") == null || this.properties.getProperty("tioa.simulator.daikon.arrayTuples") == "") {
            this.properties.setFlag("tioa.simulator.daikon.arrayTuples", true);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.arrayNull") == null || this.properties.getProperty("tioa.simulator.daikon.arrayNull") == "") {
            this.properties.setFlag("tioa.simulator.daikon.arrayNull", true);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.arraySlicing") == null || this.properties.getProperty("tioa.simulator.daikon.arraySlicing") == "") {
            this.properties.setFlag("tioa.simulator.daikon.arraySlicing", true);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.arrayEnumerating") == null || this.properties.getProperty("tioa.simulator.daikon.arrayEnumerating") == "") {
            this.properties.setFlag("tioa.simulator.daikon.arrayEnumerating", true);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.arraySampling") == null || this.properties.getProperty("tioa.simulator.daikon.arraySampling") == "") {
            this.properties.setFlag("tioa.simulator.daikon.arraySampling", true);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.ignoreFirst") == null || this.properties.getProperty("tioa.simulator.daikon.ignoreFirst") == "") {
            this.properties.setFlag("tioa.simulator.daikon.ignoreFirst", false);
        }
        if (this.properties.getProperty("tioa.simulator.daikon.doSplit") == null || this.properties.getProperty("tioa.simulator.daikon.doSplit") == "") {
            this.properties.setFlag("tioa.simulator.daikon.doSplit", false);
        }
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("Init with properties " + this.properties));
        }
        this.initVariables();
    }

    public static void setSeed(long seed) {
        rnd = new Random(seed);
    }

    protected void initVariables() {
        ArrayList<SimVariable> globalVars = new ArrayList<SimVariable>();
        ActualAutInterface actualAut = this.getSimulator().getAutomaton();
        SimAutomaton ilAut = actualAut.getSimAutomaton();
        Iterator iVars = CollectionsUtils.enumToIter(actualAut.enumVariables());
        while (iVars.hasNext()) {
            SimVariable var = (SimVariable)iVars.next();
            globalVars.add(var);
            this.nameBases.put(var, "");
        }
        this.variables.put("CLASS", globalVars);
        ActionTable atable = ilAut.getActionTable();
        Iterator iTransitions = CollectionsUtils.enumToIter(atable.enumTransitions());
        while (iTransitions.hasNext()) {
            ArrayList<SimVariable> vars = new ArrayList<SimVariable>();
            vars.addAll(globalVars);
            Transition transition = (Transition)iTransitions.next();
            for (VarRefTerm varRefTerm : transition.getAction().getFormals()) {
                vars.add((SimVariable)varRefTerm.getRefVariable());
                this.nameBases.put(varRefTerm.getRefVariable(), "");
            }
            this.variables.put(transition, vars);
        }
        Iterator iSorts = CollectionsUtils.enumToIter(this.sym.enumSorts());
        while (iSorts.hasNext()) {
            Sort sort = (Sort)iSorts.next();
            if (!sort.isEnum()) continue;
            Vector v = sort.getEnumEltNames();
            Iterator ieNames = v.iterator();
            String values = "";
            while (ieNames.hasNext()) {
                values = String.valueOf(values) + (String)ieNames.next() + "%";
            }
            values = values.trim();
            for (String value : v) {
                EnumSort enumValue = EnumSort.construct(values, value);
                SimVariable enumVariable = new SimVariable("noID", value, sort, null);
                enumVariable.assign(null, enumValue);
                this.constants.add(enumVariable);
            }
        }
    }

    public Map getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public Map getSampleValues() {
        return this.sampleValues;
    }

    public Map getSampleValues2() {
        return this.sampleValues2;
    }

    public boolean handleSimEvent(SimEvent ev) {
        cat.debug((Object)("Received event " + ev));
        if (ev instanceof InitializedEvent) {
            this.initEvent();
        } else if (ev instanceof BeginStepEvent) {
            if (!this.ignoringFirst) {
                ActualTransition transition = (ActualTransition)((BeginStepEvent)ev).getStep();
                this.transitionEnterEvent(transition.getTransition().getAction().getName(), transition);
            }
        } else if (ev instanceof EndStepEvent) {
            if (!this.ignoringFirst) {
                ActualTransition transition = (ActualTransition)((EndStepEvent)ev).getStep();
                this.transitionExitEvent(transition.getTransition().getAction().getName(), transition);
            }
            this.ignoringFirst = false;
        } else if (ev instanceof ExecEndedEvent) {
            this.closeFiles();
        } else {
            cat.debug((Object)("Nothing to do: " + ev));
        }
        return super.handleSimEvent(ev);
    }

    private void initEvent() {
        this.openFiles();
        this.decls.print();
        if (this.split != null) {
            this.split.print();
        }
        if (!this.ignoringFirst) {
            this.dtrace.print("CLASS", "", null);
        }
    }

    private void transitionEnterEvent(String transitionName, ActualTransition transition) {
        this.sampleValues = new HashMap();
        this.sampleValues2 = new HashMap();
        if (this.properties.getFlag("tioa.simulator.daikon.printSteps")) {
            this.dtrace.print("ENTER", transitionName, transition);
        }
    }

    private void transitionExitEvent(String transitionName, ActualTransition transition) {
        if (this.properties.getFlag("tioa.simulator.daikon.printSteps")) {
            this.dtrace.print("EXIT0", transitionName, transition);
        }
        this.dtrace.print("CLASS", "", null);
    }

    private void openFiles() {
        cat.debug((Object)"Opening files");
        try {
            this.dtraceFile = new FileOutputStream(new File(this.dtraceFileName));
            this.declFile = new FileOutputStream(new File(this.declsFileName));
            if (this.properties.getFlag("tioa.simulator.daikon.doSplit")) {
                this.spinfoFile = new FileOutputStream(new File(this.spinfoFileName));
            }
        }
        catch (IOException e) {
            cat.error((Object)"Error in opening trace files", (Throwable)e);
        }
        this.decls = new DeclsPrinter(new PrintWriter(this.declFile), this.getSimulator(), this);
        this.dtrace = new DtracePrinter(new PrintWriter(this.dtraceFile), this.getSimulator(), this);
        if (this.spinfoFile != null) {
            this.split = new SplitterWriter(new PrintWriter(this.spinfoFile), this.getSimulator(), this);
        }
    }

    private void closeFiles() {
        try {
            this.dtraceFile.flush();
            this.dtraceFile.close();
            if (this.spinfoFile != null) {
                this.spinfoFile.close();
            }
            this.declFile.close();
            this.declFile = null;
            this.dtraceFile = null;
            this.decls = null;
            this.dtrace = null;
            this.spinfoFile = null;
            this.split = null;
        }
        catch (IOException e) {
            cat.error((Object)"Error in closing trace files", (Throwable)e);
        }
        cat.debug((Object)"Closed files");
    }

    public IOAProperties getProperties() {
        return this.properties;
    }

    public Map getNameBases() {
        return Collections.unmodifiableMap(this.nameBases);
    }

    public Set getConstants() {
        return Collections.unmodifiableSet(this.constants);
    }
}

