/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.io;

import com.veromodo.tioa.runtime.io.Debugger;

public class RoundRobinScheduler
extends Thread {
    public static final int SCHEDULER_PRIORITY = 6;
    public static final int RUN_PRIORITY = 4;
    public static final int HOLD_PRIORITY = 2;
    private CircularThreadList threads;
    private Thread current;
    private int timeslice;
    private static boolean initialized = false;
    private boolean needThreads;

    private static synchronized boolean isInitialized() {
        if (initialized) {
            return true;
        }
        initialized = true;
        return false;
    }

    public RoundRobinScheduler(int timeslice) {
        if (RoundRobinScheduler.isInitialized()) {
            throw new SecurityException("Already initialized");
        }
        this.threads = new CircularThreadList();
        this.timeslice = timeslice;
        this.setDaemon(true);
    }

    public synchronized void addThread(Thread t) {
        t.setPriority(2);
        this.threads.insert(t);
        if (this.needThreads) {
            this.needThreads = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(Thread t) {
        this.threads.delete(t);
        RoundRobinScheduler roundRobinScheduler = this;
        synchronized (roundRobinScheduler) {
            if (t == this.current) {
                this.current = null;
            }
        }
    }

    public synchronized void run() {
        this.setPriority(6);
        while (true) {
            this.current = this.threads.getNext();
            while (this.current == null) {
                this.needThreads = true;
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.current = this.threads.getNext();
            }
            Debugger.msg("RoundRobinScheduler::running thread " + this.current.getName());
            try {
                this.current.setPriority(4);
            }
            catch (Exception e) {
                Debugger.msg("RoundRobinScheduler::removing thread" + this.current.getName());
                this.removeThread(this.current);
                continue;
            }
            try {
                this.wait(this.timeslice);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Debugger.msg("RoundRobinScheduler::holding thread " + this.current.getName());
            if (this.current == null) continue;
            try {
                this.current.setPriority(2);
                continue;
            }
            catch (Exception e) {
                Debugger.msg("RoundRobinScheduler::removing thread " + this.current.getName());
                this.removeThread(this.current);
                continue;
            }
            break;
        }
    }

    private class CircularThreadList {
        private CircularThreadListNode current;

        CircularThreadList() {
        }

        public synchronized void insert(Thread t) {
            CircularThreadListNode node = new CircularThreadListNode();
            node.t = t;
            if (this.current == null) {
                node.next = node.prev = node;
                this.current = node;
            } else {
                node.next = this.current;
                node.prev = this.current.prev;
                node.prev.next = node;
                this.current.prev = node;
            }
        }

        public synchronized void delete(Thread t) {
            CircularThreadListNode p = this.find(t);
            CircularThreadListNode next = p.next;
            CircularThreadListNode prev = p.prev;
            if (p == p.next) {
                this.current = null;
                return;
            }
            prev.next = next;
            next.prev = prev;
            if (this.current == p) {
                this.current = next;
            }
        }

        private CircularThreadListNode find(Thread t) {
            CircularThreadListNode p = this.current;
            if (p == null) {
                throw new IllegalArgumentException();
            }
            do {
                if (p.t != t) continue;
                return p;
            } while ((p = p.next) != this.current);
            throw new IllegalArgumentException();
        }

        public synchronized Thread locate(Thread t) {
            CircularThreadListNode p = this.current;
            if (p == null) {
                throw new IllegalArgumentException();
            }
            do {
                if (!p.t.equals(t)) continue;
                return p.t;
            } while (p != this.current);
            throw new IllegalArgumentException();
        }

        public synchronized Thread getNext() {
            if (this.current == null) {
                return null;
            }
            this.current = this.current.next;
            return this.current.t;
        }

        private class CircularThreadListNode {
            Thread t;
            CircularThreadListNode next;
            CircularThreadListNode prev;

            CircularThreadListNode() {
            }
        }
    }
}

