/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.NotEnumerableException;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.TupleRepException;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TupleSort
extends ADT
implements Serializable {
    public static final String FIELD_DELIMITER = "%";
    private HashMap contents;
    private Vector fieldNames;

    private TupleSort() {
        this.contents = new HashMap(10);
        this.fieldNames = new Vector();
    }

    private TupleSort(TupleSort arg) {
        this.contents = (HashMap)arg.contents.clone();
        this.fieldNames = arg.fieldNames;
    }

    private Object getValue(String arg) {
        Object o = this.contents.get(arg);
        if (o == null) {
            throw new TupleRepException("Nonexistent field in tuple", this);
        }
        return o;
    }

    private void setValue(String key, Object obj) {
        this.contents.put(key, obj);
    }

    public static ADT construct(Parameterization p) {
        Object[] fieldNames = (Object[])p.getShorthandInfo()[0];
        String fieldNamesString = "";
        int i = 0;
        while (i < fieldNames.length) {
            fieldNamesString = String.valueOf(fieldNamesString) + (String)fieldNames[i];
            if (i < fieldNames.length - 1) {
                fieldNamesString = String.valueOf(fieldNamesString) + FIELD_DELIMITER;
            }
            ++i;
        }
        Object[] implClasses = (Object[])p.getShorthandInfo()[1];
        Object[] parameterizations = (Object[])p.getShorthandInfo()[2];
        Object[] fieldValues = new Object[fieldNames.length];
        int i2 = 0;
        while (i2 < implClasses.length) {
            Parameterization fieldParam = (Parameterization)parameterizations[i2];
            Class implClass = (Class)implClasses[i2];
            fieldValues[i2] = fieldParam.construct(implClass);
            ++i2;
        }
        return TupleSort.make(fieldNamesString, fieldValues);
    }

    public static ADT lookupField(String field, TupleSort tuple) {
        return (ADT)tuple.getValue(field);
    }

    public static TupleSort setField(String field, TupleSort tuple, Object newValue) {
        TupleSort result = new TupleSort(tuple);
        result.setValue(field, newValue);
        return result;
    }

    public static TupleSort make(String fieldNamesString, Object[] valuesArray) {
        Vector fieldNames = TupleSort.stringToVector(fieldNamesString);
        List<Object> values = Arrays.asList(valuesArray);
        if (fieldNames.size() != values.size()) {
            throw new TupleRepException("Number of initialization values not equal to number of fields");
        }
        TupleSort result = new TupleSort();
        Iterator i = fieldNames.iterator();
        Iterator<Object> j = values.iterator();
        while (i.hasNext()) {
            result.setValue((String)i.next(), j.next());
        }
        result.fieldNames = fieldNames;
        return result;
    }

    public static TupleSort makeOneArg(Object[] args) {
        String fieldNamesString = (String)args[0];
        Vector fieldNames = TupleSort.stringToVector(fieldNamesString);
        ArrayList values = new ArrayList(Arrays.asList(args));
        values.remove(0);
        if (fieldNames.size() != values.size()) {
            throw new TupleRepException("Number of initialization values not equal to number of fields");
        }
        TupleSort result = new TupleSort();
        Iterator i = fieldNames.iterator();
        Iterator j = values.iterator();
        while (i.hasNext()) {
            result.setValue((String)i.next(), j.next());
        }
        result.fieldNames = fieldNames;
        return result;
    }

    private static Vector stringToVector(String input) {
        StringTokenizer tk = new StringTokenizer(input, FIELD_DELIMITER);
        Vector<String> v = new Vector<String>();
        while (tk.hasMoreTokens()) {
            v.add(tk.nextToken());
        }
        return v;
    }

    public static boolean isLiteral() {
        return false;
    }

    public String toString() {
        String result = "[";
        if (this.fieldNames.size() > 0) {
            Iterator i = this.fieldNames.iterator();
            while (i.hasNext()) {
                String fieldName = i.next().toString();
                result = String.valueOf(result) + fieldName + ": " + this.contents.get(fieldName);
                if (!i.hasNext()) continue;
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "]";
        } else {
            result = this.contents.toString();
        }
        return result;
    }

    public String traceChange(ADT adt) {
        if (adt instanceof TupleSort) {
            TupleSort t = (TupleSort)adt;
            if (!this.fieldNames.equals(t.fieldNames)) {
                return t.toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Tuple, modified fields: {");
            Iterator it1 = this.fieldNames.iterator();
            while (it1.hasNext()) {
                ADT value2;
                String field = it1.next().toString();
                ADT value1 = (ADT)this.getValue(field);
                if (value1.equals(value2 = (ADT)t.getValue(field))) continue;
                sb.append("[" + field + " -> " + value1.traceChange(value2) + "] ");
            }
            return sb.append('}').toString();
        }
        return adt.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TupleSort)) {
            return false;
        }
        return this.equals((TupleSort)o);
    }

    public boolean equals(TupleSort o) {
        return this.contents.equals(o.contents);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public SValue toSValue() {
        SList rep = new SList();
        for (String name : this.fieldNames) {
            ADT adt = (ADT)this.contents.get(name);
            rep.add((Object)SExp.makeSList((SValue)new SString(name), (SValue)adt.toSValue()));
        }
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        TupleSort tuple = new TupleSort();
        SList rep = (SList)svalue;
        for (SList pair2 : rep) {
            String name = pair2.getSValue(0).toString();
            ADT adt = ADT.construct(pair2.getSValue(1));
            tuple.fieldNames.add(name);
            tuple.contents.put(name, adt);
        }
        return tuple;
    }

    protected Set getElementsImpl() throws NotEnumerableException {
        Set result = new HashSet();
        ArrayList startValues = new ArrayList(this.fieldNames.size());
        result = this.getElementsImplRecurse(startValues, 0);
        return result;
    }

    private Set getElementsImplRecurse(List valuesSoFar, int fieldIndex) throws NotEnumerableException {
        if (fieldIndex == this.fieldNames.size()) {
            HashSet<TupleSort> result = new HashSet<TupleSort>();
            TupleSort onlyResult = new TupleSort();
            onlyResult.fieldNames = this.fieldNames;
            int i = 0;
            while (i < fieldIndex) {
                onlyResult.setValue((String)this.fieldNames.get(i), valuesSoFar.get(i));
                ++i;
            }
            result.add(onlyResult);
            return result;
        }
        HashSet result = new HashSet();
        ADT stubValue = (ADT)this.getValue((String)this.fieldNames.get(fieldIndex));
        Set oneField = stubValue.getElements();
        for (Object oneValue : oneField) {
            ArrayList newValues = new ArrayList(valuesSoFar);
            newValues.add(oneValue);
            result.addAll(this.getElementsImplRecurse(newValues, fieldIndex + 1));
        }
        return result;
    }
}

