/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.StringSort;
import com.veromodo.tioa.runtime.adt.TreeRepException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class TreeSort
extends ADT
implements Serializable {
    private TreeSort left;
    private TreeSort right;
    private Object e;
    private static final TreeSort treeNull = new TreeSort(new StringSort("TreeNull"), null, null);

    private TreeSort(Object e) {
        if (e == null) {
            throw new TreeRepException("Trees cannot have null elements");
        }
        this.left = this.right = treeNull;
        this.e = e;
    }

    private TreeSort(Object e, TreeSort left, TreeSort right) {
        if (e == null) {
            throw new TreeRepException("Trees cannot have null elements");
        }
        this.e = e;
        this.left = left;
        this.right = right;
    }

    public static boolean isLiteral() {
        return false;
    }

    public static BoolSort isLeaf(TreeSort t) {
        return BoolSort.lit(t.left == treeNull && t.right == treeNull);
    }

    public static BoolSort hasLeft(TreeSort t) {
        if (t == treeNull) {
            throw new TreeRepException("Cannot take the left child of treeNull");
        }
        return BoolSort.lit(t.left != treeNull);
    }

    public static BoolSort hasRight(TreeSort t) {
        if (t == treeNull) {
            throw new TreeRepException("Cannot take the right child of treeNull");
        }
        return BoolSort.lit(t.right != treeNull);
    }

    public static Object content(TreeSort t) {
        if (t.e == null) {
            throw new TreeRepException("This tree has null content");
        }
        if (t == treeNull) {
            throw new TreeRepException("Null trees do not have content");
        }
        return t.e;
    }

    public static TreeSort left(TreeSort t) {
        if (t == treeNull) {
            throw new TreeRepException("Cannot take the left child of treeNull");
        }
        if (t.left == treeNull) {
            throw new TreeRepException("This node does not have a left child", t);
        }
        return t.left;
    }

    public static TreeSort right(TreeSort t) {
        if (t == treeNull) {
            throw new TreeRepException("Cannot take the right child of treeNull");
        }
        if (t.right == treeNull) {
            throw new TreeRepException("This node does not have a right child", t);
        }
        return t.right;
    }

    public static TreeSort makeTreeNoChild(Object e) {
        return new TreeSort(e);
    }

    public static TreeSort makeTreeLeftChild(Object e, TreeSort left) {
        return new TreeSort(e, left, treeNull);
    }

    public static TreeSort makeTreeRightChild(Object e, TreeSort right) {
        return new TreeSort(e, treeNull, right);
    }

    public static TreeSort makeTreeTwoChild(Object e, TreeSort left, TreeSort right) {
        return new TreeSort(e, left, right);
    }

    public static ADT construct(Parameterization p) {
        return new TreeSort(new String("Generic Tree"));
    }

    public String toString() {
        String retval = "(Tree: " + this.e + " {";
        retval = this.left == treeNull || this.left == null ? String.valueOf(retval) + "()" : String.valueOf(retval) + this.left.toStringLite();
        retval = String.valueOf(retval) + ", ";
        retval = this.right == treeNull || this.right == null ? String.valueOf(retval) + "()" : String.valueOf(retval) + this.right.toStringLite();
        retval = String.valueOf(retval) + "})";
        return retval;
    }

    private String toStringLite() {
        String retval = "(Tree: " + this.e + " ...)";
        return retval;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof TreeSort) {
            return this.equals((TreeSort)o);
        }
        return false;
    }

    public boolean equals(TreeSort t) {
        if (this == t) {
            return true;
        }
        if (this == treeNull || t == treeNull) {
            return false;
        }
        if (!this.e.equals(t.e)) {
            return false;
        }
        if (this.left == treeNull) {
            return t.left == treeNull;
        }
        if (this.right == treeNull) {
            return t.right == treeNull;
        }
        if (t.left == treeNull || t.right == treeNull) {
            return false;
        }
        return this.left.equals(t.left) && this.right.equals(t.right);
    }

    public int hashCode() {
        int retval = this.e.hashCode();
        if (this != treeNull) {
            if (this.left != treeNull) {
                retval ^= this.left.hashCode();
            }
            if (this.right != treeNull) {
                retval ^= this.right.hashCode();
            }
        }
        return retval;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.left == null && this.right == null ? treeNull : this;
    }

    public SValue toSValue() {
        if (this == treeNull) {
            return this.toSValue((SValue)new SString("treeNull"));
        }
        SList rep = new SList();
        rep.add((Object)this.left.toSValue());
        rep.add((Object)((ADT)this.e).toSValue());
        rep.add((Object)this.right.toSValue());
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        if (svalue instanceof SString) {
            return treeNull;
        }
        SList rep = (SList)svalue;
        ADT left = ADT.construct(rep.getSValue(0));
        ADT element = ADT.construct(rep.getSValue(1));
        ADT right = ADT.construct(rep.getSValue(2));
        return new TreeSort(element, (TreeSort)left, (TreeSort)right);
    }
}

