/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.ComparableADT;
import com.veromodo.tioa.runtime.adt.NatSort;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class TimedInvocationSort
extends ComparableADT
implements Serializable {
    protected ADT invocation;
    protected NatSort node;
    protected NatSort time;

    public static ADT construct(Parameterization p) {
        return TimedInvocationSort.make(p.constructSubsort(0), (NatSort)NatSort.construct(new Parameterization()), (NatSort)NatSort.construct(new Parameterization()));
    }

    public TimedInvocationSort(ADT invocation, NatSort node, NatSort time) {
        this.invocation = invocation;
        this.node = node;
        this.time = time;
    }

    public int compareTo(Object o) {
        TimedInvocationSort t = (TimedInvocationSort)o;
        if (this.time.equals(t.time) && this.node.equals(t.node) && !this.invocation.equals(t.invocation)) {
            throw new RepException("TimedInvocations with equals times and nodes must have equal invocations; otherwise the we'll violate the compareTo() contract.");
        }
        if (this.time.equals(t.time)) {
            return this.node.compareTo(t.node);
        }
        return this.time.compareTo(t.time);
    }

    public boolean equals(Object o) {
        if (o instanceof TimedInvocationSort) {
            TimedInvocationSort t = (TimedInvocationSort)o;
            if (!this.invocation.equals(t.invocation)) {
                return false;
            }
            if (!this.node.equals(t.node)) {
                return false;
            }
            return this.time.equals(t.time);
        }
        return false;
    }

    public int hashCode() {
        return this.invocation.hashCode() + this.node.hashCode() + this.time.hashCode();
    }

    public String toString() {
        return "[" + this.invocation + ", " + this.node + ", " + this.time + "]";
    }

    public static TimedInvocationSort make(ADT invocation, NatSort node, NatSort time) {
        return new TimedInvocationSort(invocation, node, time);
    }

    public static BoolSort gt(TimedInvocationSort t1, TimedInvocationSort t2) {
        return BoolSort.lit(t1.compareTo(t2) > 0);
    }

    public static TimedInvocationSort setInvocation(TimedInvocationSort t, ADT invocation) {
        return TimedInvocationSort.make(invocation, t.node, t.time);
    }

    public static TimedInvocationSort setNode(TimedInvocationSort t, NatSort node) {
        return TimedInvocationSort.make(t.invocation, node, t.time);
    }

    public static TimedInvocationSort setTime(TimedInvocationSort t, NatSort time) {
        return TimedInvocationSort.make(t.invocation, t.node, time);
    }

    public static ADT getInvocation(TimedInvocationSort t) {
        return t.invocation;
    }

    public static NatSort getNode(TimedInvocationSort t) {
        return t.node;
    }

    public static NatSort getTime(TimedInvocationSort t) {
        return t.time;
    }

    public SValue toSValue() {
        SList rep = new SList();
        rep.add((Object)this.invocation.toSValue());
        rep.add((Object)this.node.toSValue());
        rep.add((Object)this.time.toSValue());
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        SList rep = (SList)svalue;
        ADT invocation = ADT.construct(rep.getSValue(0));
        NatSort node = (NatSort)ADT.construct(rep.getSValue(1));
        NatSort time = (NatSort)ADT.construct(rep.getSValue(2));
        return new TimedInvocationSort(invocation, node, time);
    }
}

