/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.CharSort;
import com.veromodo.tioa.runtime.adt.ComparableADT;
import com.veromodo.tioa.runtime.adt.IntSort;
import com.veromodo.tioa.runtime.adt.Number;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class StringSort
extends ComparableADT
implements Serializable {
    protected String string;

    public static StringSort empty() {
        return new StringSort();
    }

    public static StringSort append(StringSort s, CharSort c) {
        return s.append(c);
    }

    public static StringSort prepend(CharSort c, StringSort s) {
        return s.prepend(c);
    }

    public static StringSort catenate(StringSort s1, StringSort s2) {
        return s1.catenate(s2);
    }

    public static BoolSort in(CharSort c, StringSort s) {
        return s.in(c);
    }

    public static CharSort head(StringSort s) {
        return s.head();
    }

    public static CharSort last(StringSort s) {
        return s.last();
    }

    public static StringSort tail(StringSort s) {
        return s.tail();
    }

    public static StringSort init(StringSort s) {
        return s.init();
    }

    public static IntSort len(StringSort s) {
        return s.len();
    }

    public static CharSort index(StringSort s, IntSort i) {
        return s.index(i);
    }

    public static BoolSort lt(StringSort s1, StringSort s2) {
        return s1.lt(s2);
    }

    public static BoolSort lte(StringSort s1, StringSort s2) {
        return s1.lte(s2);
    }

    public static BoolSort gt(StringSort s1, StringSort s2) {
        return s1.gt(s2);
    }

    public static BoolSort gte(StringSort s1, StringSort s2) {
        return s1.gte(s2);
    }

    public StringSort() {
        this.string = "";
    }

    public StringSort(String string) {
        this.string = string;
    }

    public static ADT construct(Parameterization p) {
        return StringSort.empty();
    }

    public String toString() {
        return this.string;
    }

    public BoolSort in(CharSort c) {
        return BoolSort.lit(this.string.indexOf(c.toString()) != -1);
    }

    public IntSort len() {
        return IntSort.lit(this.string.length());
    }

    public CharSort index(Number i) {
        if ((int)i.value < 0) {
            throw new RepException("Index given to StringSort was less than 0");
        }
        if ((int)i.value <= this.string.length() - 1) {
            return new CharSort(new Character(this.string.charAt((int)i.value)));
        }
        throw new RepException("Can't take index " + i + " because the String isn't that long.");
    }

    public int compareTo(Object o) {
        StringSort s = (StringSort)o;
        return this.string.compareTo(s.string);
    }

    public BoolSort lt(StringSort s) {
        return BoolSort.lit(this.compareTo(s) < 0);
    }

    public BoolSort lte(StringSort s) {
        return BoolSort.lit(this.compareTo(s) <= 0);
    }

    public BoolSort gt(StringSort s) {
        return BoolSort.lit(this.compareTo(s) > 0);
    }

    public BoolSort gte(StringSort s) {
        return BoolSort.lit(this.compareTo(s) >= 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringSort)) {
            return false;
        }
        StringSort s = (StringSort)o;
        return this.string.equals(s.string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean isEmpty() {
        return this.string.length() == 0;
    }

    public StringSort append(CharSort c) {
        return new StringSort(String.valueOf(this.string) + c.toString());
    }

    public StringSort prepend(CharSort c) {
        return new StringSort(String.valueOf(c.toString()) + this.string);
    }

    public StringSort catenate(StringSort s) {
        return new StringSort(String.valueOf(this.string) + s.string);
    }

    public CharSort head() {
        if (!this.isEmpty()) {
            return CharSort.lit(new Character(this.string.charAt(0)));
        }
        throw new RepException("Attempt to take head() of empty StringSort");
    }

    public CharSort last() {
        if (!this.isEmpty()) {
            return CharSort.lit(new Character(this.string.charAt(this.string.length() - 1)));
        }
        throw new RepException("Attempt to take last() of empty StringSort");
    }

    public StringSort tail() {
        if (!this.isEmpty()) {
            return new StringSort(this.string.substring(1, this.string.length()));
        }
        throw new RepException("Attempt to take tail() of empty StringSort");
    }

    public StringSort init() {
        if (!this.isEmpty()) {
            return new StringSort(this.string.substring(0, this.string.length() - 1));
        }
        throw new RepException("Attempt to take init() of empty StringSort");
    }

    public SValue toSValue() {
        SString rep = new SString(this.string);
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        return new StringSort(svalue.toString());
    }
}

