/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.IntSort;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;

public class StackSort
extends ADT
implements Cloneable,
Serializable {
    protected Stack stack = new Stack();

    public static ADT construct(Parameterization p) {
        return StackSort.empty();
    }

    public static BoolSort isEmpty(StackSort s) {
        return BoolSort.lit(s.isEmpty());
    }

    public static StackSort empty() {
        return new StackSort();
    }

    public static StackSort push(ADT o, StackSort s) {
        return s.push(o);
    }

    public static ADT top(StackSort s) {
        return s.top();
    }

    public static StackSort pop(StackSort s) {
        return s.pop();
    }

    public static IntSort count(ADT a, StackSort s) {
        return IntSort.lit(s.count(a));
    }

    public static IntSort size(StackSort s) {
        return IntSort.lit(s.size());
    }

    public static BoolSort isIn(ADT a, StackSort s) {
        return BoolSort.lit(s.isIn(a));
    }

    public static BoolSort isNotIn(ADT a, StackSort s) {
        return BoolSort.lit(s.isNotIn(a));
    }

    public boolean isEmpty() {
        return this.stack.empty();
    }

    public ADT top() {
        try {
            return (ADT)this.stack.peek();
        }
        catch (EmptyStackException ese) {
            throw new RepException("attempt to take top of an empty Stack");
        }
    }

    public int count(ADT a) {
        return this.countHelp(a, 0, 0);
    }

    protected int countHelp(ADT a, int index, int result) {
        int current = this.stack.indexOf(a, index);
        if (current != -1) {
            return this.countHelp(a, ++current, ++result);
        }
        return result;
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isIn(ADT o) {
        return this.stack.contains(o);
    }

    public boolean isNotIn(ADT o) {
        return !this.isIn(o);
    }

    public boolean equals(Object o) {
        if (!(o instanceof StackSort)) {
            return false;
        }
        StackSort stack2 = (StackSort)o;
        if (this.size() != stack2.size()) {
            return false;
        }
        Enumeration e1 = this.stack.elements();
        Enumeration e2 = stack2.stack.elements();
        while (e1.hasMoreElements()) {
            if (e1.nextElement().equals(e2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        Enumeration iter = this.stack.elements();
        while (iter.hasMoreElements()) {
            result += iter.nextElement().hashCode();
        }
        return result;
    }

    public Object clone() {
        StackSort result = new StackSort();
        result.stack = (Stack)this.stack.clone();
        return result;
    }

    public StackSort push(ADT o) {
        StackSort result = (StackSort)this.clone();
        result.stack.push(o);
        return result;
    }

    public List toList() {
        return Collections.unmodifiableList(this.stack);
    }

    public StackSort pop() {
        try {
            StackSort result = (StackSort)this.clone();
            result.stack.pop();
            return result;
        }
        catch (EmptyStackException e) {
            throw new RepException("popped an empty stack");
        }
    }

    public String toString() {
        String result = "(";
        Enumeration iter = this.stack.elements();
        while (iter.hasMoreElements()) {
            result = String.valueOf(result) + iter.nextElement() + " ";
        }
        return String.valueOf(result.trim()) + ")";
    }

    public SValue toSValue() {
        SList rep = new SList();
        for (ADT adt : this.stack) {
            rep.add((Object)adt.toSValue());
        }
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        StackSort stack = StackSort.empty();
        SList rep = (SList)svalue;
        for (SValue s : rep) {
            stack.stack.add(ADT.construct(s));
        }
        return stack;
    }
}

